/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Listener;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Listener.JSListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSListenerClass
implements JSListener {
    protected JSListener JSListener = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSListenerClass.class);
    public static final Integer DEBUG_LEVEL1 = new Integer(1);
    public static final Integer DEBUG_LEVEL2 = new Integer(2);
    public static final Integer DEBUG_LEVEL3 = new Integer(3);
    public static final Integer DEBUG_LEVEL4 = new Integer(4);
    public static final Integer DEBUG_LEVEL5 = new Integer(5);
    public static final Integer DEBUG_LEVEL6 = new Integer(6);
    public static final Integer DEBUG_LEVEL7 = new Integer(7);
    public static final Integer DEBUG_LEVEL8 = new Integer(8);
    public static final Integer DEBUG_LEVEL9 = new Integer(9);
    public static Integer intMaxDebugLevel = 0;
    public static boolean bolLogDebugInformation = true;
    public final String conClassName = "JSListenerClass";

    @Override
    public void message(String msg) {
        StringBuilder sb = new StringBuilder(this.getTime()).append(" ").append(msg);
        if (this.JSListener != null) {
            this.JSListener.message(sb.toString());
        } else {
            LOGGER.info(sb.toString());
        }
    }

    public JSListener getListener() {
        return this.JSListener;
    }

    public void registerMessageListener(JSListener l) {
        this.JSListener = l;
    }

    public void signalAbort(String msg) throws Exception {
        String def = " ###ProgramAbort### ";
        String message = def + msg + def;
        this.message(message);
        throw new JobSchedulerException(message);
    }

    public void signalInfo(String msg) {
        this.message(msg);
    }

    public void signalError(JobSchedulerException ex, String msg) {
        String def = " ### Error ### ";
        String message = def + msg + def;
        this.message(msg);
        if (ex != null) {
            ex.message(message);
            throw ex;
        }
    }

    public void signalError(String msg) {
        this.signalError(new JobSchedulerException(msg), msg);
    }

    public void signalDebug(String msg) {
        this.signalDebug(msg, 5);
    }

    public void signalDebug(String msg, Integer level) {
        if (!bolLogDebugInformation) {
            return;
        }
        if (intMaxDebugLevel == null) {
            intMaxDebugLevel = DEBUG_LEVEL9;
        }
        if (level > intMaxDebugLevel) {
            return;
        }
        this.message("DEBUG(" + level + "):>>> " + msg + " <<<");
    }

    public String getDateTimeFormatted(String dateTime) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateTime);
        Calendar now = Calendar.getInstance();
        return formatter.format(now.getTime()).toString();
    }

    public String getISODate() {
        return this.getDateTimeFormatted("yyyy-MM-dd'T'HH:mm:ss");
    }

    public String getTime() {
        return this.getDateTimeFormatted("HH:mm:ss");
    }
}

