/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionFolderName;
import java.io.File;

public class JSOptionPropertyFolderName
extends SOSOptionFolderName {
    private static final long serialVersionUID = -5962741104646578748L;
    private static final String CLASSNAME = "JSOptionPropertyFolderName";

    public JSOptionPropertyFolderName(JSOptionsClass pPobjParent, String pPstrKey, String pPstrDescription, String pPstrValue, String pPstrDefaultValue, boolean pPflgIsMandatory) {
        super(pPobjParent, pPstrKey, "Java-Property user.dir", pPstrValue, pPstrDefaultValue, pPflgIsMandatory);
    }

    @Override
    public void setValue(String pstrFolderName) {
        String methodName = "JSOptionPropertyFolderName::Value";
        pstrFolderName = this.checkIsFileWritable(pstrFolderName, "JSOptionPropertyFolderName::Value");
        super.setValue(pstrFolderName);
        if (this.isNotEmpty(this.strValue)) {
            System.setProperty("user.dir", this.strValue);
        }
    }

    @Override
    public String getValue() {
        return System.getProperty("user.dir");
    }

    private String checkIsFileWritable(String pstrFileName, String pstrMethodName) {
        String strT = null;
        if (this.isNotEmpty(pstrFileName)) {
            try {
                File fleF = new File(pstrFileName);
                if (!fleF.exists()) {
                    fleF.createNewFile();
                }
                if (!fleF.canWrite()) {
                    strT = String.format("%2$s: File '%1$s'. canWrite returns false. Check permissions.", pstrFileName, pstrMethodName);
                    strT = strT + fleF.toString();
                }
            }
            catch (Exception objException) {
                strT = String.format("%2$s: File '%1$s'. Exception thrown. Check permissions.", pstrFileName, pstrMethodName);
                JobSchedulerException objJSEx = new JobSchedulerException(strT, objException);
                this.signalError(objJSEx, strT);
            }
            if (strT != null) {
                this.signalError(strT);
            }
        }
        return pstrFileName;
    }
}

