/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionStringValueList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSOptionAuthenticationMethod
extends SOSOptionStringValueList {
    private static final long serialVersionUID = 806321970898790899L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSOptionAuthenticationMethod.class);
    private static final String PASSWORD = "password";
    private static final String PUBLICKEY = "publickey";
    private static final String URL = "url";
    private static final String KEYBOARD_INTERACTIVE = "keyboard-interactive";
    private enuAuthenticationMethods enuMethod = enuAuthenticationMethods.notDefined;

    public SOSOptionAuthenticationMethod(JSOptionsClass pPobjParent, String pPstrKey, String pPstrDescription, String pPstrValue, String pPstrDefaultValue, boolean pPflgIsMandatory) {
        super(pPobjParent, pPstrKey, pPstrDescription, pPstrValue, pPstrDefaultValue, pPflgIsMandatory);
        super.valueList(enuAuthenticationMethods.getArray());
    }

    @Override
    public String getControlType() {
        return "combo";
    }

    @Override
    public void setValue(String method) {
        try {
            if (this.isNull(method)) {
                super.setValue(method);
                this.enuMethod = enuAuthenticationMethods.notDefined;
            } else {
                switch (method) {
                    case "ppk": 
                    case "privatekey": 
                    case "publickey": {
                        super.setValue(method);
                        this.enuMethod = enuAuthenticationMethods.publicKey;
                        break;
                    }
                    case "password": {
                        super.setValue(method);
                        this.enuMethod = enuAuthenticationMethods.password;
                        break;
                    }
                    case "url": {
                        super.setValue(method);
                        this.enuMethod = enuAuthenticationMethods.url;
                        break;
                    }
                    case "keyboard-interactive": {
                        super.setValue(method);
                        this.enuMethod = enuAuthenticationMethods.keyboardInteractive;
                        break;
                    }
                    default: {
                        super.setValue("*invalid*: " + method);
                        this.enuMethod = enuAuthenticationMethods.notDefined;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setValue(enuAuthenticationMethods method) {
        switch (method) {
            case password: {
                super.setValue(PASSWORD);
                this.enuMethod = method;
                break;
            }
            case publicKey: 
            case privatekey: 
            case ppk: {
                super.setValue(PUBLICKEY);
                this.enuMethod = method;
                break;
            }
            case url: {
                super.setValue(URL);
                this.enuMethod = method;
                break;
            }
            case keyboardInteractive: {
                super.setValue(KEYBOARD_INTERACTIVE);
                this.enuMethod = method;
                break;
            }
            default: {
                throw new JobSchedulerException("Invalid AuthenticationMethod : " + (Object)((Object)method));
            }
        }
    }

    public void isPassword(boolean value) {
        if (value) {
            this.setValue(PASSWORD);
        } else {
            this.setValue(PUBLICKEY);
        }
    }

    public void isURL(boolean value) {
        if (value) {
            this.setValue(URL);
        } else {
            this.setValue(URL);
        }
    }

    public void isKeyboardInteractive(boolean value) {
        if (value) {
            this.setValue(KEYBOARD_INTERACTIVE);
        } else {
            this.setValue(PASSWORD);
        }
    }

    public boolean isPassword() {
        this.setValue(this.strValue);
        return this.enuMethod == enuAuthenticationMethods.password;
    }

    public boolean isURL() {
        this.setValue(this.strValue);
        return this.enuMethod == enuAuthenticationMethods.url;
    }

    public boolean isPublicKey() {
        this.setValue(this.strValue);
        return this.enuMethod == enuAuthenticationMethods.publicKey || this.enuMethod == enuAuthenticationMethods.ppk || this.enuMethod == enuAuthenticationMethods.privatekey;
    }

    public boolean isKeyboardInteractive() {
        this.setValue(this.strValue);
        return this.enuMethod == enuAuthenticationMethods.keyboardInteractive;
    }

    public enuAuthenticationMethods getAuthenticationMethod() {
        return this.enuMethod;
    }

    public static enum enuAuthenticationMethods {
        publicKey("publickey"),
        password("password"),
        url("url"),
        notDefined("undefined"),
        ppk("ppk"),
        privatekey("privatekey"),
        keyboardInteractive("keyboard-interactive");

        public final String description;
        public final String text;

        private enuAuthenticationMethods() {
            this(null);
        }

        public String getText() {
            return this.name();
        }

        private enuAuthenticationMethods(String name) {
            String k = name == null ? this.name() : name;
            this.description = k;
            this.text = k;
        }

        public static String[] getArray() {
            String[] arr = new String[7];
            int i = 0;
            for (enuAuthenticationMethods method : enuAuthenticationMethods.values()) {
                arr[i++] = method.name();
            }
            return arr;
        }
    }
}

