/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionFileString;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSOptionHexString
extends SOSOptionFileString {
    private static final long serialVersionUID = 5459978964312384049L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSOptionHexString.class);

    public SOSOptionHexString(JSOptionsClass pPobjParent, String pPstrKey, String pPstrDescription, String pPstrValue, String pPstrDefaultValue, boolean pPflgIsMandatory) {
        super(pPobjParent, pPstrKey, pPstrDescription, pPstrValue, pPstrDefaultValue, pPflgIsMandatory);
    }

    @Override
    public String getValue() {
        String strV = this.strValue;
        if (this.isNotEmpty(strV) && this.isHex(strV)) {
            try {
                strV = new String(this.fromHexString(strV), "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (strV.indexOf("&") > -1) {
            strV = this.unescapeXML(strV);
        }
        return strV;
    }

    public String unescapeXML() {
        return this.unescapeXML(this.strValue);
    }

    public String unescapeXML(String pstrValue) {
        String newValue = pstrValue;
        if (newValue.indexOf("&") != -1) {
            newValue = newValue.replaceAll("&quot;", "\"");
            newValue = newValue.replaceAll("&lt;", "<");
            newValue = newValue.replaceAll("&gt;", ">");
            newValue = newValue.replaceAll("&amp;", "&");
            newValue = newValue.replaceAll("&apos;", "'");
            newValue = newValue.replaceAll("&#13;", "\r");
            newValue = newValue.replaceAll("&#x0d;", "\r");
            newValue = newValue.replaceAll("&#xd;", "\r");
            newValue = newValue.replaceAll("&#09;", "\t");
            newValue = newValue.replaceAll("&#9;", "\t");
            newValue = newValue.replaceAll("&#10;", "\n");
            newValue = newValue.replaceAll("&#x0a;", "\n");
            newValue = newValue.replaceAll("&#xa;", "\n");
        }
        return newValue;
    }

    public byte[] fromHexString() {
        return this.fromHexString(this.strValue);
    }

    public byte[] fromHexString(String s) throws IllegalArgumentException {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new JobSchedulerException(String.format("fromHexString '%1$s' requires an even number of hex characters", s));
        }
        byte[] b = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = this.charToNibble(s.charAt(i));
            int low = this.charToNibble(s.charAt(i + 1));
            b[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return b;
    }

    private int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new JobSchedulerException("Invalid hex character: " + c);
    }

    public boolean isHex() {
        boolean flgRet = this.isHex(this.strValue);
        return flgRet;
    }

    public final boolean isHex(String pstrHexString) {
        boolean flgRet = false;
        if (this.isNotEmpty(pstrHexString)) {
            flgRet = true;
            for (int i = 0; i < pstrHexString.length(); ++i) {
                if (this.isHexStringChar(pstrHexString.charAt(i))) continue;
                flgRet = false;
                break;
            }
        }
        return flgRet;
    }

    public final boolean isHexStringChar(char c) {
        return Character.isDigit(c) || Character.isWhitespace(c) || "0123456789abcdefABCDEF".indexOf(c) >= 0;
    }
}

