/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionElement;
import java.util.Vector;

public class SOSOptionIntegerArray
extends SOSOptionElement {
    private static final long serialVersionUID = -7864986512950989666L;
    private Vector<Integer> result = new Vector();

    public SOSOptionIntegerArray(JSOptionsClass pobjParent, String pstrKey, String pstrDescription, String pstrValue, String pstrDefaultValue, boolean pflgIsMandatory) {
        super(pobjParent, pstrKey, pstrDescription, pstrValue, pstrDefaultValue, pflgIsMandatory);
        this.setValue(pstrValue);
        this.description(pstrDescription);
    }

    @Override
    public void setValue(String pstrValue) {
        try {
            super.setValue(pstrValue);
            this.parseValue2Vector();
        }
        catch (Exception e) {
            throw new JobSchedulerException("Illegal/Invalid value '" + pstrValue + "' for Option " + this.getDescription() + ", " + this.strKey, e);
        }
    }

    public boolean contains(int pintValue) {
        boolean flgContains = false;
        flgContains = this.getValues().contains(new Integer(pintValue));
        return flgContains;
    }

    public Vector<Integer> getValues() {
        return this.result;
    }

    private void parseValue2Vector() throws Exception {
        if (this.getValue() != null) {
            String[] elements = this.getValue().split("[,| |;]");
            this.result = new Vector();
            for (String element : elements) {
                if ((element = element.trim()).isEmpty()) continue;
                if (element.indexOf("-") == -1) {
                    try {
                        this.result.add(new Integer(element));
                        continue;
                    }
                    catch (Exception e) {
                        throw new JobSchedulerException("Illegal numeric value : " + element, e);
                    }
                }
                String[] range = element.split("-");
                int from = 0;
                int to = 0;
                try {
                    from = Integer.parseInt(range[0].trim());
                    to = Integer.parseInt(range[1].trim());
                }
                catch (Exception e) {
                    throw new JobSchedulerException("Illegal numeric value : " + element, e);
                }
                int stepSize = 1;
                for (int j = from; j <= to; j += stepSize) {
                    this.result.add(new Integer(j));
                }
            }
        }
    }

    @Override
    public String toString() {
        String strTemp = super.toString();
        if (!this.result.isEmpty()) {
            strTemp = strTemp + " [";
            for (Integer intVal : this.result) {
                strTemp = strTemp + intVal.toString() + " ";
            }
            strTemp = strTemp + "]";
        }
        return strTemp;
    }
}

