/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.System;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSCommandline {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSCommandline.class);

    public String[] splitArguments(String arguments) throws Exception {
        Object[] resultArguments = null;
        Vector<String> resultVector = new Vector<String>();
        int resultIndex = 0;
        String resultString = "";
        boolean inQuote = false;
        try {
            for (int i = 0; i < arguments.length(); ++i) {
                int pos1;
                int pos2;
                if (arguments.substring(i).startsWith("\\\"") && (pos2 = arguments.indexOf("\\\"", (pos1 = i) + 1)) > -1) {
                    resultString = arguments.substring(pos1, pos2 + 1);
                    resultVector.add(resultIndex++, resultString);
                    resultString = "";
                    i = pos2 + 1;
                    continue;
                }
                if (arguments.substring(i).startsWith("'") && (pos2 = arguments.indexOf("'", (pos1 = i) + 1)) > -1) {
                    resultString = arguments.substring(pos1, pos2 + 1);
                    resultVector.add(resultIndex++, resultString);
                    resultString = "";
                    i = pos2 + 1;
                    continue;
                }
                if (inQuote) {
                    resultString = resultString + arguments.charAt(i);
                    continue;
                }
                if (arguments.charAt(i) != ' ') {
                    resultString = resultString + arguments.charAt(i);
                    continue;
                }
                resultVector.add(resultIndex++, resultString);
                resultString = "";
            }
            if (!resultString.trim().isEmpty()) {
                resultVector.add(resultIndex++, resultString);
            }
            resultArguments = new String[resultIndex];
            resultVector.copyInto(resultArguments);
            return resultArguments;
        }
        catch (Exception e) {
            throw new Exception("error occurred splitting arguments: " + e.getMessage());
        }
    }

    public Vector<Object> execute(String command) {
        return this.execute(command, null);
    }

    public Vector<Object> execute(String command, Object objDummy) {
        Vector<Object> returnValues = new Vector<Object>();
        try {
            try {
                String line;
                Process p = Runtime.getRuntime().exec(this.splitArguments(command));
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                p.waitFor();
                LOGGER.debug("command returned exit code: " + p.exitValue());
                returnValues.add(0, new Integer(p.exitValue()));
                try {
                    line = "";
                    String stdout = "";
                    while (line != null) {
                        line = stdInput.readLine();
                        if (line == null) continue;
                        stdout = stdout + line;
                    }
                    if (stdout != null && !stdout.trim().isEmpty()) {
                        LOGGER.debug("Command returned output to stdout ...");
                    } else {
                        LOGGER.debug("Command did not return any output to stdout.");
                    }
                    returnValues.add(1, stdout);
                }
                catch (Exception ex) {
                    returnValues.add(1, "");
                    returnValues.add(2, ex.getMessage());
                    LOGGER.debug("error occurred processing stdout: " + ex.getMessage());
                }
                try {
                    line = "";
                    String stderr = "";
                    while (line != null) {
                        line = stdError.readLine();
                        if (line == null) continue;
                        stderr = stderr + line;
                    }
                    if (stderr != null && !stderr.trim().isEmpty()) {
                        LOGGER.debug("Command returned output to stderr ...");
                    } else {
                        LOGGER.debug("Command did not return any output to stderr.");
                    }
                    returnValues.add(2, stderr);
                }
                catch (Exception ex) {
                    returnValues.add(2, ex.getMessage());
                    LOGGER.debug("error occurred processing stderr: " + ex.getMessage());
                }
                if (stdInput != null) {
                    stdInput.close();
                }
                if (stdError != null) {
                    stdError.close();
                }
            }
            catch (Exception ex) {
                returnValues.add(0, new Integer(1));
                returnValues.add(1, "");
                returnValues.add(2, ex.getMessage());
                LOGGER.debug("error occurred executing command: " + ex.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.debug("Command could not be executed successfully: " + e.getMessage());
            returnValues.add(0, new Integer(1));
            returnValues.add(1, "");
            returnValues.add(2, e.getMessage());
        }
        return returnValues;
    }

    public String getExternalPassword(String password) {
        return this.getExternalPassword(password, null);
    }

    public String getExternalPassword(String password, Object objdummy) {
        String returnPassword = password;
        try {
            if (password != null && password.startsWith("`") && password.endsWith("`")) {
                String command = password.substring(1, password.length() - 1);
                LOGGER.debug("Trying to get password by executing command in backticks: " + command);
                Vector<Object> returnValues = this.execute(command, LOGGER);
                Integer exitValue = (Integer)returnValues.elementAt(0);
                if (exitValue.compareTo(new Integer(0)) == 0 && (String)returnValues.elementAt(1) != null) {
                    returnPassword = (String)returnValues.elementAt(1);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Using password string as password. Command could not be executed: " + e);
        }
        return returnPassword;
    }
}

