/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSThreadPoolExecutor.class);
    public int corePoolSize = 5;
    public int maxPoolSize = 8;
    public long keepAliveTime = 10L;
    public ExecutorService objThreadPool = null;

    public SOSThreadPoolExecutor() {
        this.objThreadPool = Executors.newFixedThreadPool(this.corePoolSize);
    }

    public SOSThreadPoolExecutor(int pintCorePoolSize) {
        this.objThreadPool = Executors.newFixedThreadPool(pintCorePoolSize);
        this.corePoolSize = pintCorePoolSize;
    }

    public Future<?> runTask(Runnable task) {
        return this.objThreadPool.submit(task);
    }

    public void shutDown() {
        this.objThreadPool.shutdown();
    }

    public static void main(String[] args) {
        SOSThreadPoolExecutor mtpe = new SOSThreadPoolExecutor(10);
        int cpus = Runtime.getRuntime().availableProcessors();
        LOGGER.debug("max avl cpus = " + cpus);
        for (int i = 0; i < 19; ++i) {
            mtpe.runTask(new WorkerRunnable(i));
        }
        mtpe.shutDown();
        LOGGER.debug("Finished! ");
    }

    private static class WorkerRunnable
    implements Runnable {
        private final int jobNr;

        public WorkerRunnable(int jobNr) {
            this.jobNr = jobNr;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10; ++i) {
                try {
                    long intNo = Thread.currentThread().getId();
                    LOGGER.debug("Task " + this.jobNr + ", calculated " + i + ", Thread ID = " + intNo);
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException ie) {
                    LOGGER.error(ie.getMessage(), (Throwable)ie);
                }
            }
        }
    }
}

