/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.io.Files;

import com.sos.JSHelper.Exceptions.JSExceptionMandatoryOptionMissing;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Listener.JSListener;
import com.sos.JSHelper.Options.JSOptionsClass;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSCsvFileOptions
extends JSOptionsClass {
    private static final long serialVersionUID = -8996877249675870658L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSCsvFileOptions.class);
    private static final String CLASSNAME = "JSCsvFileOptions";
    private static final String DELIMITER_SETTINGS_KEY = "JSCsvFileOptions.Delimiter";
    private static final String CSV_COLUMN_DELIMITER_SETTINGS_KEY = "JSCsvFileOptions.CSVColumnDelimiter";
    private static final String SKIP_FIRST_LINE_SETTINGS_KEY = "JSCsvFileOptions.Skip_First_Line";
    private static final String IGNORE_VALUE_DELIMITER_SETTINGS_KEY = "JSCsvFileOptions.IgnoreValueDelimiter";
    private String strDelimiter = String.valueOf('\u00fe');
    private boolean flgSkipFirstLine = true;
    private boolean flgIgnoreValueDelimiter = true;

    public JSCsvFileOptions() {
        this.currentClass = this.getClass();
    }

    public JSCsvFileOptions(JSListener pobjListener) {
        this.registerMessageListener(pobjListener);
    }

    public JSCsvFileOptions(HashMap<String, String> JSSettings) throws Exception {
        this.setAllOptions(JSSettings);
    }

    @Override
    public void toOut() {
        LOGGER.info(this.getAllOptionsAsString());
    }

    @Override
    public String toString() {
        return this.getAllOptionsAsString();
    }

    private String getAllOptionsAsString() {
        String strT = "JSCsvFileOptions\n";
        strT = strT + "Delimiter      Feld-Trennzeichen : " + this.getDelimiter() + "\n";
        strT = strT + "SkipFirstLine  Erste Zeile als \u00dcberschrift interpretieren und \u00fcberlesen : " + this.isSkipFirstLine() + "\n";
        strT = strT + "IgnoreValueDelimiter Ignore Value Delimiter : " + this.isIgnoreValueDelimiter() + "\n";
        return strT;
    }

    @Override
    public void setAllOptions(HashMap<String, String> settings) {
        try {
            super.setAllOptions(settings);
            String strT = super.getItem(DELIMITER_SETTINGS_KEY);
            if (this.isNotEmpty(strT)) {
                this.setDelimiter(strT);
            } else {
                this.setDelimiter(super.getItem(CSV_COLUMN_DELIMITER_SETTINGS_KEY));
            }
            this.setSkipFirstLine(this.getBoolItem(SKIP_FIRST_LINE_SETTINGS_KEY));
            this.setIgnoreValueDelimiter(this.getBoolItem(IGNORE_VALUE_DELIMITER_SETTINGS_KEY));
        }
        catch (Exception e) {
            throw new JobSchedulerException(e);
        }
    }

    private boolean getBoolItem(String pstrKey) {
        boolean flgT = false;
        if (this.isNotEmpty(pstrKey)) {
            flgT = super.string2Bool(this.getItem(pstrKey));
        }
        return flgT;
    }

    @Override
    public void checkMandatory() throws Exception {
        try {
            this.setDelimiter(this.getDelimiter());
        }
        catch (Exception e) {
            throw new JSExceptionMandatoryOptionMissing(e.toString());
        }
    }

    public String getDelimiter() {
        return this.strDelimiter;
    }

    public JSCsvFileOptions setDelimiter(String pstrDelimiter) throws Exception {
        if (pstrDelimiter == null) {
            this.signalError("JSCsvFileOptions:Delimiter is mandatory, must be not null");
        } else {
            this.strDelimiter = pstrDelimiter.matches("^[0-9]+$") ? String.valueOf((char)Integer.parseInt(pstrDelimiter)) : pstrDelimiter.substring(0, 1);
        }
        return this;
    }

    public boolean isSkipFirstLine() {
        return this.flgSkipFirstLine;
    }

    public JSCsvFileOptions setSkipFirstLine(boolean pflgSkipFirstLine) throws Exception {
        this.flgSkipFirstLine = pflgSkipFirstLine;
        return this;
    }

    public boolean isIgnoreValueDelimiter() {
        return this.flgIgnoreValueDelimiter;
    }

    public JSCsvFileOptions setIgnoreValueDelimiter(boolean pflgIgnoreValueDelimiter) throws Exception {
        this.flgIgnoreValueDelimiter = pflgIgnoreValueDelimiter;
        return this;
    }
}

