/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.io;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.SOSFileSystemOperations;
import java.io.File;

public class SOSFileSystemOperationsCopy
extends SOSFileSystemOperations {
    private static final String ACTION_NAME = "copyFiles: ";

    @Override
    protected String getActionName() {
        return ACTION_NAME;
    }

    @Override
    protected boolean handleOneFile(File source, File target, boolean overwrite, boolean gracious) throws Exception {
        boolean rc = false;
        if (source.equals(target)) {
            throw new JobSchedulerException("cannot copy file to itself: " + source.getCanonicalPath());
        }
        if (overwrite || !target.exists()) {
            long modificationDate = source.lastModified();
            rc = this.copyFile(source, target);
            target.setLastModified(modificationDate);
            LOGGER.info("copy " + source.getPath() + " to " + target.getPath());
            return rc;
        }
        if (!gracious) {
            throw new JobSchedulerException("file already exists: " + target.getCanonicalPath());
        }
        LOGGER.info("file already exists: " + target.getCanonicalPath());
        return rc;
    }
}

