/*
 * Decompiled with CFR 0.152.
 */
package com.sos.i18n;

import com.sos.JSHelper.Options.SOSOptionLocale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import java.util.ResourceBundle;

public class Msg
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static BundleBaseName s_bundleBasenameDefault = new BundleBaseName("messages");
    private BundleBaseName m_bundleBaseName;
    private static Locale m_locale;
    private String m_lastMessage;
    private String m_lastKey;
    private Object[] m_lastVarargs;
    private transient ResourceBundle m_bundle;
    private transient boolean m_getFailed;

    public static Msg createMsg(BundleBaseName basename, Locale locale, String key, Object ... varargs) {
        Msg msg = new Msg(basename, locale);
        msg.getMsg(key, varargs);
        if (msg.m_getFailed) {
            msg = new Msg(basename, new Locale("en"));
            msg.getMsg(key, varargs);
        }
        return msg;
    }

    public static Msg createMsg(Locale locale, String key, Object ... varargs) {
        Msg msg = new Msg(locale);
        msg.getMsg(key, varargs);
        return msg;
    }

    public static Msg createMsg(BundleBaseName basename, String key, Object ... varargs) {
        Msg msg = new Msg(basename);
        msg.getMsg(key, varargs);
        return msg;
    }

    public static Msg createMsg(String key, Object ... varargs) {
        Msg msg = new Msg();
        msg.getMsg(key, varargs);
        return msg;
    }

    public static BundleBaseName getBundleBaseNameDefault() {
        return s_bundleBasenameDefault;
    }

    public static void setBundleBaseNameDefault(BundleBaseName newDefault) {
        s_bundleBasenameDefault = newDefault;
    }

    public Msg(BundleBaseName basename, Locale locale) {
        if (basename == null) {
            basename = s_bundleBasenameDefault;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.m_getFailed = false;
        this.m_bundleBaseName = basename;
        m_locale = locale;
        this.m_bundle = null;
        this.m_lastMessage = null;
        this.m_lastKey = null;
        this.m_lastVarargs = null;
    }

    public Msg(Locale locale) {
        this(s_bundleBasenameDefault, locale);
    }

    public Msg(BundleBaseName basename) {
        this(basename, SOSOptionLocale.i18nLocale);
    }

    public Msg() {
        this(s_bundleBasenameDefault, Locale.getDefault());
    }

    public Locale getLocale() {
        return m_locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!locale.equals(this.getLocale())) {
            m_locale = locale;
            this.m_bundle = null;
        }
    }

    public BundleBaseName getBundleBaseName() {
        return this.m_bundleBaseName;
    }

    public String getLastMessage() {
        if (this.m_bundle == null && this.m_lastVarargs != null) {
            String lastMessageBackup = this.m_lastMessage;
            this.getMsg(this.m_lastKey, this.m_lastVarargs);
            if (this.m_getFailed) {
                this.m_lastMessage = lastMessageBackup;
            }
        }
        return this.m_lastMessage;
    }

    public String getMsg(String key, Object ... varargs) {
        String retMessage = null;
        try {
            if (this.m_bundle == null || !m_locale.equals(SOSOptionLocale.i18nLocale)) {
                this.m_bundle = this.getResourceBundle();
            }
            retMessage = this.m_bundle.getString(key);
            if (varargs.length > 0) {
                MessageFormat mf = new MessageFormat(retMessage, m_locale);
                retMessage = mf.format(varargs);
            }
            this.m_lastKey = key;
            this.m_lastVarargs = varargs;
            this.m_getFailed = false;
        }
        catch (Exception e) {
            this.m_getFailed = true;
            if (retMessage == null) {
                retMessage = key;
            }
            Formatter formatter = new Formatter();
            formatter.format("!!! missing resource message key=[%s] args=%s", retMessage, Arrays.asList(varargs));
            retMessage = formatter.toString();
            formatter.close();
        }
        this.m_lastMessage = retMessage;
        return retMessage;
    }

    public String toString() {
        return this.getLastMessage();
    }

    protected ResourceBundle getResourceBundle() {
        Locale locale = this.getLocale();
        BundleBaseName basename = this.getBundleBaseName();
        ResourceBundle bundle = ResourceBundle.getBundle(basename.getBundleBaseName(), locale);
        return bundle;
    }

    protected static byte[] serialize(Serializable object) throws Exception {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(byteStream);
        oos.writeObject(object);
        oos.close();
        return byteStream.toByteArray();
    }

    protected static Object deserialize(byte[] serializedData) throws Exception {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(serializedData);
        ObjectInputStream ois = new ObjectInputStream(byteStream);
        Object retObject = ois.readObject();
        ois.close();
        return retObject;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int varargsLength;
        byte[] varargs;
        out.writeObject(this.m_bundleBaseName);
        out.writeObject(m_locale);
        out.writeObject(this.m_lastMessage);
        out.writeObject(this.m_lastKey);
        try {
            varargs = Msg.serialize((Serializable)this.m_lastVarargs);
            varargsLength = varargs.length;
        }
        catch (Exception e) {
            varargs = null;
            varargsLength = -1;
        }
        out.writeInt(varargsLength);
        if (varargsLength != -1) {
            out.write(varargs);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_bundle = null;
        this.m_getFailed = false;
        this.m_bundleBaseName = (BundleBaseName)in.readObject();
        m_locale = (Locale)in.readObject();
        this.m_lastMessage = (String)in.readObject();
        this.m_lastKey = (String)in.readObject();
        this.m_lastVarargs = null;
        int varargsLength = in.readInt();
        if (varargsLength != -1) {
            byte[] varargs = new byte[varargsLength];
            try {
                in.readFully(varargs);
                this.m_lastVarargs = (Object[])Msg.deserialize(varargs);
            }
            catch (Exception e) {
                this.m_lastVarargs = null;
            }
        }
    }

    public static final class BundleBaseName
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String m_name;

        public BundleBaseName(String bundleBaseName) {
            this.m_name = bundleBaseName;
        }

        public BundleBaseName(String bundleBaseName, String pstrLocale) {
            this.m_name = bundleBaseName;
            m_locale = new Locale(pstrLocale);
        }

        public String getBundleBaseName() {
            return this.m_name;
        }

        public String toString() {
            return this.getBundleBaseName();
        }
    }
}

