/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.common;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.credentialstore.keepass.SOSKeePassDatabase;
import com.sos.commons.util.common.ASOSArguments;
import com.sos.commons.util.common.SOSArgument;
import com.sos.commons.util.common.SOSArgumentHelper;
import com.sos.commons.vfs.common.proxy.Proxy;
import java.net.Proxy;
import org.linguafranca.pwdb.Entry;

public abstract class AProviderArguments
extends ASOSArguments {
    private SOSArgument<Protocol> protocol = new SOSArgument("protocol", true);
    private SOSArgument<String> host = new SOSArgument("host", true);
    private SOSArgument<String> user = new SOSArgument("user", false);
    private SOSArgument<String> password = new SOSArgument("password", false, SOSArgumentHelper.DisplayMode.MASKED);
    private Proxy proxy;
    private SOSArgument<Proxy.Type> proxyType = new SOSArgument("proxy_type", false);
    private SOSArgument<String> proxyHost = new SOSArgument("proxy_host", false);
    private SOSArgument<Integer> proxyPort = new SOSArgument("proxy_port", false, (Object)-1);
    private SOSArgument<String> proxyUser = new SOSArgument("proxy_user", false);
    private SOSArgument<String> proxyPassword = new SOSArgument("proxy_password", false, SOSArgumentHelper.DisplayMode.MASKED);
    private SOSArgument<Integer> proxyConnectTimeout = new SOSArgument("proxy_connect_timeout", false, (Object)30);
    private SOSArgument<SOSKeePassDatabase> keepassDatabase = new SOSArgument(null, false);
    private SOSArgument<Entry<?, ?, ?, ?>> keepassDatabaseEntry = new SOSArgument(null, false);
    private SOSArgument<String> keepassAttachmentPropertyName = new SOSArgument(null, false);
    private CredentialStoreArguments credentialStore;

    public SOSArgument<Protocol> getProtocol() {
        return this.protocol;
    }

    public SOSArgument<String> getHost() {
        return this.host;
    }

    public SOSArgument<String> getUser() {
        return this.user;
    }

    public SOSArgument<String> getPassword() {
        return this.password;
    }

    public Proxy getProxy() {
        if (this.proxy != null) {
            return this.proxy;
        }
        this.tryCreateProxy();
        return this.proxy;
    }

    protected Proxy recreateProxy() {
        if (this.proxy == null) {
            return this.proxy;
        }
        this.tryCreateProxy();
        return this.proxy;
    }

    private void tryCreateProxy() {
        if (this.proxyType.getValue() != null && this.proxyHost.getValue() != null) {
            this.proxy = new Proxy((Proxy.Type)((Object)this.proxyType.getValue()), (String)this.proxyHost.getValue(), (Integer)this.proxyPort.getValue(), (String)this.proxyUser.getValue(), (String)this.proxyPassword.getValue(), this.asMs(this.proxyConnectTimeout));
        }
    }

    public void setProxy(Proxy val) {
        this.proxy = val;
    }

    protected SOSArgument<Proxy.Type> getProxyType() {
        return this.proxyType;
    }

    protected SOSArgument<String> getProxyHost() {
        return this.proxyHost;
    }

    protected SOSArgument<Integer> getProxyPort() {
        return this.proxyPort;
    }

    protected SOSArgument<String> getProxyUser() {
        return this.proxyUser;
    }

    protected SOSArgument<String> getProxyPassword() {
        return this.proxyPassword;
    }

    public SOSKeePassDatabase getKeepassDatabase() {
        return (SOSKeePassDatabase)this.keepassDatabase.getValue();
    }

    protected void setKeepassDatabase(SOSKeePassDatabase val) {
        this.keepassDatabase.setValue((Object)val);
    }

    public Entry<?, ?, ?, ?> getKeepassDatabaseEntry() {
        return (Entry)this.keepassDatabaseEntry.getValue();
    }

    protected void setKeepassDatabaseEntry(Entry<?, ?, ?, ?> val) {
        this.keepassDatabaseEntry.setValue(val);
    }

    public String getKeepassAttachmentPropertyName() {
        return (String)this.keepassAttachmentPropertyName.getValue();
    }

    protected void setKeepassAttachmentPropertyName(String val) {
        this.keepassAttachmentPropertyName.setValue((Object)val);
    }

    protected void setCredentialStore(CredentialStoreArguments val) {
        this.credentialStore = val;
    }

    public int asMs(SOSArgument<Integer> arg) {
        return arg.getValue() == null ? 0 : (Integer)arg.getValue() * 1000;
    }

    public CredentialStoreArguments getCredentialStore() {
        return this.credentialStore;
    }

    public static enum KeyStoreType {
        JKS,
        JCEKS,
        PKCS12,
        PKCS11,
        DKS;

    }

    public static enum Protocol {
        UNKNOWN(0),
        LOCAL(10),
        FTP(20),
        FTPS(21),
        SFTP(30),
        SSH(31),
        HTTP(40),
        HTTPS(41),
        WEBDAV(50),
        WEBDAVS(51),
        SMB(60);

        private final Integer value;

        private Protocol(Integer val) {
            this.value = val;
        }

        public Integer getValue() {
            return this.value;
        }
    }
}

