/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.common;

import com.sos.commons.util.common.SOSArgument;
import com.sos.commons.util.common.SOSArgumentHelper;
import com.sos.commons.vfs.common.AProviderArguments;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;

public class SSHProviderArguments
extends AProviderArguments {
    public static final String CLASS_KEY = "SSH_PROVIDER";
    private SOSArgument<Integer> port = new SOSArgument("port", true, (Object)22);
    private SOSArgument<String> passphrase = new SOSArgument("passphrase", false, SOSArgumentHelper.DisplayMode.MASKED);
    private SOSArgument<String> authFile = new SOSArgument("auth_file", false);
    private SOSArgument<AuthMethod> authMethod = new SOSArgument("auth_method", false);
    private SOSArgument<List<AuthMethod>> preferredAuthentications = new SOSArgument("preferred_authentications", false);
    private SOSArgument<List<AuthMethod>> requiredAuthentications = new SOSArgument("required_authentications", false);
    private SOSArgument<Integer> connectTimeout = new SOSArgument("connect_timeout", false, (Object)0);
    private SOSArgument<Integer> socketTimeout = new SOSArgument("socket_timeout", false, (Object)0);
    private SOSArgument<Integer> serverAliveInterval = new SOSArgument("server_alive_interval", false);
    private SOSArgument<Boolean> strictHostkeyChecking = new SOSArgument("strict_hostkey_checking", false, (Object)false);
    private SOSArgument<Path> hostkeyLocation = new SOSArgument("hostkey_location", false);
    private SOSArgument<Boolean> useZlibCompression = new SOSArgument("use_zlib_compression", false, (Object)false);
    private SOSArgument<Boolean> simulateShell = new SOSArgument("simulate_shell", false, (Object)false);
    private SOSArgument<Charset> remoteCharset = new SOSArgument("remote_charset", false, (Object)Charset.forName("UTF-8"));

    public SSHProviderArguments() {
        this.getProtocol().setDefaultValue((Object)AProviderArguments.Protocol.SFTP);
        this.getUser().setRequired(true);
    }

    public SOSArgument<Integer> getPort() {
        return this.port;
    }

    public SOSArgument<AuthMethod> getAuthMethod() {
        return this.authMethod;
    }

    public SOSArgument<String> getPassphrase() {
        return this.passphrase;
    }

    public SOSArgument<String> getAuthFile() {
        return this.authFile;
    }

    public SOSArgument<List<AuthMethod>> getPreferredAuthentications() {
        return this.preferredAuthentications;
    }

    public SOSArgument<List<AuthMethod>> getRequiredAuthentications() {
        return this.requiredAuthentications;
    }

    public SOSArgument<Integer> getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getConnectTimeoutAsMs() {
        return this.asMs(this.connectTimeout);
    }

    public SOSArgument<Integer> getSocketTimeout() {
        return this.socketTimeout;
    }

    public Integer getSocketTimeoutAsMs() {
        return this.asMs(this.socketTimeout);
    }

    public SOSArgument<Integer> getServerAliveInterval() {
        return this.serverAliveInterval;
    }

    public SOSArgument<Boolean> getStrictHostkeyChecking() {
        return this.strictHostkeyChecking;
    }

    public SOSArgument<Path> getHostkeyLocation() {
        return this.hostkeyLocation;
    }

    public SOSArgument<Boolean> getUseZlibCompression() {
        return this.useZlibCompression;
    }

    public SOSArgument<Boolean> getSimulateShell() {
        return this.simulateShell;
    }

    public SOSArgument<Charset> getRemoteCharset() {
        return this.remoteCharset;
    }

    public static enum AuthMethod {
        PASSWORD,
        PUBLICKEY,
        KEYBOARD_INTERACTIVE;

    }
}

