/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.common;

import com.sos.commons.credentialstore.keepass.SOSKeePassDatabase;
import com.sos.commons.util.SOSString;
import com.sos.commons.vfs.ssh.common.SSHProviderArguments;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.linguafranca.pwdb.Entry;

public class SSHProviderUtil {
    public static KeyProvider getKeyProviderFromKeepass(SSHClient sshClient, SSHProviderArguments args) throws Exception {
        SOSKeePassDatabase kd = args.getKeepassDatabase();
        if (kd == null) {
            throw new Exception("[keepass]keepass_database property is null");
        }
        Entry<?, ?, ?, ?> ke = args.getKeepassDatabaseEntry();
        if (ke == null) {
            throw new Exception(String.format("[keepass][can't find database entry]attachment property name=%s", args.getKeepassAttachmentPropertyName()));
        }
        try {
            String pk = new String(kd.getAttachment(ke, args.getKeepassAttachmentPropertyName()), "UTF-8");
            return sshClient.loadKeys(pk, null, SOSString.isEmpty((String)((String)args.getPassphrase().getValue())) ? null : SSHProviderUtil.getPasswordFinder((String)args.getPassphrase().getValue()));
        }
        catch (Exception e) {
            String keePassPath = ke.getPath() + "@" + args.getKeepassAttachmentPropertyName();
            throw new Exception(String.format("[keepass][%s]%s", keePassPath, e.toString()), e);
        }
    }

    public static PasswordFinder getPasswordFinder(final String password) {
        return new PasswordFinder(){

            public char[] reqPassword(Resource<?> resource) {
                return (char[])password.toCharArray().clone();
            }

            public boolean shouldRetry(Resource<?> resource) {
                return false;
            }
        };
    }
}

