/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import com.sos.exception.SOSBadRequestException;
import com.sos.exception.SOSInvalidDataException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerDate {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerDate.class);

    public static String getNowInISO() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    public static Date getDateFromISO8601String(String dateString) {
        Instant fromString = JobSchedulerDate.getInstantFromISO8601String(dateString);
        return fromString != null ? Date.from(fromString) : null;
    }

    public static Instant getInstantFromISO8601String(String dateString) {
        Instant fromString = null;
        if (dateString != null && !dateString.isEmpty()) {
            try {
                if (dateString.trim().matches("^\\d{2}:\\d{2}:\\d{2}(?:\\.\\d{1,3})?Z?$")) {
                    dateString = Instant.now().toString().replaceFirst("^(\\d{4}-\\d{2}-\\d{2}T).*", "$1" + dateString.trim() + "Z").replaceFirst("ZZ+$", "Z");
                }
                if ((fromString = Instant.parse(dateString = dateString.trim().replaceFirst("^(\\d{4}-\\d{2}-\\d{2}) ", "$1T"))) == null || fromString.getEpochSecond() == 0L || fromString.getEpochSecond() == Long.MAX_VALUE) {
                    fromString = null;
                }
            }
            catch (DateTimeParseException e) {
                LOGGER.warn(dateString, (Throwable)e);
                fromString = null;
            }
        }
        return fromString;
    }

    public static Date getDateFromEventId(Long eventId) {
        if (eventId == null) {
            return null;
        }
        Instant fromEpochMilli = Instant.ofEpochMilli(eventId / 1000L);
        return Date.from(fromEpochMilli);
    }

    public static Date getDateTo(String date, String timeZone) throws SOSInvalidDataException {
        return JobSchedulerDate.getDate(date, true, timeZone);
    }

    public static Date getDateFrom(String date, String timeZone) throws SOSInvalidDataException {
        return JobSchedulerDate.getDate(date, false, timeZone);
    }

    public static Date getDate(String date, boolean dateTo, String timeZone) throws SOSInvalidDataException {
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return Date.from(JobSchedulerDate.getInstantFromDateStr(date, dateTo, timeZone));
        }
        catch (SOSInvalidDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SOSInvalidDataException((Throwable)e);
        }
    }

    public static String getAtInJobSchedulerTimezone(String at, String userTimezone, String jobSchedulerTimezone) throws SOSBadRequestException {
        if ((at = at.trim()).matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}")) {
            at = at + ":00";
        }
        if (!at.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
            throw new SOSBadRequestException(String.format("date format yyyy-MM-dd HH:mm:ss expected for \"Start time\": %1$s", at));
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return formatter.format(ZonedDateTime.of(LocalDateTime.parse(at, formatter), ZoneId.of(userTimezone)).withZoneSameInstant(ZoneId.of(jobSchedulerTimezone)));
    }

    private static Instant getInstantFromDateStr(String dateStr, boolean dateTo, String timeZone) throws SOSInvalidDataException {
        Pattern offsetPattern = Pattern.compile("(\\d{2,4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}(?:\\.\\d+)?|(?:\\s*[+-]?\\d+\\s*[smhdwMy])+)([+-][0-9:]+|Z)?$");
        Pattern dateTimePattern = Pattern.compile("(?:([+-]?\\d+)\\s*([smhdwMy])\\s*)");
        Matcher m = offsetPattern.matcher(dateStr);
        TimeZone timeZ = null;
        boolean dateTimeIsRelative = false;
        HashMap<String, Integer> relativeDateTimes = new HashMap<String, Integer>();
        relativeDateTimes.put("y", null);
        relativeDateTimes.put("M", null);
        relativeDateTimes.put("w", null);
        relativeDateTimes.put("d", null);
        relativeDateTimes.put("h", null);
        relativeDateTimes.put("m", null);
        relativeDateTimes.put("s", null);
        try {
            if (timeZone != null && !timeZone.isEmpty()) {
                timeZ = TimeZone.getTimeZone(timeZone);
            }
            if (m.find()) {
                if (timeZ == null) {
                    timeZ = m.group(2) != null ? TimeZone.getTimeZone("GMT" + m.group(2)) : TimeZone.getTimeZone(ZoneOffset.UTC);
                }
                dateStr = m.group(1);
            } else if (timeZ == null) {
                timeZ = TimeZone.getTimeZone(ZoneOffset.UTC);
            }
            m = dateTimePattern.matcher(dateStr.replaceAll("([smhdwMy])", "$1 "));
            while (m.find()) {
                dateTimeIsRelative = true;
                Integer number = Integer.valueOf(m.group(1));
                relativeDateTimes.put(m.group(2), number);
            }
            if (!dateTimeIsRelative) {
                Instant instant = Instant.parse(dateStr + "Z");
                int offset = timeZ.getOffset(instant.toEpochMilli());
                return instant.plusMillis(-1 * offset);
            }
            Calendar calendar = Calendar.getInstance(timeZ);
            calendar.setTime(Date.from(Instant.now()));
            calendar.setTimeZone(timeZ);
            if (Pattern.compile("[dwMy]").matcher(dateStr).find()) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (relativeDateTimes.get("y") != null) {
                if (dateTo) {
                    calendar.add(1, 1 + (Integer)relativeDateTimes.get("y"));
                    calendar.add(6, 1 - calendar.get(6) - 1);
                } else {
                    calendar.add(1, (Integer)relativeDateTimes.get("y"));
                    calendar.add(6, 1 - calendar.get(6));
                }
            }
            if (relativeDateTimes.get("M") != null) {
                if (dateTo) {
                    calendar.add(2, 1 + (Integer)relativeDateTimes.get("M"));
                    calendar.add(5, 1 - calendar.get(5) - 1);
                } else {
                    calendar.add(2, (Integer)relativeDateTimes.get("M"));
                    calendar.add(5, 1 - calendar.get(5));
                }
            }
            if (relativeDateTimes.get("w") != null) {
                if (dateTo) {
                    calendar.add(3, 1 + (Integer)relativeDateTimes.get("w"));
                    calendar.add(5, 2 - calendar.get(7) - 1);
                } else {
                    calendar.add(3, (Integer)relativeDateTimes.get("w"));
                    calendar.add(5, 2 - calendar.get(7));
                }
            }
            if (relativeDateTimes.get("d") != null) {
                if (dateTo) {
                    calendar.add(5, 1 + (Integer)relativeDateTimes.get("d") - 1);
                } else {
                    calendar.add(5, (Integer)relativeDateTimes.get("d"));
                }
            }
            if (dateTo) {
                calendar.add(5, 1);
            }
            if (relativeDateTimes.get("h") != null) {
                calendar.add(11, (Integer)relativeDateTimes.get("h"));
            }
            if (relativeDateTimes.get("m") != null) {
                calendar.add(12, (Integer)relativeDateTimes.get("m"));
            }
            if (relativeDateTimes.get("s") != null) {
                calendar.add(13, (Integer)relativeDateTimes.get("s"));
            }
            return calendar.toInstant();
        }
        catch (Exception e) {
            throw new SOSInvalidDataException((Throwable)e);
        }
    }
}

