/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.io.BufferedWriter;
import java.io.Writer;
import java.util.Iterator;

public class SOSCSVWriter
extends BufferedWriter {
    private static final String FIELD_SEPARATOR = ";";
    private static final String QUOTE = "\"";
    private String fieldSeparator;
    private String quote = "";
    private boolean useQuotes = false;
    private int lineCount = 0;
    private StringBuilder line = new StringBuilder();
    private int fieldCount = 0;
    private String field = null;

    public SOSCSVWriter(Writer writer) {
        super(writer);
        this.fieldSeparator = FIELD_SEPARATOR;
        this.field = null;
        this.fieldCount = 0;
        this.line = new StringBuilder();
    }

    public SOSCSVWriter(Writer writer, String separator, boolean useQuotes) {
        super(writer);
        if (useQuotes) {
            this.setQuote(QUOTE);
        }
        this.fieldSeparator = separator;
        this.field = null;
        this.fieldCount = 0;
        this.line = new StringBuilder();
    }

    public void writeRecord(Iterator record) throws Exception {
        this.fieldCount = 0;
        this.line = new StringBuilder();
        while (record.hasNext()) {
            if (this.fieldCount++ > 0) {
                this.line.append(this.fieldSeparator);
            }
            this.field = null;
            try {
                this.field = record.next().toString();
            }
            catch (Exception e) {
                continue;
            }
            this.encodeField();
        }
        super.write(this.line.toString());
        ++this.lineCount;
        super.newLine();
    }

    public int getLineCount() throws Exception {
        return this.lineCount;
    }

    private void encodeField() throws Exception {
        this.line.append(this.quote);
        if (this.field.indexOf(13) >= 0 || this.field.indexOf(10) >= 0) {
            throw new Exception(this.line.toString() + ": not allowed character (CR,LF) on line[" + this.lineCount + "].");
        }
        this.line.append(this.field);
        this.line.append(this.quote);
    }

    public final String getQuote() {
        return this.quote;
    }

    public final void setQuote(String quote) {
        this.quote = quote;
    }

    public final boolean isUseQuotes() {
        return this.useQuotes;
    }

    public final void setUseQuotes(boolean useQuotes) {
        this.useQuotes = useQuotes;
    }
}

