/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import com.sos.exception.SOSMissingDataException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import sos.util.SOSString;

public class SOSKeyStoreReader {
    private static final String SYSTEM_PROPERTY_KEYSTORE_PATH = "javax.net.ssl.keyStore";
    private static final String SYSTEM_PROPERTY_TRUSTSTORE_PATH = "javax.net.ssl.trustStore";
    private static final String SYSTEM_PROPERTY_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String SYSTEM_PROPERTY_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private final Type type;
    private final String storeType;
    private Path path;
    private String password;

    public SOSKeyStoreReader(Type type) {
        this(type, null, null, null);
    }

    public SOSKeyStoreReader(Type type, Path path) {
        this(type, path, null, null);
    }

    public SOSKeyStoreReader(Type type, Path path, String password) {
        this(type, path, password, null);
    }

    public SOSKeyStoreReader(Type type, Path path, String password, String storeType) {
        this.type = type;
        this.path = path;
        this.password = password;
        this.storeType = storeType == null ? KeyStore.getDefaultType() : storeType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyStore read() throws SOSMissingDataException, IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        switch (this.type) {
            case KeyStrore: {
                String p;
                if (this.path == null && !SOSString.isEmpty(p = System.getProperty(SYSTEM_PROPERTY_KEYSTORE_PATH))) {
                    this.path = Paths.get(p, new String[0]);
                }
                if (this.password != null || (p = System.getProperty(SYSTEM_PROPERTY_KEYSTORE_PASSWORD)) == null) break;
                this.password = p;
                break;
            }
            case TrustStore: {
                String p;
                if (this.path == null && !SOSString.isEmpty(p = System.getProperty(SYSTEM_PROPERTY_TRUSTSTORE_PATH))) {
                    this.path = Paths.get(p, new String[0]);
                }
                if (this.password != null || (p = System.getProperty(SYSTEM_PROPERTY_TRUSTSTORE_PASSWORD)) == null) break;
                this.password = p;
                break;
            }
            case KeyTrustStore: {
                String p;
                if (this.path == null) {
                    p = System.getProperty(SYSTEM_PROPERTY_KEYSTORE_PATH);
                    if (SOSString.isEmpty(p)) {
                        p = System.getProperty(SYSTEM_PROPERTY_TRUSTSTORE_PATH);
                    }
                    if (!SOSString.isEmpty(p)) {
                        this.path = Paths.get(p, new String[0]);
                    }
                }
                if (this.password != null) break;
                p = System.getProperty(SYSTEM_PROPERTY_KEYSTORE_PASSWORD);
                if (p == null) {
                    p = System.getProperty(SYSTEM_PROPERTY_TRUSTSTORE_PASSWORD);
                }
                if (p == null) break;
                this.password = p;
                break;
            }
        }
        if (this.path == null) {
            return null;
        }
        try (InputStream is = Files.newInputStream(this.path, new OpenOption[0]);){
            KeyStore ks = KeyStore.getInstance(this.storeType);
            ks.load(is, this.getPassword());
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Throwable e) {
            throw new IOException(String.format("[%s][%s]%s", this.path, this.storeType, e.toString()), e);
        }
    }

    public char[] getPassword() {
        return this.password == null ? (char[])null : this.password.toCharArray();
    }

    public Path getPath() {
        return this.path;
    }

    public static enum Type {
        KeyStrore,
        TrustStore,
        KeyTrustStore;

    }
}

