/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class SOSNumber {
    public static boolean isValidNumber(String text, Locale locale) {
        try {
            if (!text.matches("^[0-9,.]+$")) {
                return false;
            }
            SOSNumber.asNumber(text, locale);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidNumber(String text) {
        return SOSNumber.isValidNumber(text, Locale.getDefault());
    }

    public static boolean isValidNumber(String text, int digits, int fractionDigits, Locale locale) {
        try {
            if (!text.matches("^[0-9,.]+$")) {
                return false;
            }
            Number num = SOSNumber.asNumber(text, locale);
            String str = SOSNumber.stringValue(num, Locale.ENGLISH, false, 305);
            String[] spl = str.split("\\.");
            if (spl[0].length() > digits) {
                return false;
            }
            return spl.length != 2 || spl[1].length() <= fractionDigits;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidNumber(String text, int digits, int fractionDigits) {
        return SOSNumber.isValidNumber(text, digits, fractionDigits, Locale.getDefault());
    }

    public static boolean isValidNumber(String text, int digits, Locale locale) {
        try {
            if (!text.matches("^[0-9,.]+$")) {
                return false;
            }
            Number num = SOSNumber.asNumber(text, locale);
            String str = SOSNumber.stringValue(num, Locale.ENGLISH, false, 305);
            String[] spl = str.split("\\.");
            if (spl.length == 1 && spl[0].length() > digits) {
                return false;
            }
            return spl.length != 2 || spl[0].length() + spl[1].length() <= digits;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidNumber(String text, int digits) {
        return SOSNumber.isValidNumber(text, digits, Locale.getDefault());
    }

    private static String format(NumberFormat nf, Number number) {
        StringBuffer sb = new StringBuffer();
        sb = nf.format(number, sb, new FieldPosition(0));
        return sb.toString();
    }

    public static String stringValue(Number number, Locale locale, boolean grouping, int maxFractionDigits) {
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setGroupingUsed(grouping);
        nf.setMaximumFractionDigits(maxFractionDigits);
        return SOSNumber.format(nf, number);
    }

    public static String stringValue(Number number, boolean grouping, int maxFractionDigits) {
        return SOSNumber.stringValue(number, Locale.getDefault(), grouping, maxFractionDigits);
    }

    public static String stringValue(Number number, boolean grouping) {
        return SOSNumber.stringValue(number, Locale.getDefault(), grouping, 309);
    }

    public static String stringValue(Number number, String pattern) {
        return SOSNumber.format(new DecimalFormat(pattern), number);
    }

    public static String stringValue(byte number, boolean grouping) {
        return SOSNumber.stringValue((Number)new Byte(number), grouping);
    }

    public static String stringValue(short number, boolean grouping) {
        return SOSNumber.stringValue((Number)new Short(number), grouping);
    }

    public static String stringValue(int number, boolean grouping) {
        return SOSNumber.stringValue((Number)new Integer(number), grouping);
    }

    public static String stringValue(long number, boolean grouping) {
        return SOSNumber.stringValue((Number)new Long(number), grouping);
    }

    public static String stringValue(float number, boolean grouping) {
        return SOSNumber.stringValue((Number)new Float(number), grouping);
    }

    public static String stringValue(float number, boolean grouping, int fractionDigits) {
        return SOSNumber.stringValue(new Float(number), grouping, fractionDigits);
    }

    public static String stringValue(double number, boolean grouping) {
        return SOSNumber.stringValue((Number)new Double(number), grouping);
    }

    public static String stringValue(double number, boolean grouping, int fractionDigits) {
        return SOSNumber.stringValue(new Double(number), grouping, fractionDigits);
    }

    public static String asCurrency(Number number, Locale locale, boolean grouping, int fractionDigits) {
        NumberFormat nf = NumberFormat.getCurrencyInstance(locale);
        nf.setGroupingUsed(grouping);
        nf.setMaximumFractionDigits(fractionDigits);
        return SOSNumber.format(nf, number);
    }

    public static String asCurrency(Number number, boolean grouping, int fractionDigits) {
        return SOSNumber.asCurrency(number, Locale.getDefault(), grouping, fractionDigits);
    }

    public static String asCurrency(Number number, boolean grouping) {
        return SOSNumber.asCurrency(number, Locale.getDefault(), grouping, 2);
    }

    public static String asCurrency(float number, boolean grouping) {
        return SOSNumber.asCurrency(new Float(number), grouping);
    }

    public static String asCurrency(double number, boolean grouping) {
        return SOSNumber.asCurrency(new Double(number), grouping);
    }

    public static Number asNumber(String text, Locale locale) throws ParseException {
        NumberFormat nf = NumberFormat.getInstance(locale);
        return nf.parse(text);
    }

    public static Number asNumber(String text) throws ParseException {
        NumberFormat nf = NumberFormat.getInstance();
        return nf.parse(text);
    }

    public static byte asByte(String text) throws ParseException {
        return SOSNumber.asNumber(text).byteValue();
    }

    public static short asShort(String text) throws ParseException {
        return SOSNumber.asNumber(text).shortValue();
    }

    public static int asInteger(String text) throws ParseException {
        return SOSNumber.asNumber(text).intValue();
    }

    public static long asLong(String text) throws ParseException {
        return SOSNumber.asNumber(text).longValue();
    }

    public static float asFloat(String text) throws ParseException {
        return SOSNumber.asNumber(text).floatValue();
    }

    public static double asDouble(String text) throws ParseException {
        return SOSNumber.asNumber(text).doubleValue();
    }
}

