/*
 * Decompiled with CFR 0.152.
 */
package sos.util.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.security.SOSKeyGenerator;

public class SOSCertificate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSCertificate.class);
    private static String subjectDN = "O=APL/SOS,C=DE";
    private static String issuerDN = "O=APL/SOS,C=DE";
    private static Date validFrom = null;
    private static Date validTo = null;
    private static BigInteger serialNumber = BigInteger.valueOf(1L);
    private static String hashAlgorithm = "SHA1";
    private static Calendar gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    public static final String SHA1 = "SHA1";
    public static final String MD2 = "MD2";
    public static final String MD5 = "MD5";

    public static Certificate createCertificate(PrivateKey privateKey, PublicKey publicKey) throws Exception {
        if (privateKey == null) {
            throw new Exception("Private Key is null");
        }
        if (publicKey == null) {
            throw new Exception("Public Key is null");
        }
        if (serialNumber == null) {
            throw new Exception("Serialnumber is null");
        }
        if (subjectDN == null || subjectDN.length() == 0) {
            throw new Exception("Subject DN is empty");
        }
        if (issuerDN == null || issuerDN.length() == 0) {
            throw new Exception("Issuer DN is empty");
        }
        long time = gmtCalendar.getTimeInMillis();
        if (validFrom == null) {
            validFrom = new Date(time - 86400000L);
        }
        if (validTo == null) {
            validTo = new Date(validFrom.getTime() + 7776000000L);
        }
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
            v3CertGen.reset();
            v3CertGen.setSerialNumber(serialNumber);
            v3CertGen.setIssuerDN(new X509Name(issuerDN));
            v3CertGen.setSubjectDN(new X509Name(subjectDN));
            v3CertGen.setNotBefore(validFrom);
            v3CertGen.setNotAfter(validTo);
            v3CertGen.setPublicKey(publicKey);
            v3CertGen.setSignatureAlgorithm(hashAlgorithm + "With" + privateKey.getAlgorithm());
            X509Certificate cert = v3CertGen.generateX509Certificate(privateKey);
            return cert;
        }
        catch (NoClassDefFoundError e) {
            throw new Exception("not found  Definition : " + e);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static void generateCertificate(PrivateKey privateKey, PublicKey publicKey, String certFileName) throws Exception {
        if (privateKey == null) {
            throw new Exception("Private Key is null");
        }
        if (publicKey == null) {
            throw new Exception("Public Key is null");
        }
        if (certFileName == null || certFileName.trim().length() == 0) {
            throw new Exception("Certification file name is empty");
        }
        try {
            Certificate cert = SOSCertificate.createCertificate(privateKey, publicKey);
            byte[] encoding = cert.getEncoded();
            FileOutputStream fos = new FileOutputStream(certFileName);
            fos.write(encoding);
            fos.close();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static Certificate importCertificate(File file) throws Exception {
        try {
            FileInputStream is = new FileInputStream(file);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(is);
            return cert;
        }
        catch (CertificateException e) {
            throw new Exception(e);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static Certificate[] getCertificateChain(String fileName) throws Exception {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream certStream = SOSCertificate.getStream(fileName);
            Collection<? extends Certificate> c = cf.generateCertificates(certStream);
            Certificate[] certs = new Certificate[c.toArray().length];
            if (c.size() == 1) {
                Certificate cert;
                certStream = SOSCertificate.getStream(fileName);
                System.out.println("1 certificate");
                certs[0] = cert = cf.generateCertificate(certStream);
            } else {
                System.out.println("Certificate chain length: " + c.size());
                certs = (Certificate[])c.toArray();
            }
            return certs;
        }
        catch (CertificateException e) {
            throw new Exception(e);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static Certificate[] getCertificateChain(byte[] bArray) throws Exception {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream certStream = SOSCertificate.getStream(bArray);
            Collection<? extends Certificate> c = cf.generateCertificates(certStream);
            Certificate[] certs = new Certificate[c.toArray().length];
            if (c.size() == 1) {
                Certificate cert;
                certStream = SOSCertificate.getStream(bArray);
                System.out.println("1 certificate");
                certs[0] = cert = cf.generateCertificate(certStream);
            } else {
                System.out.println("Certificate chain length: " + c.size());
                certs = (Certificate[])c.toArray();
            }
            return certs;
        }
        catch (CertificateException e) {
            throw new Exception(e);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getStream(String fileName) throws Exception {
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            ByteArrayInputStream bais;
            fis = new FileInputStream(fileName);
            dis = new DataInputStream(fis);
            byte[] bytes = new byte[dis.available()];
            ((DataInputStream)dis).readFully(bytes);
            ByteArrayInputStream byteArrayInputStream = bais = new ByteArrayInputStream(bytes);
            return byteArrayInputStream;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static InputStream getStream(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }

    public static String getHashAlgorithm() {
        return hashAlgorithm;
    }

    public static void setHashAlgorithm(String hashAlgorithm) {
        SOSCertificate.hashAlgorithm = hashAlgorithm;
    }

    public static String getIssuerDN() {
        return issuerDN;
    }

    public static void setIssuerDN(String issuerDN) {
        SOSCertificate.issuerDN = issuerDN;
    }

    public static BigInteger getSerialNumber() {
        return serialNumber;
    }

    public static void setSerialNumber(BigInteger serialNumber) {
        SOSCertificate.serialNumber = serialNumber;
    }

    public static String getSubjectDN() {
        return subjectDN;
    }

    public static void setSubjectDN(String subjectDN) {
        SOSCertificate.subjectDN = subjectDN;
    }

    public static Date getValidFrom() {
        return validFrom;
    }

    public static void setValidFrom(Date validFrom) {
        SOSCertificate.validFrom = validFrom;
    }

    public static Date getValidTo() {
        return validTo;
    }

    public static void setValidTo(Date validTo) {
        SOSCertificate.validTo = validTo;
    }

    public static void main(String[] args) {
        String path = "J:/E/java/al/sos.util/signature/";
        String keyAlgorithmName = "RSA";
        String provider = "BC";
        String privateKeyFileName = path + "new_" + keyAlgorithmName + "=" + provider + ".privatekey";
        String publicKeyFileName = path + "new_" + keyAlgorithmName + "=" + provider + ".publickey";
        try {
            PrivateKey privKey = SOSKeyGenerator.getPrivateKeyFromFile(privateKeyFileName);
            PublicKey pubKey = SOSKeyGenerator.getPublicKeyFromFile(publicKeyFileName);
            SOSCertificate.setHashAlgorithm(SHA1);
            SOSCertificate.setSubjectDN("CN=Andreas Liebert,C=DE,O=APL/SOS");
            SOSCertificate.setIssuerDN("CN=Andreas Liebert,C=DE,O=APL/SOS");
            SOSCertificate.setSerialNumber(BigInteger.valueOf(100L));
            String certFile = privKey.getAlgorithm() + "(" + provider + ")=" + SOSCertificate.getHashAlgorithm() + ".cer";
            SOSCertificate.generateCertificate(privKey, pubKey, path + certFile);
            LOGGER.info("Zertifikate wurde erstellt");
            LOGGER.info("privKey = " + privateKeyFileName);
            LOGGER.info("pubKey = " + publicKeyFileName);
            LOGGER.info("certFile = " + path + certFile);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

