/*
 * Decompiled with CFR 0.152.
 */
package sos.util.string2bool;

import sos.util.string2bool.SOSAnd;
import sos.util.string2bool.SOSBoolean;
import sos.util.string2bool.SOSBooleanExpression;
import sos.util.string2bool.SOSBooleanUtil;
import sos.util.string2bool.SOSIBoolean;
import sos.util.string2bool.SOSMalformedBooleanException;
import sos.util.string2bool.SOSNot;
import sos.util.string2bool.SOSOrOperation;

final class SOSBoolRightLeft
extends SOSBooleanExpression {
    private String booleanExpression;
    private SOSIBoolean iBoolean;

    SOSBoolRightLeft(String newBooleanExpression) throws SOSMalformedBooleanException {
        this.booleanExpression = newBooleanExpression;
        this.iBoolean = this.toIBoolean(SOSBooleanUtil.validAndformat(newBooleanExpression), 0);
    }

    @Override
    public boolean booleanValue() {
        return this.iBoolean.booleanValue();
    }

    private SOSIBoolean toIBoolean(String formatedBooleanExpression, int index) throws SOSMalformedBooleanException {
        int firstChar = this.getFirstChar(formatedBooleanExpression);
        if (new Character((char)firstChar).toString().matches("\\s")) {
            firstChar = 32;
        }
        String substring = this.getSubstringWithoutFirstChar(formatedBooleanExpression);
        switch (firstChar) {
            case 32: {
                SOSIBoolean boolWhitespace = this.toIBoolean(substring, index + 1);
                return boolWhitespace;
            }
            case 40: {
                String beginToClose = this.getFromBeginToCloseParenthesis(substring, index + 1);
                String closeToEnd = this.getFromCloseParenthesisToEnd(substring, index + 1);
                SOSIBoolean boolBeginToClose = this.toIBoolean(beginToClose, index + 1);
                SOSIBoolean boolOpen = this.toIBoolean(boolBeginToClose, closeToEnd, index + 1);
                return boolOpen;
            }
            case 84: {
                SOSIBoolean boolTrue = this.toIBoolean(new SOSBoolean(true), substring, index + 4);
                return boolTrue;
            }
            case 70: {
                SOSIBoolean boolFalse = this.toIBoolean(new SOSBoolean(false), substring, index + 5);
                return boolFalse;
            }
            case 33: {
                SOSIBoolean boolAll = this.toIBoolean(substring, index + 1);
                SOSNot boolNot = new SOSNot(boolAll);
                return boolNot;
            }
        }
        throw new SOSMalformedBooleanException("Expected [ (, true, flase, ! ]", index, this.booleanExpression);
    }

    private SOSIBoolean toIBoolean(SOSIBoolean lastIBoolean, String formatedBooleanExpression, int index) throws SOSMalformedBooleanException {
        int firstChar = this.getFirstChar(formatedBooleanExpression);
        if (new Character((char)firstChar).toString().matches("\\s")) {
            firstChar = 32;
        }
        String substring = this.getSubstringWithoutFirstChar(formatedBooleanExpression);
        switch (firstChar) {
            case 32: {
                return this.toIBoolean(lastIBoolean, substring, index + 1);
            }
            case 46: {
                return lastIBoolean;
            }
            case 41: {
                return this.toIBoolean(lastIBoolean, substring, index + 1);
            }
            case 124: {
                return new SOSOrOperation(lastIBoolean, this.toIBoolean(substring, index + 2));
            }
            case 38: {
                return new SOSAnd(lastIBoolean, this.toIBoolean(substring, index + 2));
            }
        }
        throw new SOSMalformedBooleanException("Expected [ ' ', ), ||, && ]", index, this.booleanExpression);
    }

    private char getFirstChar(String formatedBooleanExpression) {
        if (formatedBooleanExpression.length() == 0) {
            return '.';
        }
        return formatedBooleanExpression.charAt(0);
    }

    private String getSubstringWithoutFirstChar(String formatedBooleanExpression) {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        return formatedBooleanExpression.substring(1, formatedBooleanExpression.length());
    }

    private String getFromBeginToCloseParenthesis(String formatedBooleanExpression, int index) throws SOSMalformedBooleanException {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        int fromIndex = 0;
        int toIndex = this.getIndexOfCloseParenthesis(formatedBooleanExpression, index);
        return formatedBooleanExpression.substring(fromIndex, toIndex);
    }

    private String getFromCloseParenthesisToEnd(String formatedBooleanExpression, int index) throws SOSMalformedBooleanException {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        int fromIndex = this.getIndexOfCloseParenthesis(formatedBooleanExpression, index);
        int toIndex = formatedBooleanExpression.length();
        return formatedBooleanExpression.substring(fromIndex, toIndex);
    }

    private int getIndexOfCloseParenthesis(String formatedBooleanExpression, int index) throws SOSMalformedBooleanException {
        int lastIndexOfOpenParenthesis = this.getIndexOf(formatedBooleanExpression, "(", -1);
        int lastIndexOfCloseParenthesis = this.getIndexOf(formatedBooleanExpression, ")", -1);
        while (lastIndexOfOpenParenthesis != -1 && lastIndexOfOpenParenthesis < lastIndexOfCloseParenthesis) {
            lastIndexOfOpenParenthesis = this.getIndexOf(formatedBooleanExpression, "(", lastIndexOfOpenParenthesis);
            lastIndexOfCloseParenthesis = this.getIndexOf(formatedBooleanExpression, ")", lastIndexOfCloseParenthesis);
        }
        if (lastIndexOfCloseParenthesis == -1) {
            int parenthesisIndex = index + lastIndexOfOpenParenthesis;
            throw new SOSMalformedBooleanException("Have a open parenthesis without a close parenthesis", parenthesisIndex, this.booleanExpression);
        }
        return lastIndexOfCloseParenthesis;
    }

    private int getIndexOf(String formatedBooleanExpression, String searchedString, int fromIndex) {
        int newFromIndex = fromIndex;
        if (newFromIndex == -1) {
            return formatedBooleanExpression.indexOf(searchedString);
        }
        int length = formatedBooleanExpression.length();
        if (++newFromIndex > length) {
            return -1;
        }
        return formatedBooleanExpression.indexOf(searchedString, newFromIndex);
    }

    public String toString() {
        return this.iBoolean.toString();
    }
}

