/*
 * Decompiled with CFR 0.152.
 */
package sos.util.string2bool;

import java.util.ArrayList;
import java.util.List;

public final class SOSMalformedBooleanException
extends Exception {
    private static final long serialVersionUID = 1L;
    private List<Integer> booleanExpressionErrorIndexes;
    private String booleanExpression;
    private String booleanExpressionErrorMessage;

    SOSMalformedBooleanException(String errorMessage, int errorIndex, String newBooleanExpression) {
        this(errorMessage, SOSMalformedBooleanException.toList(errorIndex), newBooleanExpression);
    }

    SOSMalformedBooleanException(String errorMessage, List<Integer> errorIndexes, String newBooleanExpression) {
        super(SOSMalformedBooleanException.format(errorMessage, errorIndexes, newBooleanExpression));
        this.booleanExpression = newBooleanExpression;
        this.booleanExpressionErrorIndexes = errorIndexes;
        this.booleanExpressionErrorMessage = errorMessage;
    }

    public String getBooleanExpression() {
        return this.booleanExpression;
    }

    public List<Integer> getBooleanExpressionErrorIndexes() {
        return this.booleanExpressionErrorIndexes;
    }

    public String getBooleanExpressionErrorMessage() {
        return this.booleanExpressionErrorMessage;
    }

    private static List<Integer> toList(int errorIndex) {
        ArrayList<Integer> errorIndexes = new ArrayList<Integer>();
        errorIndexes.add(new Integer(errorIndex));
        return errorIndexes;
    }

    private static String format(String errorMessage, List<Integer> errorIndexes, String newBooleanExpression) {
        int i;
        if (errorMessage == null || "".equals(errorMessage)) {
            throw new IllegalArgumentException("errorMessage is null or void");
        }
        if (errorIndexes == null || errorIndexes.isEmpty()) {
            throw new IllegalArgumentException("errorIndexes is null or void");
        }
        if (newBooleanExpression == null || "".equals(newBooleanExpression)) {
            throw new IllegalArgumentException("newBooleanExpression is null or void");
        }
        StringBuilder error = new StringBuilder();
        error.append(errorMessage);
        error.append(" in [ ");
        int size = errorIndexes.size();
        int lastIndex = 0;
        for (i = 0; i < size; ++i) {
            int index = errorIndexes.get(i);
            error.append(newBooleanExpression.substring(lastIndex, index));
            error.append("_");
            lastIndex = index;
        }
        error.append(newBooleanExpression.substring(lastIndex, newBooleanExpression.length()));
        error.append(" ]");
        if (size == 1) {
            error.append(" - Index [");
        } else if (size > 1) {
            error.append(" - Indexes [");
        }
        for (i = 0; i < size; ++i) {
            error.append(errorIndexes.get(i));
            if (i == size - 1) continue;
            error.append(", ");
        }
        if (size > 0) {
            error.append("]");
        }
        return error.toString();
    }
}

