/*
 * Decompiled with CFR 0.152.
 */
package sos.spooler.jobs;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import sos.spooler.Job_impl;

public final class DelayingJob
extends Job_impl {
    private Duration delay = Duration.ofSeconds(1L);
    private boolean spooler_process = true;

    @Override
    public boolean spooler_init() {
        String delayString = this.spooler_task.params().value("delay");
        if (!delayString.isEmpty()) {
            try {
                this.delay = Duration.parse(delayString);
            }
            catch (DateTimeParseException ignored) {
                try {
                    this.delay = Duration.parse("PT" + delayString);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            }
        }
        String spoolerProcessString = this.spooler_task.params().value("spooler_process");
        if (!delayString.isEmpty()) {
            this.spooler_process = Boolean.parseBoolean(spoolerProcessString);
        }
        return true;
    }

    @Override
    public boolean spooler_process() throws InterruptedException {
        Thread.sleep(this.delay.toMillis());
        return this.spooler_process;
    }
}

