/*
 * Decompiled with CFR 0.152.
 */
package js7.base.data;

import cats.Show;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.Resource;
import cats.kernel.Eq;
import cats.kernel.Monoid;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import io.circe.Decoder;
import io.circe.Json;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichCirceEither$;
import js7.base.circeutils.CirceUtils$RichJson$;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.data.ByteSequence$;
import js7.base.data.ByteSequenceInputStream;
import js7.base.data.Writable;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.Ascii$;
import js7.base.utils.Assertions$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichString$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.math.Integral;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public interface ByteSequence<ByteSeq>
extends Writable<ByteSeq>,
Monoid<ByteSeq>,
Eq<ByteSeq>,
Show<ByteSeq> {
    public static void $init$(ByteSequence $this) {
    }

    public static ByteSequence implicitByteSequence$(ByteSequence $this) {
        return $this.implicitByteSequence();
    }

    default public ByteSequence<ByteSeq> implicitByteSequence() {
        return this;
    }

    public Class<ByteSeq> clazz();

    public static ClassTag classTag$(ByteSequence $this) {
        return $this.classTag();
    }

    default public ClassTag<ByteSeq> classTag() {
        return ClassTag$.MODULE$.apply(this.clazz());
    }

    public static String typeName$(ByteSequence $this) {
        return $this.typeName();
    }

    default public String typeName() {
        return ScalaUtils$syntax$.MODULE$.RichJavaClass(this.clazz()).simpleScalaName();
    }

    public static Object apply$(ByteSequence $this, scala.collection.immutable.Seq bytes, Integral I) {
        return $this.apply(bytes, I);
    }

    default public <I> ByteSeq apply(scala.collection.immutable.Seq<I> bytes, Integral<I> I) {
        return this.unsafeWrap((byte[])bytes.view().map((Function1 & Serializable)i -> (byte)I.toInt(i)).toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public static Object apply$(ByteSequence $this, byte[] array) {
        return $this.apply(array);
    }

    default public ByteSeq apply(byte[] array) {
        return this.fromArray(array);
    }

    public static Object apply$(ByteSequence $this, String string) {
        return $this.apply(string);
    }

    default public ByteSeq apply(String string) {
        return this.fromString(string);
    }

    public static Object one$(ByteSequence $this, byte by) {
        return $this.one(by);
    }

    default public ByteSeq one(byte by) {
        return this.unsafeWrap(new byte[]{by});
    }

    public ByteSeq fromArray(byte[] var1);

    public static Object fromArray$(ByteSequence $this, byte[] bytes, int from, int until) {
        return $this.fromArray(bytes, from, until);
    }

    default public ByteSeq fromArray(byte[] bytes, int from, int until) {
        Object object = Predef$.MODULE$.byteArrayOps(bytes);
        if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
            return (ByteSeq)this.empty();
        }
        Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
        return this.unsafeWrap((byte[])ArrayOps$.MODULE$.slice$extension(object2, from, until));
    }

    public ByteSeq fromByteArray(ByteArray var1);

    public static Object readByteBuffer$(ByteSequence $this, ByteBuffer buffer) {
        return $this.readByteBuffer(buffer);
    }

    default public ByteSeq readByteBuffer(ByteBuffer buffer) {
        byte[] array = new byte[buffer.remaining()];
        buffer.get(array);
        return this.unsafeWrap(array);
    }

    public static Object fromSeq$(ByteSequence $this, Seq bytes) {
        return $this.fromSeq((Seq<Object>)bytes);
    }

    default public ByteSeq fromSeq(Seq<Object> bytes) {
        Seq<Object> seq = bytes;
        if (seq instanceof ArraySeq.ofByte) {
            ArraySeq.ofByte arraySeq = (ArraySeq.ofByte)seq;
            return this.unsafeWrap(arraySeq.unsafeArray());
        }
        if (seq instanceof scala.collection.immutable.Seq) {
            return this.unsafeWrap((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
        }
        return this.fromArray((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public static Object fromString$(ByteSequence $this, String string) {
        return $this.fromString(string);
    }

    default public ByteSeq fromString(String string) {
        return this.unsafeWrap(string.getBytes(StandardCharsets.UTF_8));
    }

    public static Either fromMimeBase64$(ByteSequence $this, String string) {
        return $this.fromMimeBase64(string);
    }

    default public Either<Problem, ByteSeq> fromMimeBase64(String string) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(this.fromArray(Base64.getMimeDecoder().decode(string)));
        }
        catch (IllegalArgumentException e) {
            right = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> ByteSequence.fromMimeBase64$$anonfun$1(e)), Problem$.MODULE$.apply$default$2()));
        }
        return right;
    }

    public static Object fromFileUnlimited$(ByteSequence $this, Path file) {
        return $this.fromFileUnlimited(file);
    }

    default public ByteSeq fromFileUnlimited(Path file) {
        return (ByteSeq)AutoClosing$.MODULE$.autoClosing(new FileInputStream(file.toFile()), (Function1 & Serializable)in -> this.fromInputStreamUnlimited((InputStream)in));
    }

    public static Object fromInputStreamUnlimited$(ByteSequence $this, InputStream in) {
        return $this.fromInputStreamUnlimited(in);
    }

    default public ByteSeq fromInputStreamUnlimited(InputStream in) {
        return (ByteSeq)this.fromInputStreamLimited(in, Integer.MAX_VALUE).getOrElse(ByteSequence::fromInputStreamUnlimited$$anonfun$1);
    }

    public static Either fromInputStreamLimited$(ByteSequence $this, InputStream in, int limit) {
        return $this.fromInputStreamLimited(in, limit);
    }

    default public Either<ByteSeq, ByteSeq> fromInputStreamLimited(InputStream in, int limit) {
        Either<ByteArray, ByteArray> either = ByteArray$.MODULE$.fromInputStreamLimited(in, limit);
        if (either instanceof Left) {
            ByteArray byteArray = (ByteArray)((Left)either).value();
            return package$.MODULE$.Left().apply(this.fromByteArray(byteArray));
        }
        if (either instanceof Right) {
            ByteArray byteArray = (ByteArray)((Right)either).value();
            return package$.MODULE$.Right().apply(this.fromByteArray(byteArray));
        }
        throw new MatchError(either);
    }

    public static Object random$(ByteSequence $this, int size) {
        return $this.random(size);
    }

    default public ByteSeq random(int size) {
        byte[] bytes = new byte[size];
        Random$.MODULE$.nextBytes(bytes);
        return this.unsafeWrap(bytes);
    }

    public ByteSeq unsafeWrap(byte[] var1);

    public static Object wrapChunk$(ByteSequence $this, Chunk chunk) {
        return $this.wrapChunk((Chunk<Object>)chunk);
    }

    default public ByteSeq wrapChunk(Chunk<Object> chunk) {
        return this.unsafeWrap((byte[])chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public static Object unsafeWrapChunk$(ByteSequence $this, Chunk chunk) {
        return $this.unsafeWrapChunk((Chunk<Object>)chunk);
    }

    default public ByteSeq unsafeWrapChunk(Chunk<Object> chunk) {
        Chunk<Object> chunk2 = chunk;
        if (chunk2 instanceof Chunk.ArraySlice) {
            Chunk.ArraySlice arraySlice = Chunk.ArraySlice$.MODULE$.unapply((Chunk.ArraySlice)chunk2);
            byte[] byArray = (byte[])arraySlice._1();
            int n = arraySlice._2();
            int n2 = arraySlice._3();
            if (byArray instanceof byte[]) {
                int len;
                byte[] array = byArray;
                if (0 == n && (len = n2) == array.length) {
                    return this.unsafeWrap(array);
                }
            }
        }
        return this.unsafeWrap((byte[])chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public static Chunk toChunk$(ByteSequence $this, Object byteSeq) {
        return $this.toChunk(byteSeq);
    }

    default public Chunk<Object> toChunk(ByteSeq byteSeq) {
        return Chunk$.MODULE$.array((Object)this.unsafeArray(byteSeq), ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    public static String show$(ByteSequence $this, Object byteSeq) {
        return $this.show(byteSeq);
    }

    default public String show(ByteSeq byteSeq) {
        return this.show(byteSeq, ByteSequence$.js7$base$data$ByteSequence$$$maxShowLength);
    }

    public static String show$(ByteSequence $this, Object byteSeq, int limit) {
        return $this.show(byteSeq, limit);
    }

    default public String show(ByteSeq byteSeq, int limit) {
        int len = this.length(byteSeq);
        ByteSeq prefix = this.take(byteSeq, limit);
        if (this.iterator(prefix).forall((Function1 & Serializable)o -> ByteSequence.show$$anonfun$1(BoxesRunTime.unboxToByte((Object)o)))) {
            Object object2 = Predef$.MODULE$.byteArrayOps(this.unsafeArray(byteSeq));
            return "\u00bb" + Predef$.MODULE$.wrapCharArray((char[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)object -> Ascii$.MODULE$.byteToPrintableChar(BoxesRunTime.unboxToByte((Object)object)), ClassTag$.MODULE$.apply(Character.TYPE))).mkString() + "\u00ab" + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(len > limit), (Function0<String>)((Function0 & Serializable)() -> ByteSequence.show$$anonfun$3(len)));
        }
        return this.typeName() + "(" + this.toStringAndHexRaw(prefix, limit, len > limit) + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(len > limit), (Function0<String>)((Function0 & Serializable)() -> ByteSequence.show$$anonfun$4(len))) + ")";
    }

    public static String toStringAndHexRaw$(ByteSequence $this, Object byteSeq, int n, boolean withEllipsis) {
        return $this.toStringAndHexRaw(byteSeq, n, withEllipsis);
    }

    default public String toStringAndHexRaw(ByteSeq byteSeq, int n, boolean withEllipsis) {
        return ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.nonEmpty(byteSeq)), (Function0<String>)((Function0 & Serializable)() -> this.toStringAndHexRaw$$anonfun$1(byteSeq, n, withEllipsis)));
    }

    public static int toStringAndHexRaw$default$2$(ByteSequence $this) {
        return $this.toStringAndHexRaw$default$2();
    }

    default public int toStringAndHexRaw$default$2() {
        return Integer.MAX_VALUE;
    }

    public static boolean toStringAndHexRaw$default$3$(ByteSequence $this) {
        return $this.toStringAndHexRaw$default$3();
    }

    default public boolean toStringAndHexRaw$default$3() {
        return false;
    }

    public static String toHexRaw$(ByteSequence $this, Object byteSeq) {
        return $this.toHexRaw(byteSeq);
    }

    default public String toHexRaw(ByteSeq byteSeq) {
        return this.toHexRaw(byteSeq, Integer.MAX_VALUE, this.toHexRaw$default$3());
    }

    public static String toHexRaw$(ByteSequence $this, Object byteSeq, int n, boolean withEllipsis) {
        return $this.toHexRaw(byteSeq, n, withEllipsis);
    }

    default public String toHexRaw(ByteSeq byteSeq, int n, boolean withEllipsis) {
        return this.iterator(byteSeq).take(n).grouped(4).map((Function1 & Serializable)_$2 -> ((IterableOnceOps)_$2.map((Function1 & Serializable)o -> StringOps$.MODULE$.format$extension("%02x", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)o))})))).mkString()).mkString(" ") + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(withEllipsis || this.lengthIs(byteSeq) > n), (Function0<String>)((Function0 & Serializable)ByteSequence::toHexRaw$$anonfun$2));
    }

    public static int toHexRaw$default$2$(ByteSequence $this) {
        return $this.toHexRaw$default$2();
    }

    default public int toHexRaw$default$2() {
        return Integer.MAX_VALUE;
    }

    public static boolean toHexRaw$default$3$(ByteSequence $this) {
        return $this.toHexRaw$default$3();
    }

    default public boolean toHexRaw$default$3() {
        return false;
    }

    public static String toHex$(ByteSequence $this, Object byteSeq) {
        return $this.toHex(byteSeq);
    }

    default public String toHex(ByteSeq byteSeq) {
        return this.iterator(byteSeq).map((Function1 & Serializable)o -> StringOps$.MODULE$.format$extension("%02x", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)o))}))).mkString();
    }

    public static boolean nonEmpty$(ByteSequence $this, Object byteSeq) {
        return $this.nonEmpty(byteSeq);
    }

    default public boolean nonEmpty(ByteSeq byteSeq) {
        return !this.isEmpty(byteSeq, this.implicitByteSequence());
    }

    public static int intLength$(ByteSequence $this, Object byteSeq) {
        return $this.intLength(byteSeq);
    }

    default public int intLength(ByteSeq byteSeq) {
        return this.length(byteSeq);
    }

    public int length(ByteSeq var1);

    public static int lengthIs$(ByteSequence $this, Object byteSeq) {
        return $this.lengthIs(byteSeq);
    }

    default public int lengthIs(ByteSeq byteSeq) {
        return this.length(byteSeq);
    }

    public byte at(ByteSeq var1, int var2);

    public static Option headOption$(ByteSequence $this, Object byteSeq) {
        return $this.headOption(byteSeq);
    }

    default public Option<Object> headOption(ByteSeq byteSeq) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.nonEmpty(byteSeq));
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> this.headOption$$anonfun$1(byteSeq));
    }

    public static Option lastOption$(ByteSequence $this, Object byteSeq) {
        return $this.lastOption(byteSeq);
    }

    default public Option<Object> lastOption(ByteSeq byteSeq) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.nonEmpty(byteSeq));
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> this.lastOption$$anonfun$1(byteSeq));
    }

    public static int indexOf$(ByteSequence $this, Object byteSeq, byte by) {
        return $this.indexOf(byteSeq, by);
    }

    default public int indexOf(ByteSeq byteSeq, byte by) {
        return this.indexOf(byteSeq, by, 0);
    }

    public static int indexOf$(ByteSequence $this, Object byteSeq, byte by, int from) {
        return $this.indexOf(byteSeq, by, from);
    }

    default public int indexOf(ByteSeq byteSeq, byte by, int from) {
        return this.indexOf(byteSeq, by, from, Integer.MAX_VALUE);
    }

    public static int indexOf$(ByteSequence $this, Object byteSeq, byte by, int from, int until) {
        return $this.indexOf(byteSeq, by, from, until);
    }

    default public int indexOf(ByteSeq byteSeq, byte by, int from, int until) {
        int i;
        int u = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(until), this.length(byteSeq));
        for (i = from; i < u && this.at(byteSeq, i) != by; ++i) {
        }
        if (i == u) {
            return -1;
        }
        return i;
    }

    public static boolean startsWith$(ByteSequence $this, Object byteSeq, Object prefix) {
        return $this.startsWith(byteSeq, prefix);
    }

    default public boolean startsWith(ByteSeq byteSeq, ByteSeq prefix) {
        int n = this.length(prefix);
        return this.lengthIs(byteSeq) >= n && RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).forall((Function1)(JFunction1.mcZI.sp & Serializable)i -> this.at(byteSeq, i) == this.at(prefix, i));
    }

    public static boolean endsWith$(ByteSequence $this, Object byteSeq, Object suffix) {
        return $this.endsWith(byteSeq, suffix);
    }

    default public boolean endsWith(ByteSeq byteSeq, ByteSeq suffix) {
        int n = this.length(suffix);
        int m = this.length(byteSeq) - n;
        return m >= 0 && RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).forall((Function1)(JFunction1.mcZI.sp & Serializable)i -> this.at(byteSeq, m + i) == this.at(suffix, i));
    }

    public static Object take$(ByteSequence $this, Object byteSeq, int n) {
        return $this.take(byteSeq, n);
    }

    default public ByteSeq take(ByteSeq byteSeq, int n) {
        return this.slice(byteSeq, 0, n);
    }

    public static Object drop$(ByteSequence $this, Object byteSeq, int n) {
        return $this.drop(byteSeq, n);
    }

    default public ByteSeq drop(ByteSeq byteSeq, int n) {
        return this.slice(byteSeq, n, this.length(byteSeq));
    }

    public static Object slice$(ByteSequence $this, Object byteSeq, int from, int until) {
        return $this.slice(byteSeq, from, until);
    }

    default public ByteSeq slice(ByteSeq byteSeq, int from, int until) {
        if (from <= 0 && this.lengthIs(byteSeq) <= until) {
            return byteSeq;
        }
        Object object = Predef$.MODULE$.byteArrayOps(this.unsafeArray(byteSeq));
        return this.unsafeWrap((byte[])ArrayOps$.MODULE$.slice$extension(object, from, until));
    }

    public static Object concat$(ByteSequence $this, Object start, Object tail) {
        return $this.concat(start, tail);
    }

    default public ByteSeq concat(ByteSeq start, ByteSeq tail) {
        return (ByteSeq)package.semigroup$.MODULE$.catsSyntaxSemigroup(start, this.implicitByteSequence()).$bar$plus$bar(tail);
    }

    public static Stream chunkStream$(ByteSequence $this, Object byteSeq, int maxSize) {
        return $this.chunkStream(byteSeq, maxSize);
    }

    default public <F> Stream<F, ByteSeq> chunkStream(ByteSeq byteSeq, int maxSize) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)ByteSequence.v$proxy1$1(maxSize)), "maxSize >= 1"), FullName$.MODULE$.apply("js7.base.data.ByteSequence.chunkStream"), FileName$.MODULE$.apply("ByteSequence.scala"), Line$.MODULE$.apply(225));
        int n = this.length(byteSeq);
        if (0 == n) {
            return Stream$.MODULE$.empty();
        }
        if (1 == n) {
            return Stream$.MODULE$.emit(byteSeq);
        }
        int byteSeqLength = n;
        return Stream$.MODULE$.unfold((Object)BoxesRunTime.boxToInteger((int)0), (Function1 & Serializable)offset -> this.chunkStream$$anonfun$1(maxSize, byteSeqLength, byteSeq, BoxesRunTime.unboxToInt((Object)offset)));
    }

    public static Stream byteStream$(ByteSequence $this, Object byteSeq, int chunkSize) {
        return $this.byteStream(byteSeq, chunkSize);
    }

    default public <F> Stream<F, Object> byteStream(ByteSeq byteSeq2, int chunkSize) {
        int n = this.length(byteSeq2);
        if (0 == n) {
            return Stream$.MODULE$.empty();
        }
        if (1 == n) {
            return Stream$.MODULE$.emit((Object)BoxesRunTime.boxToByte((byte)this.at(byteSeq2, 0)));
        }
        Option<byte[]> option = this.unsafeWrappedArray(byteSeq2);
        if (None$.MODULE$.equals(option)) {
            return this.chunkStream(byteSeq2, chunkSize).map((Function1 & Serializable)byteSeq -> Chunk$.MODULE$.array((Object)this.unsafeArray(byteSeq), ClassTag$.MODULE$.apply(Byte.TYPE))).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        if (option instanceof Some) {
            byte[] array = (byte[])((Some)option).value();
            return Stream$.MODULE$.unfoldChunk((Object)BoxesRunTime.boxToInteger((int)0), (Function1 & Serializable)offset -> ByteSequence.byteStream$$anonfun$2(chunkSize, array, BoxesRunTime.unboxToInt((Object)offset)));
        }
        throw new MatchError(option);
    }

    public Iterator<Object> iterator(ByteSeq var1);

    public static String utf8String$(ByteSequence $this, Object byteSeq) {
        return $this.utf8String(byteSeq);
    }

    default public String utf8String(ByteSeq byteSeq) {
        return new String(this.unsafeArray(byteSeq), StandardCharsets.UTF_8);
    }

    public static String utf8StringTruncateAt$(ByteSequence $this, Object byteSeq, int truncateAt) {
        return $this.utf8StringTruncateAt(byteSeq, truncateAt);
    }

    default public String utf8StringTruncateAt(ByteSeq byteSeq, int truncateAt) {
        String string = ScalaUtils$syntax$.MODULE$.RichString(this.utf8String(byteSeq));
        return ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, truncateAt, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string));
    }

    public byte[] toArray(ByteSeq var1);

    public static byte[] unsafeArray$(ByteSequence $this, Object byteSeq) {
        return $this.unsafeArray(byteSeq);
    }

    default public byte[] unsafeArray(ByteSeq byteSeq) {
        return (byte[])this.unsafeWrappedArray(byteSeq).getOrElse(() -> this.unsafeArray$$anonfun$1(byteSeq));
    }

    public static Option unsafeWrappedArray$(ByteSequence $this, Object byteSeq) {
        return $this.unsafeWrappedArray(byteSeq);
    }

    default public Option<byte[]> unsafeWrappedArray(ByteSeq byteSeq) {
        return None$.MODULE$;
    }

    public static int copyToArray$(ByteSequence $this, Object byteSeq, byte[] array) {
        return $this.copyToArray(byteSeq, array);
    }

    default public int copyToArray(ByteSeq byteSeq, byte[] array) {
        return this.copyToArray(byteSeq, array, 0, Integer.MAX_VALUE);
    }

    public static int copyToArray$(ByteSequence $this, Object byteSeq, byte[] array, int start, int len) {
        return $this.copyToArray(byteSeq, array, start, len);
    }

    default public int copyToArray(ByteSeq byteSeq, byte[] array, int start, int len) {
        return this.iterator(byteSeq).copyToArray((Object)array, start, len);
    }

    public static ByteArray toByteArray$(ByteSequence $this, Object byteSeq) {
        return $this.toByteArray(byteSeq);
    }

    default public ByteArray toByteArray(ByteSeq byteSeq) {
        return this.toByteSequence(byteSeq, ByteArray$.MODULE$);
    }

    public static Object toByteSequence$(ByteSequence $this, Object byteSeq, ByteSequence A) {
        return $this.toByteSequence(byteSeq, A);
    }

    default public <A> A toByteSequence(ByteSeq byteSeq, ByteSequence<A> A) {
        if (A == this) {
            return (A)byteSeq;
        }
        return A.unsafeWrap(this.unsafeArray(byteSeq));
    }

    public static ByteBuffer toByteBuffer$(ByteSequence $this, Object byteSeq) {
        return $this.toByteBuffer(byteSeq);
    }

    default public ByteBuffer toByteBuffer(ByteSeq byteSeq) {
        return ByteBuffer.wrap(this.unsafeArray(byteSeq)).asReadOnlyBuffer();
    }

    public static InputStream toInputStream$(ByteSequence $this, Object byteSeq) {
        return $this.toInputStream(byteSeq);
    }

    default public InputStream toInputStream(ByteSeq byteSeq) {
        return new ByteSequenceInputStream<ByteSeq>(byteSeq, this.implicitByteSequence());
    }

    public static Resource toInputStreamResource$(ByteSequence $this, Object byteSeq) {
        return $this.toInputStreamResource(byteSeq);
    }

    default public Resource<SyncIO, InputStream> toInputStreamResource(ByteSeq byteSeq) {
        return cats.effect.package$.MODULE$.Resource().fromAutoCloseable((Object)SyncIO$.MODULE$.apply(() -> this.toInputStreamResource$$anonfun$1(byteSeq)), SyncIO$.MODULE$.syncForSyncIO());
    }

    public static void writeToStream$(ByteSequence $this, Object byteSeq, OutputStream out) {
        $this.writeToStream((ByteSeq)byteSeq, out);
    }

    @Override
    default public void writeToStream(ByteSeq byteSeq, OutputStream out) {
        this.toInputStream(byteSeq).transferTo(out);
    }

    public static Either parseJsonAs$(ByteSequence $this, Object byteSeq, Decoder evidence$1) {
        return $this.parseJsonAs(byteSeq, evidence$1);
    }

    default public <B> Either<Problem, B> parseJsonAs(ByteSeq byteSeq, Decoder<B> evidence$1) {
        return this.parseJson(byteSeq).flatMap((Function1 & Serializable)_$5 -> CirceUtils$RichJson$.MODULE$.checkedAs$extension(CirceUtils$.MODULE$.RichJson((Json)_$5), evidence$1));
    }

    public static Either parseJson$(ByteSequence $this, Object byteSeq) {
        return $this.parseJson(byteSeq);
    }

    default public Either<Problem, Json> parseJson(ByteSeq byteSeq) {
        Either either = CirceUtils$.MODULE$.RichCirceEither(CirceUtils$.MODULE$.parseJsonByteArray(this.unsafeArray(byteSeq)));
        return CirceUtils$RichCirceEither$.MODULE$.toChecked$extension(either);
    }

    private static String fromMimeBase64$$anonfun$1(IllegalArgumentException e$1) {
        return "Invalid MIME base64 encoding: " + e$1.getMessage();
    }

    private static Object fromInputStreamUnlimited$$anonfun$1() {
        throw new RuntimeException("fromInputStreamUnlimited");
    }

    private static /* synthetic */ boolean show$$anonfun$1(byte o) {
        return o >= 32 && o < 127 || o == 10 || o == 13;
    }

    private static String show$$anonfun$3(int len$1) {
        return " (" + len$1 + " bytes)";
    }

    private static String show$$anonfun$4(int len$2) {
        return ", " + len$2 + " bytes";
    }

    private static String toStringAndHexRaw$$anonfun$1$$anonfun$2() {
        return "\u2026";
    }

    private String toStringAndHexRaw$$anonfun$1(Object byteSeq$1, int n$1, boolean withEllipsis$1) {
        return "\u00bb" + this.iterator(byteSeq$1).take(n$1).grouped(8).map((Function1 & Serializable)_$1 -> ((IterableOnceOps)_$1.map((Function1 & Serializable)object -> Ascii$.MODULE$.byteToPrintableChar(BoxesRunTime.unboxToByte((Object)object)))).mkString()).mkString() + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(withEllipsis$1 || this.lengthIs(byteSeq$1) > n$1), (Function0<String>)((Function0 & Serializable)ByteSequence::toStringAndHexRaw$$anonfun$1$$anonfun$2)) + "\u00ab " + this.toHexRaw(byteSeq$1, n$1, withEllipsis$1);
    }

    private static String toHexRaw$$anonfun$2() {
        return "...";
    }

    private byte a$proxy1$1(Object byteSeq$2) {
        return this.at(byteSeq$2, 0);
    }

    private byte headOption$$anonfun$1(Object byteSeq$10) {
        return this.a$proxy1$1(byteSeq$10);
    }

    private byte a$proxy2$1(Object byteSeq$3) {
        return this.at(byteSeq$3, this.length(byteSeq$3) - 1);
    }

    private byte lastOption$$anonfun$1(Object byteSeq$11) {
        return this.a$proxy2$1(byteSeq$11);
    }

    private static boolean v$proxy1$1(int maxSize$1) {
        return maxSize$1 >= 1;
    }

    private Tuple2 a$proxy3$1(Object byteSeq$7, int offset$1, int chunkLength$1) {
        return Tuple2$.MODULE$.apply(this.slice(byteSeq$7, offset$1, offset$1 + chunkLength$1), (Object)BoxesRunTime.boxToInteger((int)(offset$1 + chunkLength$1)));
    }

    private Tuple2 chunkStream$$anonfun$1$$anonfun$1(Object byteSeq$12, int offset$3, int chunkLength$3) {
        return this.a$proxy3$1(byteSeq$12, offset$3, chunkLength$3);
    }

    private /* synthetic */ Option chunkStream$$anonfun$1(int maxSize$2, int byteSeqLength$1, Object byteSeq$6, int offset) {
        int chunkLength = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(maxSize$2), byteSeqLength$1 - offset);
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(chunkLength > 0);
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> this.chunkStream$$anonfun$1$$anonfun$1(byteSeq$6, offset, chunkLength));
    }

    private static Tuple2 a$proxy4$1(byte[] array$2, int offset$2, int chunkLength$2) {
        return Tuple2$.MODULE$.apply((Object)Chunk$.MODULE$.array((Object)array$2, offset$2, chunkLength$2, ClassTag$.MODULE$.apply(Byte.TYPE)), (Object)BoxesRunTime.boxToInteger((int)(offset$2 + chunkLength$2)));
    }

    private static Tuple2 byteStream$$anonfun$2$$anonfun$1(byte[] array$3, int offset$4, int chunkLength$4) {
        return ByteSequence.a$proxy4$1(array$3, offset$4, chunkLength$4);
    }

    private static /* synthetic */ Option byteStream$$anonfun$2(int chunkSize$1, byte[] array$1, int offset) {
        int chunkLength = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(chunkSize$1), array$1.length - offset);
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(chunkLength > 0);
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> ByteSequence.byteStream$$anonfun$2$$anonfun$1(array$1, offset, chunkLength));
    }

    private byte[] unsafeArray$$anonfun$1(Object byteSeq$8) {
        return this.toArray(byteSeq$8);
    }

    private InputStream toInputStreamResource$$anonfun$1(Object byteSeq$9) {
        return this.toInputStream(byteSeq$9);
    }

    public static interface AllOps<ByteSeq>
    extends Ops<ByteSeq> {
        @Override
        public ByteSequence<ByteSeq> typeClassInstance();
    }

    public static interface Ops<ByteSeq> {
        public ByteSequence<ByteSeq> typeClassInstance();

        public ByteSeq self();

        public static String show$(Ops $this) {
            return $this.show();
        }

        default public String show() {
            return this.typeClassInstance().show(this.self());
        }

        public static String show$(Ops $this, int limit) {
            return $this.show(limit);
        }

        default public String show(int limit) {
            return this.typeClassInstance().show(this.self(), limit);
        }

        public static String toStringAndHexRaw$(Ops $this, int n, boolean withEllipsis) {
            return $this.toStringAndHexRaw(n, withEllipsis);
        }

        default public String toStringAndHexRaw(int n, boolean withEllipsis) {
            return this.typeClassInstance().toStringAndHexRaw(this.self(), n, withEllipsis);
        }

        public static int toStringAndHexRaw$default$1$(Ops $this) {
            return $this.toStringAndHexRaw$default$1();
        }

        default public int toStringAndHexRaw$default$1() {
            return Integer.MAX_VALUE;
        }

        public static boolean toStringAndHexRaw$default$2$(Ops $this) {
            return $this.toStringAndHexRaw$default$2();
        }

        default public boolean toStringAndHexRaw$default$2() {
            return false;
        }

        public static String toHexRaw$(Ops $this) {
            return $this.toHexRaw();
        }

        default public String toHexRaw() {
            return this.typeClassInstance().toHexRaw(this.self());
        }

        public static String toHexRaw$(Ops $this, int n, boolean withEllipsis) {
            return $this.toHexRaw(n, withEllipsis);
        }

        default public String toHexRaw(int n, boolean withEllipsis) {
            return this.typeClassInstance().toHexRaw(this.self(), n, withEllipsis);
        }

        public static int toHexRaw$default$1$(Ops $this) {
            return $this.toHexRaw$default$1();
        }

        default public int toHexRaw$default$1() {
            return Integer.MAX_VALUE;
        }

        public static boolean toHexRaw$default$2$(Ops $this) {
            return $this.toHexRaw$default$2();
        }

        default public boolean toHexRaw$default$2() {
            return false;
        }

        public static String toHex$(Ops $this) {
            return $this.toHex();
        }

        default public String toHex() {
            return this.typeClassInstance().toHex(this.self());
        }

        public static boolean nonEmpty$(Ops $this) {
            return $this.nonEmpty();
        }

        default public boolean nonEmpty() {
            return this.typeClassInstance().nonEmpty(this.self());
        }

        public static int intLength$(Ops $this) {
            return $this.intLength();
        }

        default public int intLength() {
            return this.typeClassInstance().intLength(this.self());
        }

        public static int length$(Ops $this) {
            return $this.length();
        }

        default public int length() {
            return this.typeClassInstance().length(this.self());
        }

        public static int lengthIs$(Ops $this) {
            return $this.lengthIs();
        }

        default public int lengthIs() {
            return this.typeClassInstance().lengthIs(this.self());
        }

        public static byte apply$(Ops $this, int i) {
            return $this.apply(i);
        }

        default public byte apply(int i) {
            return this.typeClassInstance().at(this.self(), i);
        }

        public static Option headOption$(Ops $this) {
            return $this.headOption();
        }

        default public Option<Object> headOption() {
            return this.typeClassInstance().headOption(this.self());
        }

        public static Option lastOption$(Ops $this) {
            return $this.lastOption();
        }

        default public Option<Object> lastOption() {
            return this.typeClassInstance().lastOption(this.self());
        }

        public static int indexOf$(Ops $this, byte by) {
            return $this.indexOf(by);
        }

        default public int indexOf(byte by) {
            return this.typeClassInstance().indexOf(this.self(), by);
        }

        public static int indexOf$(Ops $this, byte by, int from) {
            return $this.indexOf(by, from);
        }

        default public int indexOf(byte by, int from) {
            return this.typeClassInstance().indexOf(this.self(), by, from);
        }

        public static int indexOf$(Ops $this, byte by, int from, int until) {
            return $this.indexOf(by, from, until);
        }

        default public int indexOf(byte by, int from, int until) {
            return this.typeClassInstance().indexOf(this.self(), by, from, until);
        }

        public static boolean startsWith$(Ops $this, Object prefix) {
            return $this.startsWith(prefix);
        }

        default public boolean startsWith(ByteSeq prefix) {
            return this.typeClassInstance().startsWith(this.self(), prefix);
        }

        public static boolean endsWith$(Ops $this, Object suffix) {
            return $this.endsWith(suffix);
        }

        default public boolean endsWith(ByteSeq suffix) {
            return this.typeClassInstance().endsWith(this.self(), suffix);
        }

        public static Object take$(Ops $this, int n) {
            return $this.take(n);
        }

        default public ByteSeq take(int n) {
            return this.typeClassInstance().take(this.self(), n);
        }

        public static Object drop$(Ops $this, int n) {
            return $this.drop(n);
        }

        default public ByteSeq drop(int n) {
            return this.typeClassInstance().drop(this.self(), n);
        }

        public static Object slice$(Ops $this, int from, int until) {
            return $this.slice(from, until);
        }

        default public ByteSeq slice(int from, int until) {
            return this.typeClassInstance().slice(this.self(), from, until);
        }

        public static Object concat$(Ops $this, Object tail) {
            return $this.concat(tail);
        }

        default public ByteSeq concat(ByteSeq tail) {
            return this.typeClassInstance().concat(this.self(), tail);
        }

        public static Stream chunkStream$(Ops $this, int chunkSize) {
            return $this.chunkStream(chunkSize);
        }

        default public <F> Stream<F, ByteSeq> chunkStream(int chunkSize) {
            return this.typeClassInstance().chunkStream(this.self(), chunkSize);
        }

        public static Chunk toChunk$(Ops $this) {
            return $this.toChunk();
        }

        default public Chunk<Object> toChunk() {
            return this.typeClassInstance().toChunk(this.self());
        }

        public static Stream byteStream$(Ops $this, int chunkSize) {
            return $this.byteStream(chunkSize);
        }

        default public <F> Stream<F, Object> byteStream(int chunkSize) {
            return this.typeClassInstance().byteStream(this.self(), chunkSize);
        }

        public static Iterator iterator$(Ops $this) {
            return $this.iterator();
        }

        default public Iterator<Object> iterator() {
            return this.typeClassInstance().iterator(this.self());
        }

        public static String utf8String$(Ops $this) {
            return $this.utf8String();
        }

        default public String utf8String() {
            return this.typeClassInstance().utf8String(this.self());
        }

        public static String utf8StringTruncateAt$(Ops $this, int truncateAt) {
            return $this.utf8StringTruncateAt(truncateAt);
        }

        default public String utf8StringTruncateAt(int truncateAt) {
            return this.typeClassInstance().utf8StringTruncateAt(this.self(), truncateAt);
        }

        public static byte[] toArray$(Ops $this) {
            return $this.toArray();
        }

        default public byte[] toArray() {
            return this.typeClassInstance().toArray(this.self());
        }

        public static byte[] unsafeArray$(Ops $this) {
            return $this.unsafeArray();
        }

        default public byte[] unsafeArray() {
            return this.typeClassInstance().unsafeArray(this.self());
        }

        public static Option unsafeWrappedArray$(Ops $this) {
            return $this.unsafeWrappedArray();
        }

        default public Option<byte[]> unsafeWrappedArray() {
            return this.typeClassInstance().unsafeWrappedArray(this.self());
        }

        public static int copyToArray$(Ops $this, byte[] array) {
            return $this.copyToArray(array);
        }

        default public int copyToArray(byte[] array) {
            return this.typeClassInstance().copyToArray(this.self(), array);
        }

        public static int copyToArray$(Ops $this, byte[] array, int start, int len) {
            return $this.copyToArray(array, start, len);
        }

        default public int copyToArray(byte[] array, int start, int len) {
            return this.typeClassInstance().copyToArray(this.self(), array, start, len);
        }

        public static ByteArray toByteArray$(Ops $this) {
            return $this.toByteArray();
        }

        default public ByteArray toByteArray() {
            return this.typeClassInstance().toByteArray(this.self());
        }

        public static Object toByteSequence$(Ops $this, ByteSequence A) {
            return $this.toByteSequence(A);
        }

        default public <A> A toByteSequence(ByteSequence<A> A) {
            return this.typeClassInstance().toByteSequence(this.self(), A);
        }

        public static ByteBuffer toByteBuffer$(Ops $this) {
            return $this.toByteBuffer();
        }

        default public ByteBuffer toByteBuffer() {
            return this.typeClassInstance().toByteBuffer(this.self());
        }

        public static InputStream toInputStream$(Ops $this) {
            return $this.toInputStream();
        }

        default public InputStream toInputStream() {
            return this.typeClassInstance().toInputStream(this.self());
        }

        public static Resource toInputStreamResource$(Ops $this) {
            return $this.toInputStreamResource();
        }

        default public Resource<SyncIO, InputStream> toInputStreamResource() {
            return this.typeClassInstance().toInputStreamResource(this.self());
        }

        public static void writeToStream$(Ops $this, OutputStream out) {
            $this.writeToStream(out);
        }

        default public void writeToStream(OutputStream out) {
            this.typeClassInstance().writeToStream(this.self(), out);
        }

        public static Either parseJsonAs$(Ops $this, Decoder evidence$1) {
            return $this.parseJsonAs(evidence$1);
        }

        default public <B> Either<Problem, B> parseJsonAs(Decoder<B> evidence$1) {
            return this.typeClassInstance().parseJsonAs(this.self(), evidence$1);
        }

        public static Either parseJson$(Ops $this) {
            return $this.parseJson();
        }

        default public Either<Problem, Json> parseJson() {
            return this.typeClassInstance().parseJson(this.self());
        }
    }

    public static interface ToByteSequenceOps {
        public static Ops toByteSequenceOps$(ToByteSequenceOps $this, Object target, ByteSequence tc) {
            return $this.toByteSequenceOps(target, tc);
        }

        default public <ByteSeq> Ops<ByteSeq> toByteSequenceOps(ByteSeq target, ByteSequence<ByteSeq> tc) {
            return new Ops<ByteSeq>(target, tc){
                private final Object self;
                private final ByteSequence typeClassInstance;
                {
                    this.self = target$1;
                    this.typeClassInstance = tc$1;
                }

                public Object self() {
                    return this.self;
                }

                public ByteSequence typeClassInstance() {
                    return this.typeClassInstance;
                }
            };
        }
    }
}

