/*
 * Decompiled with CFR 0.152.
 */
package js7.controller.tests;

import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import js7.base.io.file.FileUtils$;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.controller.tests.TestDockerEnvironment$;
import js7.data.agent.AgentPath;
import js7.data.item.SourceType;
import js7.data.item.VersionedItemPath;
import scala.Function1;
import scala.collection.immutable.Seq;

public final class TestDockerEnvironment
implements AutoCloseable {
    private final Path temporaryDirectory;

    public TestDockerEnvironment(Seq<AgentPath> agentPaths, Path temporaryDirectory) {
        this.temporaryDirectory = temporaryDirectory;
        if (Files.exists(temporaryDirectory, new LinkOption[0])) {
            Logger LoggerImpl_this = TestDockerEnvironment$.js7$controller$tests$TestDockerEnvironment$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("Deleting {}", (Object)temporaryDirectory);
            }
            FileUtils$.MODULE$.deleteDirectoryContentRecursively(temporaryDirectory);
        }
        Files.createDirectories(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.controllerDir()), "config/private"), new FileAttribute[0]);
        Files.createDirectories(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.controllerDir()), "data"), new FileAttribute[0]);
        agentPaths.foreach((Function1 & Serializable)agentPath -> {
            Files.createDirectories(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.agentDir((AgentPath)agentPath)), "config/private"), new FileAttribute[0]);
            Files.createDirectories(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.agentDir((AgentPath)agentPath)), "config/executables"), new FileAttribute[0]);
            return Files.createDirectory(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.agentDir((AgentPath)agentPath)), "data"), new FileAttribute[0]);
        });
    }

    @Override
    public void close() {
        block2: {
            FileUtils$.MODULE$.deleteDirectoryContentRecursively(this.temporaryDirectory);
            try {
                Files.deleteIfExists(this.temporaryDirectory);
            }
            catch (IOException t) {
                Logger LoggerImpl_this = TestDockerEnvironment$.js7$controller$tests$TestDockerEnvironment$$$logger;
                if (!LoggerImpl_this.underlying().isDebugEnabled()) break block2;
                LoggerImpl_this.underlying().debug("Delete " + this.temporaryDirectory + ": " + t, (Throwable)t);
            }
        }
    }

    public Path controllerDir() {
        return FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.temporaryDirectory), "controller");
    }

    public Path agentFile(AgentPath agentPath, VersionedItemPath path, SourceType t) {
        return FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.agentDir(agentPath)), "config/live").resolve(path.toFile(t));
    }

    public Path agentDir(AgentPath name) {
        return FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.agentsDir()), name.string());
    }

    public Path agentsDir() {
        return FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.temporaryDirectory), "agents");
    }
}

