/*
 * Decompiled with CFR 0.152.
 */
package js7.data.execution.workflow.instructions;

import java.io.Serializable;
import java.time.ZoneId;
import js7.base.monixlike.SerialSyncCancelable;
import js7.base.monixlike.SerialSyncCancelable$;
import js7.base.time.AdmissionTimeScheme;
import js7.base.time.AdmissionTimeSchemeForJavaTime$;
import js7.base.time.AdmissionTimeSchemeForJavaTime$RichAdmissionTimeScheme$;
import js7.base.time.AlarmClock;
import js7.base.time.TimeInterval;
import js7.base.time.TimeInterval$;
import js7.base.time.Timestamp;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.data.execution.workflow.instructions.ExecuteExecutor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.NotGiven$;
import sourcecode.FullName$;

public final class ExecuteAdmissionTimeSwitch {
    private final AdmissionTimeScheme admissionTimeScheme;
    private final ZoneId zone;
    private final Function1<Option<TimeInterval>, BoxedUnit> onSwitch;
    private volatile Option<Timestamp> _nextTime;
    private final SerialSyncCancelable _timer;

    public ExecuteAdmissionTimeSwitch(AdmissionTimeScheme admissionTimeScheme, ZoneId zone, Function1<Option<TimeInterval>, BoxedUnit> onSwitch) {
        this.admissionTimeScheme = admissionTimeScheme;
        this.zone = zone;
        this.onSwitch = onSwitch;
        this._nextTime = None$.MODULE$;
        this._timer = new SerialSyncCancelable(SerialSyncCancelable$.MODULE$.$lessinit$greater$default$1());
    }

    public Option<Timestamp> nextTime() {
        return this._nextTime;
    }

    public void cancel() {
        this._nextTime = None$.MODULE$;
        this._timer.cancel();
    }

    public boolean updateAndCheck(Function0<BoxedUnit> onAdmissionStart, AlarmClock clock) {
        return BoxesRunTime.unboxToBoolean(clock.lock(() -> this.updateAndCheck$$anonfun$1(clock, onAdmissionStart), NotGiven$.MODULE$.value()));
    }

    private static final TimeInterval updateAndCheck$$anonfun$1$$anonfun$1(TimeInterval interval$1) {
        return interval$1;
    }

    private final void updateAndCheck$$anonfun$1$$anonfun$2(Function0 onAdmissionStart$2) {
        this._nextTime = None$.MODULE$;
        onAdmissionStart$2.apply$mcV$sp();
    }

    private final boolean updateAndCheck$$anonfun$1(AlarmClock clock$1, Function0 onAdmissionStart$1) {
        Timestamp now = clock$1.now();
        Option<TimeInterval> option = AdmissionTimeSchemeForJavaTime$RichAdmissionTimeScheme$.MODULE$.findTimeInterval$extension(AdmissionTimeSchemeForJavaTime$.MODULE$.RichAdmissionTimeScheme(this.admissionTimeScheme), now, this.zone, ExecuteExecutor$.MODULE$.noDateOffset());
        if (None$.MODULE$.equals(option)) {
            this._timer.cancel();
            return false;
        }
        if (option instanceof Some) {
            TimeInterval interval = (TimeInterval)((Some)option).value();
            if (!this._nextTime.contains((Object)interval.start())) {
                TimeInterval timeInterval = interval;
                TimeInterval timeInterval2 = TimeInterval$.MODULE$.never();
                boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(timeInterval == null ? timeInterval2 != null : !timeInterval.equals(timeInterval2));
                this.onSwitch.apply(ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> ExecuteAdmissionTimeSwitch.updateAndCheck$$anonfun$1$$anonfun$1(interval)));
                if (now.$less(interval.start())) {
                    this._nextTime = Some$.MODULE$.apply((Object)interval.start());
                    this._timer.set(clock$1.scheduleAt(interval.start(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.updateAndCheck$$anonfun$1$$anonfun$2(onAdmissionStart$1);
                        return BoxedUnit.UNIT;
                    }, FullName$.MODULE$.apply("js7.data.execution.workflow.instructions.ExecuteAdmissionTimeSwitch.updateAndCheck")));
                }
            }
            return interval.contains(now);
        }
        throw new MatchError(option);
    }
}

