/*
 * Decompiled with CFR 0.152.
 */
package js7.data.execution.workflow.instructions;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.problem.Problem;
import js7.base.time.WallClock;
import js7.base.utils.Collections$implicits$;
import js7.base.utils.Collections$implicits$RichIterable$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import js7.base.utils.SubclassToX;
import js7.data.event.KeyedEvent;
import js7.data.execution.workflow.instructions.AddOrderExecutor;
import js7.data.execution.workflow.instructions.BreakExecutor;
import js7.data.execution.workflow.instructions.BreakOrderExecutor;
import js7.data.execution.workflow.instructions.ConsumeNoticesExecutor;
import js7.data.execution.workflow.instructions.CycleExecutor;
import js7.data.execution.workflow.instructions.EmptyExecutor;
import js7.data.execution.workflow.instructions.EndExecutor;
import js7.data.execution.workflow.instructions.EventInstructionExecutor;
import js7.data.execution.workflow.instructions.ExecuteExecutor;
import js7.data.execution.workflow.instructions.ExpectNoticesExecutor;
import js7.data.execution.workflow.instructions.FailExecutor;
import js7.data.execution.workflow.instructions.FinishExecutor;
import js7.data.execution.workflow.instructions.ForkExecutor;
import js7.data.execution.workflow.instructions.ForkInstructionExecutor;
import js7.data.execution.workflow.instructions.ForkListExecutor;
import js7.data.execution.workflow.instructions.GapExecutor;
import js7.data.execution.workflow.instructions.IfExecutor;
import js7.data.execution.workflow.instructions.InstructionExecutor;
import js7.data.execution.workflow.instructions.LockExecutor;
import js7.data.execution.workflow.instructions.OptionsExecutor;
import js7.data.execution.workflow.instructions.PositionInstructionExecutor;
import js7.data.execution.workflow.instructions.PostNoticesExecutor;
import js7.data.execution.workflow.instructions.PromptExecutor;
import js7.data.execution.workflow.instructions.RetryExecutor;
import js7.data.execution.workflow.instructions.StickySubagentExecutor;
import js7.data.execution.workflow.instructions.StopExecutor;
import js7.data.execution.workflow.instructions.TryExecutor;
import js7.data.order.Order;
import js7.data.order.OrderEvent;
import js7.data.order.OrderId;
import js7.data.order.OrderObstacle;
import js7.data.order.OrderObstacleCalculator;
import js7.data.state.StateView;
import js7.data.workflow.Instruction;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class InstructionExecutorService {
    private final WallClock clock;
    private final FinishExecutor finishExecutor;
    private final SubclassToX<Instruction, EventInstructionExecutor> classToExecutor;
    private final ForkInstructionExecutor.Cache forkCache;

    public InstructionExecutorService(WallClock clock) {
        this.clock = clock;
        this.finishExecutor = new FinishExecutor(this);
        Seq seq = (Seq)Collections$implicits$.MODULE$.RichIterable((Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EventInstructionExecutor[]{new EmptyExecutor(this), new EndExecutor(this), new ExecuteExecutor(this), new FailExecutor(this), this.finishExecutor(), new ForkExecutor(this), new ForkListExecutor(this), new GapExecutor(this), new IfExecutor(this), new TryExecutor(this), new LockExecutor(this), new PostNoticesExecutor(this), new ExpectNoticesExecutor(this), new ConsumeNoticesExecutor(this), new PromptExecutor(this), new RetryExecutor(this), new AddOrderExecutor(this), new StickySubagentExecutor(this), new OptionsExecutor(this), new StopExecutor(this), new BreakOrderExecutor(this), new CycleExecutor(this), new BreakExecutor(this)})));
        this.classToExecutor = new SubclassToX(Collections$implicits$RichIterable$.MODULE$.toKeyedMap$extension((Iterable)seq, (Function1 & Serializable)_$1 -> _$1.instructionClass()), ClassTag$.MODULE$.apply(Instruction.class));
        this.forkCache = new ForkInstructionExecutor.Cache();
    }

    public WallClock clock() {
        return this.clock;
    }

    public FinishExecutor finishExecutor() {
        return this.finishExecutor;
    }

    public ForkInstructionExecutor.Cache forkCache() {
        return this.forkCache;
    }

    public InstructionExecutor instructionToExecutor(Instruction instr) {
        Either either = ScalaUtils$syntax$.MODULE$.RichEither(this.classToExecutor.checked(instr.getClass()));
        return (EventInstructionExecutor)ScalaUtils$syntax$RichEither$.MODULE$.orThrow$extension(either);
    }

    public Either<Problem, Option<OrderEvent.OrderMoved>> nextMove(Instruction instruction, Order<Order.State> order, StateView stateView) {
        InstructionExecutor instructionExecutor = this.instructionToExecutor(instruction);
        if (instructionExecutor instanceof PositionInstructionExecutor) {
            PositionInstructionExecutor executor = (PositionInstructionExecutor)instructionExecutor;
            return executor.nextMove(instruction, order, stateView);
        }
        return package$.MODULE$.Right().apply((Object)None$.MODULE$);
    }

    public Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> toEvents(OrderId orderId, StateView stateView) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(stateView.idToOrder());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, orderId, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))).flatMap((Function1 & Serializable)order -> this.toEvents(stateView.instruction(order.workflowPosition()), (Order<Order.State>)order, stateView).map((Function1 & Serializable)events -> events));
    }

    public Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> toEvents(Order<Order.State> order, StateView stateView) {
        return this.toEvents(stateView.instruction(order.workflowPosition()), order, stateView);
    }

    public Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> toEvents(Instruction instruction, Order<Order.State> order, StateView stateView) {
        InstructionExecutor instructionExecutor = this.instructionToExecutor(instruction);
        if (instructionExecutor instanceof EventInstructionExecutor) {
            EventInstructionExecutor exec = (EventInstructionExecutor)instructionExecutor;
            return exec.toEvents(instruction, order, stateView);
        }
        return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil());
    }

    public Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> onReturnFromSubworkflow(Instruction instr, Order<Order.State> order, StateView state) {
        InstructionExecutor executor = this.instructionToExecutor(instr);
        return executor.onReturnFromSubworkflow(instr, order, state);
    }

    public Either<Problem, Set<OrderObstacle>> toObstacles(Order<Order.State> order, OrderObstacleCalculator calculator) {
        return this.instructionToExecutor(calculator.stateView().instruction(order.workflowPosition())).toObstacles(order, calculator);
    }
}

