/*
 * Decompiled with CFR 0.152.
 */
package js7.data.orderwatch;

import cats.effect.IO;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import fs2.Stream$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.circeutils.typed.TypedJsonCodec;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.Collections$;
import js7.base.utils.Collections$RichMap$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import js7.base.utils.Tests$;
import js7.data.event.KeyedEvent;
import js7.data.item.UnsignedSimpleItemEvent;
import js7.data.item.UnsignedSimpleItemEvent$UnsignedSimpleItemAdded$;
import js7.data.item.UnsignedSimpleItemState;
import js7.data.order.FreshOrder;
import js7.data.order.FreshOrder$;
import js7.data.order.Order;
import js7.data.order.OrderEvent;
import js7.data.order.OrderEvent$OrderExternalVanished$;
import js7.data.order.OrderId;
import js7.data.orderwatch.ExternalOrderKey;
import js7.data.orderwatch.ExternalOrderKey$;
import js7.data.orderwatch.ExternalOrderName;
import js7.data.orderwatch.OrderWatch;
import js7.data.orderwatch.OrderWatchEvent;
import js7.data.orderwatch.OrderWatchEvent$ExternalOrderArised$;
import js7.data.orderwatch.OrderWatchEvent$ExternalOrderVanished$;
import js7.data.orderwatch.OrderWatchPath;
import js7.data.orderwatch.OrderWatchState$;
import js7.data.orderwatch.OrderWatchState$Arised$;
import js7.data.orderwatch.OrderWatchState$ArisedOrHasOrder$;
import js7.data.orderwatch.OrderWatchState$ExternalOrderSnapshot$;
import js7.data.orderwatch.OrderWatchState$HasOrder$;
import js7.data.orderwatch.OrderWatchState$HeaderSnapshot$;
import js7.data.orderwatch.OrderWatchState$Snapshot$;
import js7.data.orderwatch.OrderWatchState$Vanished$;
import js7.data.orderwatch.OrderWatchState$VanishedOrArised$;
import js7.data.value.Value;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.View;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class OrderWatchState
implements UnsignedSimpleItemState,
Product,
Serializable {
    private final OrderWatch orderWatch;
    private final Map externalToState;
    private final Set orderAddedQueue;
    private final Set orderExternalVanishedQueue;
    private final OrderWatchState$ companion;
    private final OrderWatch item;

    public static OrderWatchState apply(OrderWatch orderWatch) {
        return OrderWatchState$.MODULE$.apply(orderWatch);
    }

    public static OrderWatchState apply(OrderWatch orderWatch, Map<ExternalOrderName, ArisedOrHasOrder> map, Set<ExternalOrderName> set, Set<ExternalOrderName> set2) {
        return OrderWatchState$.MODULE$.apply(orderWatch, map, set, set2);
    }

    public static OrderWatchState fromProduct(Product product) {
        return OrderWatchState$.MODULE$.fromProduct(product);
    }

    public static OrderWatchState unapply(OrderWatchState orderWatchState) {
        return OrderWatchState$.MODULE$.unapply(orderWatchState);
    }

    public static Map<ExternalOrderName, ArisedOrHasOrder> $lessinit$greater$default$2() {
        return OrderWatchState$.MODULE$.$lessinit$greater$default$2();
    }

    public static Set<ExternalOrderName> $lessinit$greater$default$3() {
        return OrderWatchState$.MODULE$.$lessinit$greater$default$3();
    }

    public static Set<ExternalOrderName> $lessinit$greater$default$4() {
        return OrderWatchState$.MODULE$.$lessinit$greater$default$4();
    }

    public OrderWatchState(OrderWatch orderWatch, Map<ExternalOrderName, ArisedOrHasOrder> externalToState, Set<ExternalOrderName> orderAddedQueue, Set<ExternalOrderName> orderExternalVanishedQueue) {
        this.orderWatch = orderWatch;
        this.externalToState = externalToState;
        this.orderAddedQueue = orderAddedQueue;
        this.orderExternalVanishedQueue = orderExternalVanishedQueue;
        this.companion = OrderWatchState$.MODULE$;
        this.item = orderWatch;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof OrderWatchState)) return false;
        OrderWatchState orderWatchState = (OrderWatchState)object;
        OrderWatch orderWatch = this.orderWatch();
        OrderWatch orderWatch2 = orderWatchState.orderWatch();
        if (orderWatch == null) {
            if (orderWatch2 != null) {
                return false;
            }
        } else if (!orderWatch.equals(orderWatch2)) return false;
        Map<ExternalOrderName, ArisedOrHasOrder> map = this.externalToState();
        Map<ExternalOrderName, ArisedOrHasOrder> map2 = orderWatchState.externalToState();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Set<ExternalOrderName> set = this.orderAddedQueue();
        Set<ExternalOrderName> set2 = orderWatchState.orderAddedQueue();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        Set<ExternalOrderName> set3 = this.orderExternalVanishedQueue();
        Set<ExternalOrderName> set4 = orderWatchState.orderExternalVanishedQueue();
        if (set3 == null) {
            if (set4 == null) return true;
            return false;
        } else {
            if (!set3.equals(set4)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof OrderWatchState;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "OrderWatchState";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "orderWatch";
            }
            case 1: {
                return "externalToState";
            }
            case 2: {
                return "orderAddedQueue";
            }
            case 3: {
                return "orderExternalVanishedQueue";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public OrderWatch orderWatch() {
        return this.orderWatch;
    }

    public Map<ExternalOrderName, ArisedOrHasOrder> externalToState() {
        return this.externalToState;
    }

    public Set<ExternalOrderName> orderAddedQueue() {
        return this.orderAddedQueue;
    }

    public Set<ExternalOrderName> orderExternalVanishedQueue() {
        return this.orderExternalVanishedQueue;
    }

    public OrderWatchState$ companion() {
        return this.companion;
    }

    @Override
    public OrderWatch item() {
        return this.item;
    }

    @Override
    public OrderWatchPath path() {
        return (OrderWatchPath)this.item().path();
    }

    public Either<Problem, OrderWatchState> updateItem(OrderWatch item) {
        return package$.MODULE$.Right().apply((Object)this.copy(item, this.copy$default$2(), this.copy$default$3(), this.copy$default$4()));
    }

    public OrderWatchPath id() {
        return (OrderWatchPath)this.orderWatch().key();
    }

    public Either<Problem, OrderWatchState> finishRecovery(Function1<OrderId, Object> isNotVanished) {
        return package$.MODULE$.Right().apply((Object)this.recalculateQueues(isNotVanished));
    }

    private OrderWatchState recalculateQueues(Function1<OrderId, Object> isNotVanished) {
        Set set = ((IterableOnceOps)this.externalToState().view().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x2) {
                Tuple2 tuple2 = x2;
                if (tuple2 != null) {
                    ExternalOrderName externalOrderName = (ExternalOrderName)tuple2._1();
                    if (tuple2._2() instanceof Arised) {
                        Arised arised = OrderWatchState$Arised$.MODULE$.unapply((Arised)tuple2._2());
                        OrderId orderId = arised._1();
                        Map<String, Value> map = arised._2();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x2, Function1 function1) {
                Tuple2 tuple2 = x2;
                if (tuple2 != null) {
                    ExternalOrderName externalOrderName = (ExternalOrderName)tuple2._1();
                    if (tuple2._2() instanceof Arised) {
                        Arised arised = OrderWatchState$Arised$.MODULE$.unapply((Arised)tuple2._2());
                        OrderId orderId = arised._1();
                        Map<String, Value> map = arised._2();
                        return externalOrderName;
                    }
                }
                return function1.apply((Object)x2);
            }
        })).toSet();
        Set set2 = ((IterableOnceOps)this.externalToState().view().collect((PartialFunction)new Serializable(isNotVanished){
            private final Function1 isNotVanished$1;
            {
                this.isNotVanished$1 = isNotVanished$2;
            }

            public final boolean isDefinedAt(Tuple2 x2) {
                Tuple2 tuple2 = x2;
                if (tuple2 != null) {
                    ArisedOrHasOrder arisedOrHasOrder = (ArisedOrHasOrder)tuple2._2();
                    ExternalOrderName externalOrderName = (ExternalOrderName)tuple2._1();
                    if (arisedOrHasOrder instanceof HasOrder) {
                        HasOrder hasOrder = OrderWatchState$HasOrder$.MODULE$.unapply((HasOrder)arisedOrHasOrder);
                        OrderId orderId = hasOrder._1();
                        Option<VanishedOrArised> option = hasOrder._2();
                        OrderId orderId2 = orderId;
                        if (option instanceof Some && BoxesRunTime.unboxToBoolean((Object)this.isNotVanished$1.apply((Object)orderId2))) {
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x2, Function1 function1) {
                Tuple2 tuple2 = x2;
                if (tuple2 != null) {
                    ArisedOrHasOrder arisedOrHasOrder = (ArisedOrHasOrder)tuple2._2();
                    ExternalOrderName externalOrderName = (ExternalOrderName)tuple2._1();
                    if (arisedOrHasOrder instanceof HasOrder) {
                        HasOrder hasOrder = OrderWatchState$HasOrder$.MODULE$.unapply((HasOrder)arisedOrHasOrder);
                        OrderId orderId = hasOrder._1();
                        Option<VanishedOrArised> option = hasOrder._2();
                        OrderId orderId2 = orderId;
                        if (option instanceof Some && BoxesRunTime.unboxToBoolean((Object)this.isNotVanished$1.apply((Object)orderId2))) {
                            return externalOrderName;
                        }
                    }
                }
                return function1.apply((Object)x2);
            }
        })).toSet();
        OrderWatch orderWatch = this.copy$default$1();
        Map<ExternalOrderName, ArisedOrHasOrder> map = this.copy$default$2();
        return this.copy(orderWatch, map, (Set<ExternalOrderName>)set, (Set<ExternalOrderName>)set2);
    }

    public Either<Problem, OrderWatchState> applyOrderWatchEvent(OrderWatchEvent event) {
        OrderWatchEvent orderWatchEvent = event;
        if (orderWatchEvent instanceof OrderWatchEvent.ExternalOrderArised) {
            OrderWatchEvent.ExternalOrderArised externalOrderArised = OrderWatchEvent$ExternalOrderArised$.MODULE$.unapply((OrderWatchEvent.ExternalOrderArised)orderWatchEvent);
            ExternalOrderName externalOrderName = externalOrderArised._1();
            OrderId orderId = externalOrderArised._2();
            Map<String, Value> map = externalOrderArised._3();
            ExternalOrderName externalOrderName2 = externalOrderName;
            OrderId orderId2 = orderId;
            Map<String, Value> arguments = map;
            return this.onExternalOrderArised(externalOrderName2, orderId2, arguments);
        }
        if (orderWatchEvent instanceof OrderWatchEvent.ExternalOrderVanished) {
            ExternalOrderName externalOrderName;
            OrderWatchEvent.ExternalOrderVanished externalOrderVanished = OrderWatchEvent$ExternalOrderVanished$.MODULE$.unapply((OrderWatchEvent.ExternalOrderVanished)orderWatchEvent);
            ExternalOrderName externalOrderName3 = externalOrderName = externalOrderVanished._1();
            return this.onExternalOrderVanished(externalOrderName3);
        }
        throw new MatchError((Object)orderWatchEvent);
    }

    private Either<Problem, OrderWatchState> onExternalOrderArised(ExternalOrderName externalOrderName, OrderId orderId, Map<String, Value> arguments) {
        Option option;
        block6: {
            ArisedOrHasOrder arisedOrHasOrder;
            block8: {
                block7: {
                    option = this.externalToState().get((Object)externalOrderName);
                    if (None$.MODULE$.equals(option)) {
                        Map map = (Map)this.externalToState().updated((Object)externalOrderName, (Object)OrderWatchState$Arised$.MODULE$.apply(orderId, arguments));
                        Set set = (Set)this.orderAddedQueue().$plus((Object)externalOrderName);
                        OrderWatch orderWatch = this.copy$default$1();
                        Set<ExternalOrderName> set2 = this.copy$default$4();
                        return package$.MODULE$.Right().apply((Object)this.copy(orderWatch, (Map<ExternalOrderName, ArisedOrHasOrder>)map, (Set<ExternalOrderName>)set, set2));
                    }
                    if (!(option instanceof Some)) break block6;
                    arisedOrHasOrder = (ArisedOrHasOrder)((Some)option).value();
                    if (arisedOrHasOrder instanceof HasOrder) {
                        HasOrder hasOrder = OrderWatchState$HasOrder$.MODULE$.unapply((HasOrder)arisedOrHasOrder);
                        OrderId orderId2 = hasOrder._1();
                        Option<VanishedOrArised> option2 = hasOrder._2();
                        OrderId orderId3 = orderId2;
                        if (option2 instanceof Some && OrderWatchState$Vanished$.MODULE$.equals(((Some)option2).value())) {
                            Map map = (Map)this.externalToState().updated((Object)externalOrderName, (Object)OrderWatchState$HasOrder$.MODULE$.apply(orderId3, (Option<VanishedOrArised>)Some$.MODULE$.apply((Object)OrderWatchState$Arised$.MODULE$.apply(orderId3, arguments))));
                            OrderWatch orderWatch = this.copy$default$1();
                            Set<ExternalOrderName> set = this.copy$default$3();
                            Set<ExternalOrderName> set3 = this.copy$default$4();
                            return package$.MODULE$.Right().apply((Object)this.copy(orderWatch, (Map<ExternalOrderName, ArisedOrHasOrder>)map, set, set3));
                        }
                    }
                    if (!(arisedOrHasOrder instanceof Arised)) break block7;
                    Arised arised = OrderWatchState$Arised$.MODULE$.unapply((Arised)arisedOrHasOrder);
                    OrderId orderId4 = arised._1();
                    Map<String, Value> map = arised._2();
                    break block8;
                }
                if (!(arisedOrHasOrder instanceof HasOrder)) break block6;
                HasOrder hasOrder = OrderWatchState$HasOrder$.MODULE$.unapply((HasOrder)arisedOrHasOrder);
                OrderId orderId5 = hasOrder._1();
                Option<VanishedOrArised> option3 = hasOrder._2();
                if (None$.MODULE$.equals(option3)) break block8;
                if (!(option3 instanceof Some) || !(((Some)option3).value() instanceof Arised)) break block6;
                Arised arised = OrderWatchState$Arised$.MODULE$.unapply((Arised)((Some)option3).value());
                OrderId orderId6 = arised._1();
                Map<String, Value> map = arised._2();
            }
            Serializable state = (Serializable)((Object)arisedOrHasOrder);
            return this.unexpected("Duplicate ExternalOrderArised(" + externalOrderName + ", " + arguments + "): " + state);
        }
        throw new MatchError((Object)option);
    }

    private Either<Problem, OrderWatchState> onExternalOrderVanished(ExternalOrderName externalOrderName) {
        Option option = this.externalToState().get((Object)externalOrderName);
        if (None$.MODULE$.equals(option)) {
            return this.unexpected(this.orderWatch().path() + ": Ignored ExternalOrderVanished(" + externalOrderName + ") event for unknown name");
        }
        if (option instanceof Some) {
            ArisedOrHasOrder arisedOrHasOrder = (ArisedOrHasOrder)((Some)option).value();
            if (arisedOrHasOrder instanceof Arised) {
                Arised arised = OrderWatchState$Arised$.MODULE$.unapply((Arised)arisedOrHasOrder);
                OrderId orderId = arised._1();
                Map<String, Value> map = arised._2();
                Map map2 = (Map)this.externalToState().$minus((Object)externalOrderName);
                Set set = (Set)this.orderAddedQueue().$minus((Object)externalOrderName);
                OrderWatch orderWatch = this.copy$default$1();
                Set<ExternalOrderName> set2 = this.copy$default$4();
                return package$.MODULE$.Right().apply((Object)this.copy(orderWatch, (Map<ExternalOrderName, ArisedOrHasOrder>)map2, (Set<ExternalOrderName>)set, set2));
            }
            if (arisedOrHasOrder instanceof HasOrder) {
                HasOrder hasOrder = (HasOrder)arisedOrHasOrder;
                HasOrder hasOrder2 = OrderWatchState$HasOrder$.MODULE$.unapply(hasOrder);
                OrderId orderId = hasOrder2._1();
                Option<VanishedOrArised> option2 = hasOrder2._2();
                OrderId orderId2 = orderId;
                if (None$.MODULE$.equals(option2)) {
                    Map map = (Map)this.externalToState().updated((Object)externalOrderName, (Object)OrderWatchState$HasOrder$.MODULE$.apply(orderId2, (Option<VanishedOrArised>)Some$.MODULE$.apply((Object)OrderWatchState$Vanished$.MODULE$)));
                    Set set = (Set)this.orderExternalVanishedQueue().$plus((Object)externalOrderName);
                    OrderWatch orderWatch = this.copy$default$1();
                    Set<ExternalOrderName> set3 = this.copy$default$3();
                    return package$.MODULE$.Right().apply((Object)this.copy(orderWatch, (Map<ExternalOrderName, ArisedOrHasOrder>)map, set3, (Set<ExternalOrderName>)set));
                }
                OrderId orderId3 = orderId;
                if (option2 instanceof Some) {
                    VanishedOrArised vanishedOrArised = (VanishedOrArised)((Some)option2).value();
                    if (vanishedOrArised instanceof Arised) {
                        Arised arised = OrderWatchState$Arised$.MODULE$.unapply((Arised)vanishedOrArised);
                        OrderId orderId4 = arised._1();
                        Map<String, Value> map = arised._2();
                        Map map3 = (Map)this.externalToState().updated((Object)externalOrderName, (Object)OrderWatchState$HasOrder$.MODULE$.apply(orderId3, (Option<VanishedOrArised>)Some$.MODULE$.apply((Object)OrderWatchState$Vanished$.MODULE$)));
                        OrderWatch orderWatch = this.copy$default$1();
                        Set<ExternalOrderName> set = this.copy$default$3();
                        Set<ExternalOrderName> set4 = this.copy$default$4();
                        return package$.MODULE$.Right().apply((Object)this.copy(orderWatch, (Map<ExternalOrderName, ArisedOrHasOrder>)map3, set, set4));
                    }
                    if (OrderWatchState$Vanished$.MODULE$.equals(vanishedOrArised)) {
                        HasOrder state = hasOrder;
                        return this.unexpected("Duplicate ExternalOrderVanished(" + externalOrderName + "), state=" + state);
                    }
                }
            }
        }
        throw new MatchError((Object)option);
    }

    public Either<Problem, OrderWatchState> onOrderAdded(ExternalOrderName externalOrderName, OrderId orderId) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.externalToState());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, externalOrderName, Tag$.MODULE$.apply(ExternalOrderName.class, LightTypeTag$.MODULE$.parse(1276513850, "\u0004\u0000\u0001%js7.data.orderwatch.ExternalOrderName\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001%js7.data.orderwatch.ExternalOrderName\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))).flatMap((Function1 & Serializable)x$1 -> {
            ArisedOrHasOrder arisedOrHasOrder = x$1;
            if (arisedOrHasOrder instanceof Arised) {
                Arised arised = OrderWatchState$Arised$.MODULE$.unapply((Arised)arisedOrHasOrder);
                OrderId orderId = arised._1();
                Map<String, Value> map = arised._2();
                OrderId orderId2 = orderId;
                OrderId orderId3 = orderId;
                if (!(orderId2 != null ? !((Object)orderId2).equals(orderId3) : orderId3 != null)) {
                    Map map2 = (Map)this.externalToState().updated((Object)externalOrderName, (Object)OrderWatchState$HasOrder$.MODULE$.apply(orderId, OrderWatchState$HasOrder$.MODULE$.$lessinit$greater$default$2()));
                    Set set = (Set)this.orderAddedQueue().$minus((Object)externalOrderName);
                    OrderWatch orderWatch = this.copy$default$1();
                    Set<ExternalOrderName> set2 = this.copy$default$4();
                    return package$.MODULE$.Right().apply((Object)this.copy(orderWatch, (Map<ExternalOrderName, ArisedOrHasOrder>)map2, (Set<ExternalOrderName>)set, set2));
                }
            }
            return this.unexpected(orderId + " <-: OrderAdded(" + externalOrderName + ") but not Arised(" + orderId + ")");
        });
    }

    public Either<Problem, OrderWatchState> onOrderExternalVanished(ExternalOrderName externalOrderName) {
        Set set = (Set)this.orderExternalVanishedQueue().$minus((Object)externalOrderName);
        OrderWatch orderWatch = this.copy$default$1();
        Map<ExternalOrderName, ArisedOrHasOrder> map = this.copy$default$2();
        Set<ExternalOrderName> set2 = this.copy$default$3();
        return package$.MODULE$.Right().apply((Object)this.copy(orderWatch, map, set2, (Set<ExternalOrderName>)set));
    }

    public Either<Problem, OrderWatchState> onOrderDeleted(ExternalOrderName externalOrderName, OrderId orderId) {
        Option option;
        block10: {
            block9: {
                block8: {
                    ArisedOrHasOrder arisedOrHasOrder;
                    option = this.externalToState().get((Object)externalOrderName);
                    if (!(option instanceof Some) || !((arisedOrHasOrder = (ArisedOrHasOrder)((Some)option).value()) instanceof HasOrder)) break block8;
                    HasOrder hasOrder = OrderWatchState$HasOrder$.MODULE$.unapply((HasOrder)arisedOrHasOrder);
                    OrderId orderId2 = hasOrder._1();
                    Option<VanishedOrArised> option2 = hasOrder._2();
                    OrderId orderId3 = orderId;
                    OrderId orderId4 = orderId2;
                    if (orderId3 != null ? !((Object)orderId3).equals(orderId4) : orderId4 != null) break block8;
                    if (None$.MODULE$.equals(option2) || option2 instanceof Some && OrderWatchState$Vanished$.MODULE$.equals(((Some)option2).value())) break block9;
                }
                if (!None$.MODULE$.equals(option)) break block10;
            }
            Map map = (Map)this.externalToState().$minus((Object)externalOrderName);
            Set set = (Set)this.orderExternalVanishedQueue().$minus((Object)externalOrderName);
            OrderWatch orderWatch = this.copy$default$1();
            Set<ExternalOrderName> set2 = this.copy$default$3();
            return package$.MODULE$.Right().apply((Object)this.copy(orderWatch, (Map<ExternalOrderName, ArisedOrHasOrder>)map, set2, (Set<ExternalOrderName>)set));
        }
        if (option instanceof Some) {
            ArisedOrHasOrder arisedOrHasOrder = (ArisedOrHasOrder)((Some)option).value();
            if (arisedOrHasOrder instanceof HasOrder) {
                HasOrder hasOrder = OrderWatchState$HasOrder$.MODULE$.unapply((HasOrder)arisedOrHasOrder);
                OrderId orderId5 = hasOrder._1();
                Option<VanishedOrArised> option3 = hasOrder._2();
                OrderId orderId6 = orderId;
                OrderId orderId7 = orderId5;
                if (!(orderId6 != null ? !((Object)orderId6).equals(orderId7) : orderId7 != null)) {
                    VanishedOrArised vanishedOrArised;
                    if (option3 instanceof Some && (vanishedOrArised = (VanishedOrArised)((Some)option3).value()) instanceof Arised) {
                        Arised queued = (Arised)vanishedOrArised;
                        Map map = (Map)this.externalToState().updated((Object)externalOrderName, (Object)queued);
                        Set set = (Set)this.orderExternalVanishedQueue().$minus((Object)externalOrderName);
                        Set set3 = (Set)this.orderAddedQueue().$plus((Object)externalOrderName);
                        OrderWatch orderWatch = this.copy$default$1();
                        return package$.MODULE$.Right().apply((Object)this.copy(orderWatch, (Map<ExternalOrderName, ArisedOrHasOrder>)map, (Set<ExternalOrderName>)set3, (Set<ExternalOrderName>)set));
                    }
                }
            }
            if (arisedOrHasOrder instanceof Arised) {
                Arised arised = OrderWatchState$Arised$.MODULE$.unapply((Arised)arisedOrHasOrder);
                OrderId orderId8 = arised._1();
                Map<String, Value> map = arised._2();
                Set set = (Set)this.orderExternalVanishedQueue().$minus((Object)externalOrderName);
                Set set4 = (Set)this.orderAddedQueue().$plus((Object)externalOrderName);
                OrderWatch orderWatch = this.copy$default$1();
                Map<ExternalOrderName, ArisedOrHasOrder> map2 = this.copy$default$2();
                return package$.MODULE$.Right().apply((Object)this.copy(orderWatch, map2, (Set<ExternalOrderName>)set4, (Set<ExternalOrderName>)set));
            }
            ArisedOrHasOrder x2 = arisedOrHasOrder;
            return this.unexpected(this.orderWatch().path() + ": unexpected " + orderId + " <-: OrderDeleted for " + x2);
        }
        throw new MatchError((Object)option);
    }

    public View<KeyedEvent<Serializable>> nextEvents(Function2<FreshOrder, Option<ExternalOrderKey>, Either<Problem, Either<Order<Order.State>, KeyedEvent<OrderEvent.OrderAdded>>>> toOrderAdded) {
        return (View)this.nextOrderExternalVanishedEvents().$plus$plus(this.nextOrderAddedEvents(toOrderAdded));
    }

    private View<KeyedEvent<OrderEvent.OrderAdded>> nextOrderAddedEvents(Function2<FreshOrder, Option<ExternalOrderKey>, Either<Problem, Either<Order<Order.State>, KeyedEvent<OrderEvent.OrderAdded>>>> toOrderAdded) {
        return (View)this.orderAddedQueue().view().flatMap((Function1 & Serializable)externalOrderName -> this.externalToState().get(externalOrderName).flatMap((Function1 & Serializable)arised -> {
            ArisedOrHasOrder arisedOrHasOrder = arised;
            if (!(arisedOrHasOrder instanceof Arised)) {
                throw new MatchError((Object)arisedOrHasOrder);
            }
            Arised arised2 = OrderWatchState$Arised$.MODULE$.unapply((Arised)arisedOrHasOrder);
            OrderId orderId = arised2._1();
            Map<String, Value> map = arised2._2();
            OrderId orderId2 = orderId;
            Map<String, Value> arguments = map;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)orderId2, arguments);
            OrderId orderId3 = (OrderId)tuple2._1();
            Map arguments2 = (Map)tuple2._2();
            FreshOrder freshOrder = FreshOrder$.MODULE$.apply(orderId3, this.orderWatch().workflowPath(), (Map<String, Value>)arguments2, FreshOrder$.MODULE$.apply$default$4(), FreshOrder$.MODULE$.apply$default$5(), FreshOrder$.MODULE$.apply$default$6(), FreshOrder$.MODULE$.apply$default$7(), FreshOrder$.MODULE$.apply$default$8(), FreshOrder$.MODULE$.apply$default$9());
            ExternalOrderKey externalOrderKey = ExternalOrderKey$.MODULE$.apply(this.id(), (ExternalOrderName)externalOrderName);
            Either either = (Either)toOrderAdded.apply((Object)freshOrder, (Object)Some$.MODULE$.apply((Object)externalOrderKey));
            if (either instanceof Left) {
                Problem problem = (Problem)((Left)either).value();
                Logger LoggerImpl_this = OrderWatchState$.js7$data$orderwatch$OrderWatchState$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error("{}: {}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.orderWatch().path(), externalOrderKey, problem}), Object.class));
                }
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                Either either2 = (Either)((Right)either).value();
                if (either2 instanceof Left) {
                    Logger LoggerImpl_this;
                    Order existingOrder = (Order)((Left)either2).value();
                    boolean vanished = existingOrder.externalOrder().filter((Function1 & Serializable)_$1 -> {
                        ExternalOrderKey externalOrderKey = _$1.externalOrderKey();
                        ExternalOrderKey externalOrderKey2 = externalOrderKey;
                        return !(externalOrderKey != null ? !((Object)externalOrderKey).equals(externalOrderKey2) : externalOrderKey2 != null);
                    }).exists((Function1 & Serializable)_$2 -> _$2.vanished());
                    if (!vanished && (LoggerImpl_this = OrderWatchState$.js7$data$orderwatch$OrderWatchState$$$logger).underlying().isErrorEnabled()) {
                        LoggerImpl_this.underlying().error("{}: {} already exists{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.orderWatch().path(), freshOrder.id(), existingOrder.externalOrder().fold(OrderWatchState::nextOrderAddedEvents$$anonfun$1$$anonfun$1$$anonfun$1, (Function1 & Serializable)o -> " and is linked to " + o)}), Object.class));
                    }
                    return None$.MODULE$;
                }
                if (either2 instanceof Right) {
                    KeyedEvent added = (KeyedEvent)((Right)either2).value();
                    return Some$.MODULE$.apply((Object)added);
                }
            }
            throw new MatchError((Object)either);
        }));
    }

    private View<KeyedEvent<OrderEvent$OrderExternalVanished$>> nextOrderExternalVanishedEvents() {
        return (View)this.orderExternalVanishedQueue().view().flatMap((Function1 & Serializable)externalOrderName -> this.externalToState().get(externalOrderName).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(ArisedOrHasOrder x2) {
                ArisedOrHasOrder arisedOrHasOrder = x2;
                if (arisedOrHasOrder instanceof HasOrder) {
                    HasOrder hasOrder = OrderWatchState$HasOrder$.MODULE$.unapply((HasOrder)arisedOrHasOrder);
                    OrderId orderId = hasOrder._1();
                    Option<VanishedOrArised> option = hasOrder._2();
                    OrderId orderId2 = orderId;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(ArisedOrHasOrder x2, Function1 function1) {
                ArisedOrHasOrder arisedOrHasOrder = x2;
                if (arisedOrHasOrder instanceof HasOrder) {
                    HasOrder hasOrder = OrderWatchState$HasOrder$.MODULE$.unapply((HasOrder)arisedOrHasOrder);
                    OrderId orderId = hasOrder._1();
                    Option<VanishedOrArised> option = hasOrder._2();
                    OrderId orderId2 = orderId;
                    return OrderEvent$OrderExternalVanished$.MODULE$.toKeyedEvent(orderId2);
                }
                return function1.apply((Object)x2);
            }
        }));
    }

    public int estimatedSnapshotSize() {
        return 1 + this.externalToState().size();
    }

    @Override
    public Stream<IO, Object> toSnapshotStream() {
        UnsignedSimpleItemEvent.UnsignedSimpleItemAdded unsignedSimpleItemAdded = UnsignedSimpleItemEvent$UnsignedSimpleItemAdded$.MODULE$.apply(this.orderWatch());
        return StreamExtensions$.MODULE$.$plus$colon(Stream$.MODULE$.iterable(this.externalToState()).map((Function1 & Serializable)x$1 -> {
            ExternalOrderName externalOrderName = (ExternalOrderName)x$1._1();
            ArisedOrHasOrder arisedOrHasOrder = (ArisedOrHasOrder)x$1._2();
            return OrderWatchState$ExternalOrderSnapshot$.MODULE$.apply((OrderWatchPath)this.orderWatch().key(), externalOrderName, arisedOrHasOrder);
        }), unsignedSimpleItemAdded);
    }

    public Either<Problem, OrderWatchState> applySnapshot(ExternalOrderSnapshot snapshot) {
        Map map = Collections$.MODULE$.RichMap(this.externalToState());
        ExternalOrderName externalOrderName = (ExternalOrderName)Predef$.MODULE$.ArrowAssoc((Object)snapshot.externalOrderName());
        return Collections$RichMap$.MODULE$.insert$extension(map, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)externalOrderName, (Object)snapshot.state())).map((Function1 & Serializable)o -> this.copy(this.copy$default$1(), (Map<ExternalOrderName, ArisedOrHasOrder>)o, this.copy$default$3(), this.copy$default$4()));
    }

    private Either<Problem, OrderWatchState> unexpected(String msg) {
        block1: {
            if (Tests$.MODULE$.isStrict()) {
                return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> OrderWatchState.unexpected$$anonfun$1(msg)), Problem$.MODULE$.apply$default$2()));
            }
            Logger LoggerImpl_this = OrderWatchState$.js7$data$orderwatch$OrderWatchState$$$logger;
            if (!LoggerImpl_this.underlying().isErrorEnabled()) break block1;
            LoggerImpl_this.underlying().error(msg);
        }
        return package$.MODULE$.Right().apply((Object)this);
    }

    public String toString() {
        return "OrderWatchState(" + this.orderWatch().path() + " " + this.externalToState() + " orderAddedQueue=" + this.orderAddedQueue().mkString("{", " ", "}") + " orderExternalVanishedQueue=" + this.orderExternalVanishedQueue().mkString("{", " ", "}") + ")";
    }

    public OrderWatchState copy(OrderWatch orderWatch, Map<ExternalOrderName, ArisedOrHasOrder> externalToState, Set<ExternalOrderName> orderAddedQueue, Set<ExternalOrderName> orderExternalVanishedQueue) {
        return new OrderWatchState(orderWatch, externalToState, orderAddedQueue, orderExternalVanishedQueue);
    }

    public OrderWatch copy$default$1() {
        return this.orderWatch();
    }

    public Map<ExternalOrderName, ArisedOrHasOrder> copy$default$2() {
        return this.externalToState();
    }

    public Set<ExternalOrderName> copy$default$3() {
        return this.orderAddedQueue();
    }

    public Set<ExternalOrderName> copy$default$4() {
        return this.orderExternalVanishedQueue();
    }

    public OrderWatch _1() {
        return this.orderWatch();
    }

    public Map<ExternalOrderName, ArisedOrHasOrder> _2() {
        return this.externalToState();
    }

    public Set<ExternalOrderName> _3() {
        return this.orderAddedQueue();
    }

    public Set<ExternalOrderName> _4() {
        return this.orderExternalVanishedQueue();
    }

    private static final String nextOrderAddedEvents$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final String unexpected$$anonfun$1(String msg$1) {
        return msg$1;
    }

    public static final class Arised
    implements ArisedOrHasOrder,
    VanishedOrArised,
    Product,
    Serializable {
        private final OrderId orderId;
        private final Map arguments;

        public static Arised apply(OrderId orderId, Map<String, Value> map) {
            return OrderWatchState$Arised$.MODULE$.apply(orderId, map);
        }

        public static Arised fromProduct(Product product) {
            return OrderWatchState$Arised$.MODULE$.fromProduct(product);
        }

        public static Arised unapply(Arised arised) {
            return OrderWatchState$Arised$.MODULE$.unapply(arised);
        }

        public Arised(OrderId orderId, Map<String, Value> arguments) {
            this.orderId = orderId;
            this.arguments = arguments;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Arised)) return false;
            Arised arised = (Arised)object;
            OrderId orderId = this.orderId();
            OrderId orderId2 = arised.orderId();
            if (orderId == null) {
                if (orderId2 != null) {
                    return false;
                }
            } else if (!((Object)orderId).equals(orderId2)) return false;
            Map<String, Value> map = this.arguments();
            Map<String, Value> map2 = arised.arguments();
            if (map == null) {
                if (map2 == null) return true;
                return false;
            } else {
                if (!map.equals(map2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Arised;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Arised";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderId";
            }
            if (1 == n2) {
                return "arguments";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public OrderId orderId() {
            return this.orderId;
        }

        public Map<String, Value> arguments() {
            return this.arguments;
        }

        public String toString() {
            return "Arised(" + this.orderId() + ")";
        }

        public Arised copy(OrderId orderId, Map<String, Value> arguments) {
            return new Arised(orderId, arguments);
        }

        public OrderId copy$default$1() {
            return this.orderId();
        }

        public Map<String, Value> copy$default$2() {
            return this.arguments();
        }

        public OrderId _1() {
            return this.orderId();
        }

        public Map<String, Value> _2() {
            return this.arguments();
        }
    }

    public static interface ArisedOrHasOrder {
        public static TypedJsonCodec<ArisedOrHasOrder> jsonCodec() {
            return OrderWatchState$ArisedOrHasOrder$.MODULE$.jsonCodec();
        }

        public static int ordinal(ArisedOrHasOrder arisedOrHasOrder) {
            return OrderWatchState$ArisedOrHasOrder$.MODULE$.ordinal(arisedOrHasOrder);
        }
    }

    public static final class ExternalOrderSnapshot
    implements Snapshot,
    Product,
    Serializable {
        private final OrderWatchPath orderWatchPath;
        private final ExternalOrderName externalOrderName;
        private final ArisedOrHasOrder state;

        public static ExternalOrderSnapshot apply(OrderWatchPath orderWatchPath, ExternalOrderName externalOrderName, ArisedOrHasOrder arisedOrHasOrder) {
            return OrderWatchState$ExternalOrderSnapshot$.MODULE$.apply(orderWatchPath, externalOrderName, arisedOrHasOrder);
        }

        public static ExternalOrderSnapshot fromProduct(Product product) {
            return OrderWatchState$ExternalOrderSnapshot$.MODULE$.fromProduct(product);
        }

        public static ExternalOrderSnapshot unapply(ExternalOrderSnapshot externalOrderSnapshot) {
            return OrderWatchState$ExternalOrderSnapshot$.MODULE$.unapply(externalOrderSnapshot);
        }

        public ExternalOrderSnapshot(OrderWatchPath orderWatchPath, ExternalOrderName externalOrderName, ArisedOrHasOrder state) {
            this.orderWatchPath = orderWatchPath;
            this.externalOrderName = externalOrderName;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExternalOrderSnapshot)) return false;
            ExternalOrderSnapshot externalOrderSnapshot = (ExternalOrderSnapshot)object;
            OrderWatchPath orderWatchPath = this.orderWatchPath();
            OrderWatchPath orderWatchPath2 = externalOrderSnapshot.orderWatchPath();
            if (orderWatchPath == null) {
                if (orderWatchPath2 != null) {
                    return false;
                }
            } else if (!((Object)orderWatchPath).equals(orderWatchPath2)) return false;
            ExternalOrderName externalOrderName = this.externalOrderName();
            ExternalOrderName externalOrderName2 = externalOrderSnapshot.externalOrderName();
            if (externalOrderName == null) {
                if (externalOrderName2 != null) {
                    return false;
                }
            } else if (!((Object)externalOrderName).equals(externalOrderName2)) return false;
            ArisedOrHasOrder arisedOrHasOrder = this.state();
            ArisedOrHasOrder arisedOrHasOrder2 = externalOrderSnapshot.state();
            if (arisedOrHasOrder == null) {
                if (arisedOrHasOrder2 == null) return true;
                return false;
            } else {
                if (!arisedOrHasOrder.equals(arisedOrHasOrder2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExternalOrderSnapshot;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ExternalOrderSnapshot";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "orderWatchPath";
                }
                case 1: {
                    return "externalOrderName";
                }
                case 2: {
                    return "state";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public OrderWatchPath orderWatchPath() {
            return this.orderWatchPath;
        }

        public ExternalOrderName externalOrderName() {
            return this.externalOrderName;
        }

        public ArisedOrHasOrder state() {
            return this.state;
        }

        public ExternalOrderSnapshot copy(OrderWatchPath orderWatchPath, ExternalOrderName externalOrderName, ArisedOrHasOrder state) {
            return new ExternalOrderSnapshot(orderWatchPath, externalOrderName, state);
        }

        public OrderWatchPath copy$default$1() {
            return this.orderWatchPath();
        }

        public ExternalOrderName copy$default$2() {
            return this.externalOrderName();
        }

        public ArisedOrHasOrder copy$default$3() {
            return this.state();
        }

        public OrderWatchPath _1() {
            return this.orderWatchPath();
        }

        public ExternalOrderName _2() {
            return this.externalOrderName();
        }

        public ArisedOrHasOrder _3() {
            return this.state();
        }
    }

    public static final class HasOrder
    implements ArisedOrHasOrder,
    Product,
    Serializable {
        private final OrderId orderId;
        private final Option queued;

        public static HasOrder apply(OrderId orderId, Option<VanishedOrArised> option) {
            return OrderWatchState$HasOrder$.MODULE$.apply(orderId, option);
        }

        public static HasOrder fromProduct(Product product) {
            return OrderWatchState$HasOrder$.MODULE$.fromProduct(product);
        }

        public static HasOrder unapply(HasOrder hasOrder) {
            return OrderWatchState$HasOrder$.MODULE$.unapply(hasOrder);
        }

        public static Option<VanishedOrArised> $lessinit$greater$default$2() {
            return OrderWatchState$HasOrder$.MODULE$.$lessinit$greater$default$2();
        }

        public HasOrder(OrderId orderId, Option<VanishedOrArised> queued) {
            this.orderId = orderId;
            this.queued = queued;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HasOrder)) return false;
            HasOrder hasOrder = (HasOrder)object;
            OrderId orderId = this.orderId();
            OrderId orderId2 = hasOrder.orderId();
            if (orderId == null) {
                if (orderId2 != null) {
                    return false;
                }
            } else if (!((Object)orderId).equals(orderId2)) return false;
            Option<VanishedOrArised> option = this.queued();
            Option<VanishedOrArised> option2 = hasOrder.queued();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HasOrder;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "HasOrder";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderId";
            }
            if (1 == n2) {
                return "queued";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public OrderId orderId() {
            return this.orderId;
        }

        public Option<VanishedOrArised> queued() {
            return this.queued;
        }

        public HasOrder copy(OrderId orderId, Option<VanishedOrArised> queued) {
            return new HasOrder(orderId, queued);
        }

        public OrderId copy$default$1() {
            return this.orderId();
        }

        public Option<VanishedOrArised> copy$default$2() {
            return this.queued();
        }

        public OrderId _1() {
            return this.orderId();
        }

        public Option<VanishedOrArised> _2() {
            return this.queued();
        }
    }

    public static final class HeaderSnapshot
    implements Snapshot,
    Product,
    Serializable {
        private final OrderWatch orderWatch;

        public static HeaderSnapshot apply(OrderWatch orderWatch) {
            return OrderWatchState$HeaderSnapshot$.MODULE$.apply(orderWatch);
        }

        public static HeaderSnapshot fromProduct(Product product) {
            return OrderWatchState$HeaderSnapshot$.MODULE$.fromProduct(product);
        }

        public static HeaderSnapshot unapply(HeaderSnapshot headerSnapshot) {
            return OrderWatchState$HeaderSnapshot$.MODULE$.unapply(headerSnapshot);
        }

        public HeaderSnapshot(OrderWatch orderWatch) {
            this.orderWatch = orderWatch;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HeaderSnapshot)) return false;
            HeaderSnapshot headerSnapshot = (HeaderSnapshot)object;
            OrderWatch orderWatch = this.orderWatch();
            OrderWatch orderWatch2 = headerSnapshot.orderWatch();
            if (orderWatch != null) {
                if (!orderWatch.equals(orderWatch2)) return false;
                return true;
            }
            if (orderWatch2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HeaderSnapshot;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "HeaderSnapshot";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderWatch";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public OrderWatch orderWatch() {
            return this.orderWatch;
        }

        @Override
        public OrderWatchPath orderWatchPath() {
            return (OrderWatchPath)this.orderWatch().key();
        }

        public HeaderSnapshot copy(OrderWatch orderWatch) {
            return new HeaderSnapshot(orderWatch);
        }

        public OrderWatch copy$default$1() {
            return this.orderWatch();
        }

        public OrderWatch _1() {
            return this.orderWatch();
        }
    }

    public static interface Snapshot {
        public static TypedJsonCodec<Snapshot> jsonCodec() {
            return OrderWatchState$Snapshot$.MODULE$.jsonCodec();
        }

        public static int ordinal(Snapshot snapshot) {
            return OrderWatchState$Snapshot$.MODULE$.ordinal(snapshot);
        }

        public OrderWatchPath orderWatchPath();
    }

    public static interface VanishedOrArised {
        public static TypedJsonCodec<VanishedOrArised> jsonCodec() {
            return OrderWatchState$VanishedOrArised$.MODULE$.jsonCodec();
        }

        public static int ordinal(VanishedOrArised vanishedOrArised) {
            return OrderWatchState$VanishedOrArised$.MODULE$.ordinal(vanishedOrArised);
        }
    }
}

