/*
 * Decompiled with CFR 0.152.
 */
package js7.data.value;

import cats.Applicative;
import cats.Invariant$;
import cats.Traverse;
import cats.instances.package;
import cats.syntax.package;
import io.circe.Decoder;
import io.circe.DecodingFailure$;
import io.circe.Encoder;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import java.io.Serializable;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.data.value.BooleanValue;
import js7.data.value.BooleanValue$;
import js7.data.value.FunctionValue;
import js7.data.value.GoodValue;
import js7.data.value.ListValue;
import js7.data.value.ListValue$;
import js7.data.value.NumberValue;
import js7.data.value.NumberValue$;
import js7.data.value.ObjectValue;
import js7.data.value.ObjectValue$;
import js7.data.value.StringValue;
import js7.data.value.StringValue$;
import js7.data.value.Value;
import js7.data.value.Value$convenience$;
import js7.data.value.Value$package$MissingValue$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.deriving.Mirror;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Right;

public final class Value$
implements Mirror.Sum,
Serializable {
    private static final Encoder jsonEncoder;
    private static final Decoder jsonDecoder;
    public static final Value$convenience$ convenience;
    public static final Value$ MODULE$;

    private Value$() {
    }

    static {
        MODULE$ = new Value$();
        jsonEncoder = (Encoder & Serializable)x$1 -> {
            Value value = x$1;
            if (value instanceof StringValue) {
                String string;
                StringValue stringValue = StringValue$.MODULE$.unapply((StringValue)value);
                String o = string = stringValue._1();
                return Json$.MODULE$.fromString(o);
            }
            if (value instanceof NumberValue) {
                BigDecimal bigDecimal;
                BigDecimal n;
                NumberValue numberValue = NumberValue$.MODULE$.unapply((NumberValue)value);
                BigDecimal bigDecimal2 = n = (bigDecimal = numberValue._1());
                if (BoxesRunTime.equals((Object)NumberValue$.MODULE$.Zero().number(), (Object)bigDecimal2)) {
                    return NumberValue$.MODULE$.ZeroJson();
                }
                if (BoxesRunTime.equals((Object)NumberValue$.MODULE$.One().number(), (Object)bigDecimal2)) {
                    return NumberValue$.MODULE$.OneJson();
                }
                BigDecimal o = bigDecimal2;
                return Json$.MODULE$.fromBigDecimal(o);
            }
            if (value instanceof BooleanValue) {
                boolean bl;
                BooleanValue booleanValue = BooleanValue$.MODULE$.unapply((BooleanValue)value);
                boolean o = bl = booleanValue._1();
                return Json$.MODULE$.fromBoolean(o);
            }
            if (value instanceof ListValue) {
                Vector<Value> vector;
                ListValue listValue = ListValue$.MODULE$.unapply((ListValue)value);
                Vector<Value> values = vector = listValue._1();
                return Json$.MODULE$.fromValues((Iterable)values.map((Function1 & Serializable)a -> this.jsonEncoder().apply(a)));
            }
            if (value instanceof ObjectValue) {
                Map<String, Value> map;
                ObjectValue objectValue = ObjectValue$.MODULE$.unapply((ObjectValue)value);
                Map<String, Value> values = map = objectValue._1();
                return Json$.MODULE$.fromJsonObject(JsonObject$.MODULE$.fromIterable((Iterable)values.view().mapValues((Function1 & Serializable)a -> this.jsonEncoder().apply(a))));
            }
            if (Value$package$MissingValue$.MODULE$.equals(value)) {
                return Json$.MODULE$.Null();
            }
            if (value instanceof FunctionValue) {
                FunctionValue v = (FunctionValue)value;
                throw scala.sys.package$.MODULE$.error(v.valueType().name() + " cannot be JSON encoded: " + v);
            }
            throw new MatchError((Object)value);
        };
        Right Zero = package$.MODULE$.Right().apply((Object)NumberValue$.MODULE$.Zero());
        Right One2 = package$.MODULE$.Right().apply((Object)NumberValue$.MODULE$.One());
        Right False = package$.MODULE$.Right().apply((Object)BooleanValue$.MODULE$.False());
        Right True = package$.MODULE$.Right().apply((Object)BooleanValue$.MODULE$.True());
        jsonDecoder = (Decoder & Serializable)c -> {
            Json j2 = c.value();
            if (j2.isString()) {
                return package$.MODULE$.Right().apply((Object)StringValue$.MODULE$.apply((String)j2.asString().get()));
            }
            if (j2.isNumber()) {
                JsonNumber jsonNumber = (JsonNumber)j2.asNumber().get();
                JsonNumber jsonNumber2 = NumberValue$.MODULE$.ZeroJsonNumber();
                JsonNumber jsonNumber3 = jsonNumber;
                if (!(jsonNumber2 != null ? !jsonNumber2.equals(jsonNumber3) : jsonNumber3 != null)) {
                    return Zero;
                }
                JsonNumber jsonNumber4 = NumberValue$.MODULE$.OneJsonNumber();
                JsonNumber jsonNumber5 = jsonNumber;
                if (!(jsonNumber4 != null ? !jsonNumber4.equals(jsonNumber5) : jsonNumber5 != null)) {
                    return One2;
                }
                JsonNumber number = jsonNumber;
                Option option = number.toBigDecimal();
                if (option instanceof Some) {
                    BigDecimal o2 = (BigDecimal)((Some)option).value();
                    return package$.MODULE$.Right().apply((Object)NumberValue$.MODULE$.apply(o2));
                }
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply("JSON number is not representable as a Java BigDecimal: " + j2, () -> this.$init$$$anonfun$2$$anonfun$1(c)));
                }
                throw new MatchError((Object)option);
            }
            if (j2.isBoolean()) {
                if (BoxesRunTime.unboxToBoolean((Object)j2.asBoolean().get())) {
                    return True;
                }
                return False;
            }
            if (j2.isArray()) {
                return ((Either)package.traverse$.MODULE$.toTraverseOps(j2.asArray().get(), (Traverse)package.vector$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable)j -> this.jsonDecoder().decodeJson(j), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).map((Function1 & Serializable)elements -> ListValue$.MODULE$.apply((Iterable<Value>)elements));
            }
            if (j2.isObject()) {
                return ((Either)package.traverse$.MODULE$.toTraverseOps((Object)((JsonObject)j2.asObject().get()).toVector(), (Traverse)package.vector$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Json v = (Json)tuple2._2();
                        return this.jsonDecoder().decodeJson(v).map((Function1 & Serializable)_$10 -> {
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$10);
                        });
                    }
                    throw new MatchError((Object)tuple2);
                }, (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).map((Function1 & Serializable)o -> ObjectValue$.MODULE$.apply((Map<String, Value>)o.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            }
            if (j2.isNull()) {
                return package$.MODULE$.Right().apply((Object)Value$package$MissingValue$.MODULE$);
            }
            return package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply("Unknown value JSON type: " + ScalaUtils$syntax$.MODULE$.RichJavaClass(j2.getClass()).shortClassName(), () -> this.$init$$$anonfun$2$$anonfun$6(c)));
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Value$.class);
    }

    public StringValue of(String value) {
        return StringValue$.MODULE$.apply(value);
    }

    public NumberValue of(java.math.BigDecimal value) {
        return NumberValue$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(value));
    }

    public NumberValue of(long value) {
        return NumberValue$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(value));
    }

    public NumberValue of(int value) {
        return NumberValue$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(value));
    }

    public BooleanValue of(boolean value) {
        return BooleanValue$.MODULE$.apply(value);
    }

    public Either<Problem, Value> ofAny(Object value) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> Value$.ofAny$$anonfun$1(value));
    }

    public Encoder<Value> jsonEncoder() {
        return jsonEncoder;
    }

    public Decoder<Value> jsonDecoder() {
        return jsonDecoder;
    }

    public int ordinal(Value x$0) {
        Value value = x$0;
        if (value instanceof GoodValue) {
            return 0;
        }
        if (value == Value$package$MissingValue$.MODULE$) {
            return 1;
        }
        throw new MatchError((Object)value);
    }

    private final List $init$$$anonfun$2$$anonfun$1(HCursor c$1) {
        return c$1.history();
    }

    private final List $init$$$anonfun$2$$anonfun$6(HCursor c$2) {
        return c$2.history();
    }

    private static final String ofAny$$anonfun$1$$anonfun$1() {
        return "Double.PositiveInfinity is an invalid value";
    }

    private static final String ofAny$$anonfun$1$$anonfun$2() {
        return "Double.NegativeInfinity is an invalid value";
    }

    private static final String ofAny$$anonfun$1$$anonfun$3(Throwable t$1) {
        Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
        return ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
    }

    private static final String ofAny$$anonfun$1$$anonfun$4(Object value$2) {
        return "Unknown type for a Value: " + value$2.getClass().getName();
    }

    private static final Either ofAny$$anonfun$1(Object value$1) {
        Object object = value$1;
        if (object instanceof Integer) {
            int v = BoxesRunTime.unboxToInt((Object)object);
            return package$.MODULE$.Right().apply((Object)NumberValue$.MODULE$.apply(BigDecimal$.MODULE$.int2bigDecimal(v)));
        }
        if (object instanceof Long) {
            long v = BoxesRunTime.unboxToLong((Object)object);
            return package$.MODULE$.Right().apply((Object)NumberValue$.MODULE$.apply(BigDecimal$.MODULE$.long2bigDecimal(v)));
        }
        if (object instanceof Double) {
            double v = BoxesRunTime.unboxToDouble((Object)object);
            if (Predef$.MODULE$.double2Double(v).isNaN()) {
                return package$.MODULE$.Right().apply((Object)Value$package$MissingValue$.MODULE$);
            }
            double d = v;
            if (Double.POSITIVE_INFINITY == d) {
                return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)Value$::ofAny$$anonfun$1$$anonfun$1), Problem$.MODULE$.apply$default$2()));
            }
            if (Double.NEGATIVE_INFINITY == d) {
                return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)Value$::ofAny$$anonfun$1$$anonfun$2), Problem$.MODULE$.apply$default$2()));
            }
            if (true) {
                double v2 = d;
                return package$.MODULE$.Right().apply((Object)NumberValue$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(v2)));
            }
            throw new MatchError((Object)BoxesRunTime.boxToDouble((double)d));
        }
        if (object instanceof Boolean) {
            boolean v = BoxesRunTime.unboxToBoolean((Object)object);
            return package$.MODULE$.Right().apply((Object)BooleanValue$.MODULE$.apply(v));
        }
        if (object instanceof Integer) {
            Integer v = (Integer)object;
            return package$.MODULE$.Right().apply((Object)NumberValue$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Integer2int(v))));
        }
        if (object instanceof Long) {
            Long v = (Long)object;
            return package$.MODULE$.Right().apply((Object)NumberValue$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Long2long(v))));
        }
        if (object instanceof Double) {
            Double v = (Double)object;
            return package$.MODULE$.Right().apply((Object)NumberValue$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(Predef$.MODULE$.Double2double(v))));
        }
        if (object instanceof Boolean) {
            Boolean v = (Boolean)object;
            return package$.MODULE$.Right().apply((Object)BooleanValue$.MODULE$.apply(Predef$.MODULE$.Boolean2boolean(v)));
        }
        if (object instanceof String) {
            String v = (String)object;
            return package$.MODULE$.Right().apply((Object)StringValue$.MODULE$.apply(v));
        }
        if (object instanceof Throwable) {
            Throwable t = (Throwable)object;
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> Value$.ofAny$$anonfun$1$$anonfun$3(t)), Problem$.MODULE$.apply$default$2()));
        }
        return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> Value$.ofAny$$anonfun$1$$anonfun$4(value$1)), Problem$.MODULE$.apply$default$2()));
    }
}

