/*
 * Decompiled with CFR 0.152.
 */
package js7.data.workflow.instructions;

import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import js7.base.problem.Problem;
import js7.base.time.Timezone;
import js7.data.agent.AgentPath;
import js7.data.calendar.CalendarPath;
import js7.data.item.VersionedItemId;
import js7.data.job.JobResourcePath;
import js7.data.source.SourcePos;
import js7.data.value.expression.Expression;
import js7.data.workflow.Instruction;
import js7.data.workflow.OrderPreparation;
import js7.data.workflow.Workflow;
import js7.data.workflow.Workflow$;
import js7.data.workflow.WorkflowPath;
import js7.data.workflow.instructions.If;
import js7.data.workflow.instructions.Retry;
import js7.data.workflow.instructions.TryInstruction$;
import js7.data.workflow.instructions.executable.WorkflowJob;
import js7.data.workflow.position.BranchId;
import js7.data.workflow.position.BranchId$;
import js7.data.workflow.position.CatchBranchId$;
import js7.data.workflow.position.Position;
import js7.data.workflow.position.TryBranchId$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

public final class TryInstruction
implements Instruction,
Product,
Serializable {
    private final Workflow tryWorkflow;
    private final Workflow catchWorkflow;
    private final Option retryDelays;
    private final Option maxTries;
    private final Option sourcePos;

    public static Problem MissingRetryProblem() {
        return TryInstruction$.MODULE$.MissingRetryProblem();
    }

    public static TryInstruction apply(Workflow workflow, Workflow workflow2, Option<IndexedSeq<FiniteDuration>> option, Option<Object> option2, Option<SourcePos> option3) {
        return TryInstruction$.MODULE$.apply(workflow, workflow2, option, option2, option3);
    }

    public static TryInstruction fromProduct(Product product) {
        return TryInstruction$.MODULE$.fromProduct(product);
    }

    public static Decoder<TryInstruction> jsonDecoder() {
        return TryInstruction$.MODULE$.jsonDecoder();
    }

    public static Encoder.AsObject<TryInstruction> jsonEncoder() {
        return TryInstruction$.MODULE$.jsonEncoder();
    }

    public static Either<Problem, Object> toRetryIndex(BranchId branchId) {
        return TryInstruction$.MODULE$.toRetryIndex(branchId);
    }

    public static TryInstruction unapply(TryInstruction tryInstruction) {
        return TryInstruction$.MODULE$.unapply(tryInstruction);
    }

    public static Option<IndexedSeq<FiniteDuration>> $lessinit$greater$default$3() {
        return TryInstruction$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Seq<FiniteDuration>> checked$default$3() {
        return TryInstruction$.MODULE$.checked$default$3();
    }

    public static Option<Object> $lessinit$greater$default$4() {
        return TryInstruction$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Object> checked$default$4() {
        return TryInstruction$.MODULE$.checked$default$4();
    }

    public static Option<SourcePos> $lessinit$greater$default$5() {
        return TryInstruction$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<SourcePos> checked$default$5() {
        return TryInstruction$.MODULE$.checked$default$5();
    }

    public TryInstruction(Workflow tryWorkflow, Workflow catchWorkflow, Option<IndexedSeq<FiniteDuration>> retryDelays, Option<Object> maxTries, Option<SourcePos> sourcePos) {
        this.tryWorkflow = tryWorkflow;
        this.catchWorkflow = catchWorkflow;
        this.retryDelays = retryDelays;
        this.maxTries = maxTries;
        this.sourcePos = sourcePos;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TryInstruction)) return false;
        TryInstruction tryInstruction = (TryInstruction)object;
        Workflow workflow = this.tryWorkflow();
        Workflow workflow2 = tryInstruction.tryWorkflow();
        if (workflow == null) {
            if (workflow2 != null) {
                return false;
            }
        } else if (!((Object)workflow).equals(workflow2)) return false;
        Workflow workflow3 = this.catchWorkflow();
        Workflow workflow4 = tryInstruction.catchWorkflow();
        if (workflow3 == null) {
            if (workflow4 != null) {
                return false;
            }
        } else if (!((Object)workflow3).equals(workflow4)) return false;
        Option<IndexedSeq<FiniteDuration>> option = this.retryDelays();
        Option<IndexedSeq<FiniteDuration>> option2 = tryInstruction.retryDelays();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.maxTries();
        Option<Object> option4 = tryInstruction.maxTries();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<SourcePos> option5 = this.sourcePos();
        Option<SourcePos> option6 = tryInstruction.sourcePos();
        if (option5 == null) {
            if (option6 == null) return true;
            return false;
        } else {
            if (!option5.equals(option6)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof TryInstruction;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "TryInstruction";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "tryWorkflow";
            }
            case 1: {
                return "catchWorkflow";
            }
            case 2: {
                return "retryDelays";
            }
            case 3: {
                return "maxTries";
            }
            case 4: {
                return "sourcePos";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Workflow tryWorkflow() {
        return this.tryWorkflow;
    }

    public Workflow catchWorkflow() {
        return this.catchWorkflow;
    }

    public Option<IndexedSeq<FiniteDuration>> retryDelays() {
        return this.retryDelays;
    }

    public Option<Object> maxTries() {
        return this.maxTries;
    }

    @Override
    public Option<SourcePos> sourcePos() {
        return this.sourcePos;
    }

    @Override
    public String instructionName() {
        return "Try";
    }

    public Either<Problem, TryInstruction> checked() {
        if (this.maxTries().exists((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> _$1 < 1)) {
            return package$.MODULE$.Left().apply((Object)TryInstruction$.js7$data$workflow$instructions$TryInstruction$$$InvalidMaxTriesProblem);
        }
        if ((this.retryDelays().isDefined() || this.maxTries().isDefined()) && !TryInstruction$.MODULE$.js7$data$workflow$instructions$TryInstruction$$$containsRetry(this.catchWorkflow())) {
            return package$.MODULE$.Left().apply((Object)TryInstruction$.MODULE$.MissingRetryProblem());
        }
        return package$.MODULE$.Right().apply((Object)this);
    }

    @Override
    public TryInstruction withoutSourcePos() {
        None$ none$ = None$.MODULE$;
        Workflow workflow = this.tryWorkflow().withoutSourcePos();
        Workflow workflow2 = this.catchWorkflow().withoutSourcePos();
        Option<IndexedSeq<FiniteDuration>> option = this.copy$default$3();
        Option<Object> option2 = this.copy$default$4();
        return this.copy(workflow, workflow2, option, option2, (Option<SourcePos>)none$);
    }

    @Override
    public TryInstruction withPositions(Position position) {
        return this.copy(this.tryWorkflow().withPositions(position.$div(BranchId$.MODULE$.Try_())), this.catchWorkflow().withPositions(position.$div(BranchId$.MODULE$.Catch_())), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public TryInstruction adopt(Workflow outer) {
        Some some = Some$.MODULE$.apply((Object)outer);
        VersionedItemId<WorkflowPath> versionedItemId = this.tryWorkflow().copy$default$1();
        IndexedSeq<Instruction.Labeled> indexedSeq = this.tryWorkflow().copy$default$2();
        Map<WorkflowJob.Name, WorkflowJob> map = this.tryWorkflow().copy$default$3();
        OrderPreparation orderPreparation = this.tryWorkflow().copy$default$4();
        Timezone timezone = this.tryWorkflow().copy$default$5();
        Seq<JobResourcePath> seq = this.tryWorkflow().copy$default$6();
        Option<CalendarPath> option = this.tryWorkflow().copy$default$7();
        Option<Map<String, Expression>> option2 = this.tryWorkflow().copy$default$8();
        Option<String> option3 = this.tryWorkflow().copy$default$9();
        Some some2 = Some$.MODULE$.apply((Object)outer);
        VersionedItemId<WorkflowPath> versionedItemId2 = this.catchWorkflow().copy$default$1();
        IndexedSeq<Instruction.Labeled> indexedSeq2 = this.catchWorkflow().copy$default$2();
        Map<WorkflowJob.Name, WorkflowJob> map2 = this.catchWorkflow().copy$default$3();
        OrderPreparation orderPreparation2 = this.catchWorkflow().copy$default$4();
        Timezone timezone2 = this.catchWorkflow().copy$default$5();
        Seq<JobResourcePath> seq2 = this.catchWorkflow().copy$default$6();
        Option<CalendarPath> option4 = this.catchWorkflow().copy$default$7();
        Option<Map<String, Expression>> option5 = this.catchWorkflow().copy$default$8();
        Option<String> option6 = this.catchWorkflow().copy$default$9();
        return this.copy(this.tryWorkflow().copy(versionedItemId, indexedSeq, map, orderPreparation, timezone, seq, option, option2, option3, (Option<Workflow>)some), this.catchWorkflow().copy(versionedItemId2, indexedSeq2, map2, orderPreparation2, timezone2, seq2, option4, option5, option6, (Option<Workflow>)some2), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public Instruction reduceForAgent(AgentPath agentPath, Workflow workflow) {
        return this.copy(this.tryWorkflow().reduceForAgent(agentPath), this.catchWorkflow().reduceForAgent(agentPath), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public TryInstruction withoutBlocks() {
        return this.copy(Workflow$.MODULE$.empty(), Workflow$.MODULE$.empty(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public Either<Problem, Workflow> workflow(BranchId branchId) {
        BranchId branchId2 = branchId;
        if (branchId2 != null) {
            Option<Object> option = TryBranchId$.MODULE$.unapply(branchId2);
            if (!option.isEmpty()) {
                int n = BoxesRunTime.unboxToInt((Object)option.get());
                return package$.MODULE$.Right().apply((Object)this.tryWorkflow());
            }
            Option<Object> option2 = CatchBranchId$.MODULE$.unapply(branchId2);
            if (!option2.isEmpty()) {
                int n = BoxesRunTime.unboxToInt((Object)option2.get());
                return package$.MODULE$.Right().apply((Object)this.catchWorkflow());
            }
        }
        return Instruction.workflow$(this, branchId);
    }

    @Override
    public Seq<Tuple2<BranchId, Workflow>> branchWorkflows() {
        BranchId.Named named = (BranchId.Named)Predef$.MODULE$.ArrowAssoc((Object)BranchId$.MODULE$.Try_());
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)named, (Object)this.tryWorkflow());
        BranchId.Named named2 = (BranchId.Named)Predef$.MODULE$.ArrowAssoc((Object)BranchId$.MODULE$.Catch_());
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)named2, (Object)this.catchWorkflow());
        return package$.MODULE$.Nil().$colon$colon((Object)tuple22).$colon$colon((Object)tuple2);
    }

    @Override
    public Option<BranchId> toCatchBranchId(BranchId branchId) {
        Option<Object> option;
        BranchId branchId2 = branchId;
        if (branchId2 != null && !(option = TryBranchId$.MODULE$.unapply(branchId2)).isEmpty()) {
            int n;
            int i = n = BoxesRunTime.unboxToInt((Object)option.get());
            return Some$.MODULE$.apply((Object)BranchId$.MODULE$.catch_(i));
        }
        return Instruction.toCatchBranchId$(this, branchId);
    }

    public FiniteDuration retryDelay(int index) {
        Option<IndexedSeq<FiniteDuration>> option = this.retryDelays();
        if (None$.MODULE$.equals(option)) {
            return TryInstruction$.js7$data$workflow$instructions$TryInstruction$$$NoRetryDelay;
        }
        if (option instanceof Some) {
            IndexedSeq delays = (IndexedSeq)((Some)option).value();
            if (delays.isEmpty()) {
                return TryInstruction$.js7$data$workflow$instructions$TryInstruction$$$NoRetryDelay;
            }
            if (index >= ((SeqOps)this.retryDelays().getOrElse(TryInstruction::retryDelay$$anonfun$1)).length()) {
                return (FiniteDuration)delays.last();
            }
            return (FiniteDuration)delays.apply(index - 1);
        }
        throw new MatchError(option);
    }

    public boolean isRetry() {
        return this.catchWorkflow().instructions().exists((Function1 & Serializable)x$1 -> {
            Instruction instruction = x$1;
            if (instruction instanceof TryInstruction) {
                TryInstruction instr = (TryInstruction)instruction;
                return TryInstruction$.MODULE$.js7$data$workflow$instructions$TryInstruction$$$containsRetry(instr.tryWorkflow());
            }
            if (instruction instanceof Retry) {
                return true;
            }
            if (instruction instanceof If) {
                If instr = (If)instruction;
                return instr.workflows().exists((Function1 & Serializable)workflow -> TryInstruction$.MODULE$.js7$data$workflow$instructions$TryInstruction$$$containsRetry((Workflow)workflow));
            }
            return false;
        });
    }

    public String toString() {
        return "try " + this.tryWorkflow() + " catch " + this.catchWorkflow() + this.sourcePosToString();
    }

    public TryInstruction copy(Workflow tryWorkflow, Workflow catchWorkflow, Option<IndexedSeq<FiniteDuration>> retryDelays, Option<Object> maxTries, Option<SourcePos> sourcePos) {
        return new TryInstruction(tryWorkflow, catchWorkflow, retryDelays, maxTries, sourcePos);
    }

    public Workflow copy$default$1() {
        return this.tryWorkflow();
    }

    public Workflow copy$default$2() {
        return this.catchWorkflow();
    }

    public Option<IndexedSeq<FiniteDuration>> copy$default$3() {
        return this.retryDelays();
    }

    public Option<Object> copy$default$4() {
        return this.maxTries();
    }

    public Option<SourcePos> copy$default$5() {
        return this.sourcePos();
    }

    public Workflow _1() {
        return this.tryWorkflow();
    }

    public Workflow _2() {
        return this.catchWorkflow();
    }

    public Option<IndexedSeq<FiniteDuration>> _3() {
        return this.retryDelays();
    }

    public Option<Object> _4() {
        return this.maxTries();
    }

    public Option<SourcePos> _5() {
        return this.sourcePos();
    }

    private static final IndexedSeq retryDelay$$anonfun$1() {
        return package$.MODULE$.Vector().empty();
    }
}

