/*
 * Decompiled with CFR 0.152.
 */
package js7.provider.scheduledorder.oldruntime;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalTime;
import js7.base.time.JavaTime;
import js7.base.time.JavaTime$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.provider.scheduledorder.oldruntime.ExtendedLocalTime;
import js7.provider.scheduledorder.oldruntime.ExtendedLocalTime$;
import js7.provider.scheduledorder.oldruntime.Period;
import js7.provider.scheduledorder.oldruntime.RepeatPeriod$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RepeatPeriod
implements Ordered,
Period,
Product,
Serializable {
    private final LocalTime begin;
    private final ExtendedLocalTime end;
    private final Duration absoluteRepeat;

    public static LocalTime StartOfDay() {
        return RepeatPeriod$.MODULE$.StartOfDay();
    }

    public static RepeatPeriod apply(LocalTime localTime, ExtendedLocalTime extendedLocalTime, Duration duration) {
        return RepeatPeriod$.MODULE$.apply(localTime, extendedLocalTime, duration);
    }

    public static RepeatPeriod fromProduct(Product product) {
        return RepeatPeriod$.MODULE$.fromProduct(product);
    }

    public static RepeatPeriod unapply(RepeatPeriod repeatPeriod) {
        return RepeatPeriod$.MODULE$.unapply(repeatPeriod);
    }

    public static RepeatPeriod wholeDay(Duration duration) {
        return RepeatPeriod$.MODULE$.wholeDay(duration);
    }

    public RepeatPeriod(LocalTime begin, ExtendedLocalTime end, Duration absoluteRepeat) {
        this.begin = begin;
        this.end = end;
        this.absoluteRepeat = absoluteRepeat;
        Ordered.$init$((Ordered)this);
        Predef$.MODULE$.require(new JavaTime.RichLocalTime(JavaTime$.MODULE$.RichLocalTime(begin)).$greater$eq(new JavaTime.RichLocalTime(JavaTime$.MODULE$.RichLocalTime(RepeatPeriod$.MODULE$.StartOfDay()))), () -> RepeatPeriod.$init$$$anonfun$1(begin));
        Predef$.MODULE$.require(end.$less$eq(ExtendedLocalTime$.MODULE$.EndOfDay()), () -> RepeatPeriod.$init$$$anonfun$2(end));
        Predef$.MODULE$.require(begin.toNanoOfDay() <= end.toNanoOfDay(), () -> RepeatPeriod.$init$$$anonfun$3(begin, end));
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RepeatPeriod)) return false;
        RepeatPeriod repeatPeriod = (RepeatPeriod)object;
        LocalTime localTime = this.begin();
        LocalTime localTime2 = repeatPeriod.begin();
        if (localTime == null) {
            if (localTime2 != null) {
                return false;
            }
        } else if (!((Object)localTime).equals(localTime2)) return false;
        ExtendedLocalTime extendedLocalTime = this.end();
        ExtendedLocalTime extendedLocalTime2 = repeatPeriod.end();
        if (extendedLocalTime == null) {
            if (extendedLocalTime2 != null) {
                return false;
            }
        } else if (!((Object)extendedLocalTime).equals(extendedLocalTime2)) return false;
        Duration duration = this.absoluteRepeat();
        Duration duration2 = repeatPeriod.absoluteRepeat();
        if (duration == null) {
            if (duration2 == null) return true;
            return false;
        } else {
            if (!((Object)duration).equals(duration2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof RepeatPeriod;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "RepeatPeriod";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "begin";
            }
            case 1: {
                return "end";
            }
            case 2: {
                return "absoluteRepeat";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public LocalTime begin() {
        return this.begin;
    }

    @Override
    public ExtendedLocalTime end() {
        return this.end;
    }

    public Duration absoluteRepeat() {
        return this.absoluteRepeat;
    }

    public Some<Duration> absoluteRepeatOption() {
        return Some$.MODULE$.apply((Object)this.absoluteRepeat());
    }

    @Override
    public Option<LocalTime> nextLocalTime(LocalTime t) {
        if (new JavaTime.RichLocalTime(JavaTime$.MODULE$.RichLocalTime(t)).$less(new JavaTime.RichLocalTime(JavaTime$.MODULE$.RichLocalTime(this.begin())))) {
            return Some$.MODULE$.apply((Object)this.begin());
        }
        long last = (t.toNanoOfDay() + this.absoluteRepeat().toNanos() - this.begin().toNanoOfDay()) / this.absoluteRepeat().toNanos();
        long next = this.begin().toNanoOfDay() + last * this.absoluteRepeat().toNanos();
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(next < this.end().toNanoOfDay()), () -> RepeatPeriod.nextLocalTime$$anonfun$1(next));
    }

    public RepeatPeriod copy(LocalTime begin, ExtendedLocalTime end, Duration absoluteRepeat) {
        return new RepeatPeriod(begin, end, absoluteRepeat);
    }

    public LocalTime copy$default$1() {
        return this.begin();
    }

    public ExtendedLocalTime copy$default$2() {
        return this.end();
    }

    public Duration copy$default$3() {
        return this.absoluteRepeat();
    }

    public LocalTime _1() {
        return this.begin();
    }

    public ExtendedLocalTime _2() {
        return this.end();
    }

    public Duration _3() {
        return this.absoluteRepeat();
    }

    private static final Object $init$$$anonfun$1(LocalTime begin$1) {
        return "RepeatPeriod.begin should be >= " + ExtendedLocalTime$.MODULE$.StartOfDay() + ": " + begin$1;
    }

    private static final Object $init$$$anonfun$2(ExtendedLocalTime end$1) {
        return "RepeatPeriod.end should be <= " + ExtendedLocalTime$.MODULE$.EndOfDay() + ": " + end$1;
    }

    private static final Object $init$$$anonfun$3(LocalTime begin$2, ExtendedLocalTime end$2) {
        return "RepeatPeriod.begin should not be after end: begin=" + begin$2 + " end=" + end$2;
    }

    private static final LocalTime nextLocalTime$$anonfun$1(long next$1) {
        return LocalTime.ofNanoOfDay(next$1);
    }
}

