/*
 * Decompiled with CFR 0.152.
 */
package js7.service.pgp;

import cats.Show;
import cats.syntax.package;
import java.io.Serializable;
import java.util.Base64;
import js7.base.crypt.DocumentSigner;
import js7.base.crypt.pgp.PgpSignature;
import js7.base.crypt.pgp.PgpSignature$;
import js7.base.data.ByteArray;
import js7.base.generic.SecretString;
import js7.base.problem.Problem;
import js7.service.pgp.PgpCommons$;
import js7.service.pgp.PgpSignatureVerifier;
import js7.service.pgp.PgpSigner$;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public final class PgpSigner
implements DocumentSigner {
    private final PGPSecretKey pgpSecretKey;
    private final PGPPrivateKey pgpPrivateKey;
    private final Option<String> maybeUserId;

    public static Either<Problem, PgpSigner> apply(PGPSecretKey pGPSecretKey, SecretString secretString) {
        return PgpSigner$.MODULE$.apply(pGPSecretKey, secretString);
    }

    public static Either<Problem, PgpSigner> checked(ByteArray byteArray, SecretString secretString) {
        return PgpSigner$.MODULE$.checked(byteArray, secretString);
    }

    public static Tuple2<PgpSigner, PgpSignatureVerifier> forTest() {
        return PgpSigner$.MODULE$.forTest();
    }

    public static String typeName() {
        return PgpSigner$.MODULE$.typeName();
    }

    public PgpSigner(PGPSecretKey pgpSecretKey, SecretString password) {
        this.pgpSecretKey = pgpSecretKey;
        PgpCommons$.MODULE$.registerBouncyCastle();
        this.pgpPrivateKey = pgpSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build((char[])StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString(password.string()), ClassTag$.MODULE$.apply(Character.TYPE))));
        this.maybeUserId = CollectionConverters$.MODULE$.IteratorHasAsScala(pgpSecretKey.getPublicKey().getUserIDs()).asScala().buffered().headOption();
    }

    @Override
    public PgpSigner$ companion() {
        return PgpSigner$.MODULE$;
    }

    @Override
    public PgpSignature sign(ByteArray message) {
        PGPSignatureGenerator signatureGenerator = this.newSignatureGenerator();
        signatureGenerator.update(message.unsafeArray());
        byte[] signatureBytes = signatureGenerator.generate().getEncoded(true);
        return PgpSignature$.MODULE$.apply(Base64.getMimeEncoder().encodeToString(signatureBytes));
    }

    private PGPSignatureGenerator newSignatureGenerator() {
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(this.pgpSecretKey.getPublicKey().getAlgorithm(), PgpSigner$.js7$service$pgp$PgpSigner$$$OurHashAlgorithm).setProvider("BC"));
        signatureGenerator.init(0, this.pgpPrivateKey);
        this.maybeUserId.foreach((Function1)(JProcedure1 & Serializable)u -> {
            PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
            subpacketGenerator.addSignerUserID(false, u);
            signatureGenerator.setHashedSubpackets(subpacketGenerator.generate());
        });
        return signatureGenerator;
    }

    public String toString() {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"PgpSigner(", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)this.pgpSecretKey, PgpCommons$.MODULE$.PGPSecretKeyShow()))}));
    }
}

