/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.agentbatchinstaller;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Order;
import sos.spooler.Variable_set;
import sos.util.ParameterSubstitutor;

public class JSUniversalAgentBatchInstallerProcessTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSUniversalAgentBatchInstallerProcessTemplate.class);
    private HashMap<String, String> knownParameterNames = new HashMap();

    public JSUniversalAgentBatchInstallerProcessTemplate() {
        this.knownParameterNames.put("SCHEDULER_HOME", "");
        this.knownParameterNames.put("SCHEDULER_HTTP_PORT", "");
        this.knownParameterNames.put("SCHEDULER_USER", "");
        this.knownParameterNames.put("SCHEDULER_IP_ADDRESS", "");
        this.knownParameterNames.put("SCHEDULER_LOG_DIR", "");
        this.knownParameterNames.put("SCHEDULER_WORK_DIR", "");
        this.knownParameterNames.put("SCHEDULER_PID_FILE_DIR", "");
        this.knownParameterNames.put("SCHEDULER_KILL_SCRIPT", "");
        this.knownParameterNames.put("JAVA_HOME", "");
        this.knownParameterNames.put("JAVA_OPTIONS", "");
    }

    public void execute(File fileIn, File fileOut, HashMap<String, String> subst) {
        ParameterSubstitutor parameterSubstitutor = new ParameterSubstitutor();
        for (Map.Entry<String, String> entry : subst.entrySet()) {
            String value = entry.getValue();
            String paramName = entry.getKey().toUpperCase();
            LOGGER.debug("---->" + paramName + "=" + value);
            if (!value.isEmpty()) {
                parameterSubstitutor.addKey(paramName + "_value", value);
                parameterSubstitutor.addKey(paramName, String.format("%s=%s", paramName, value));
                continue;
            }
            parameterSubstitutor.addKey(paramName, String.format("#%s=", paramName));
        }
        for (Map.Entry<String, String> entry : this.knownParameterNames.entrySet()) {
            String paramName = entry.getKey().toUpperCase();
            if (subst.get(paramName) != null) continue;
            parameterSubstitutor.addKey(paramName, String.format("#%s=", paramName));
        }
        try {
            parameterSubstitutor.replaceInFile(fileIn, fileOut);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void execute(String fileIn, String fileOut, Order order) {
        String[] keys;
        HashMap<String, String> subst = new HashMap<String, String>();
        Variable_set params = order.params();
        String parameterNames = params.names();
        for (String paramName : keys = parameterNames.split(";")) {
            if (!paramName.startsWith("agent_options.")) continue;
            String value = order.params().value(paramName);
            paramName = paramName.replaceFirst("^agent_options\\.(.*)$", "$1");
            paramName = paramName.toUpperCase();
            subst.put(paramName, value);
        }
        this.execute(new File(fileIn), new File(fileOut), subst);
    }
}

