/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.agentbatchinstaller.model;

import com.sos.jitl.agentbatchinstaller.JSUniversalAgentBatchInstaller;
import com.sos.jitl.agentbatchinstaller.model.JSUniversalAgentInstallations;
import com.sos.jitl.agentbatchinstaller.model.JSUniversalAgentinstallation;
import com.sos.jitl.agentbatchinstaller.model.installations.Installation;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Job_chain;
import sos.spooler.Order;
import sos.spooler.Spooler;
import sos.xml.SOSXMLXPath;

public class JSUniversalAgentBatchInstallerExecuter {
    private static final String XPATH_TARGET_DIRECTORY = "//Profiles/Profile[@profile_id='%s']//CopyTarget//Directory";
    private static final String XPATH_SOURCE_DIRECTORY = "//Profiles/Profile[@profile_id='%s']//CopySource//Directory";
    private Order order = null;
    private JSUniversalAgentBatchInstaller jsUniversalAgentBatchInstaller = null;
    private File installationDefinitionFile;
    private String installationJobChain;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSUniversalAgentBatchInstallerExecuter.class);
    private boolean update;
    private String filterInstallHost = "";
    private int filterInstallPort = 0;
    private int installationCounter = 0;
    private JSUniversalAgentinstallation jsInstallation;
    private HashMap<String, String> createdOrders;

    private void init() {
        this.installationDefinitionFile = new File(this.jsUniversalAgentBatchInstaller.options().getinstallation_definition_file().getValue());
        this.installationJobChain = this.jsUniversalAgentBatchInstaller.options().getinstallation_job_chain().getValue();
        this.update = this.jsUniversalAgentBatchInstaller.options().getupdate().isTrue();
        this.filterInstallHost = this.jsUniversalAgentBatchInstaller.options().getfilter_install_host().getValue();
        this.filterInstallPort = this.jsUniversalAgentBatchInstaller.options().getfilter_install_port().value();
        this.createdOrders = new HashMap();
    }

    private boolean filterNotSetOrFilterMatch(String value, String filter) {
        LOGGER.debug("Testing filter:" + value + "=" + filter);
        return value.equals(filter) || filter == null || "".equals(filter.trim());
    }

    private boolean filterNotSetOrFilterMatch(int value, int filter) {
        LOGGER.debug("Testing filter:" + value + "=" + filter);
        return value == filter || filter == 0;
    }

    private boolean checkFilter() {
        boolean filterMatch = this.filterNotSetOrFilterMatch(this.jsInstallation.getAgentOptions().getSchedulerIpAddress(), this.filterInstallHost) && this.filterNotSetOrFilterMatch(this.jsInstallation.getAgentOptions().getSchedulerHttpPort(), this.filterInstallPort);
        LOGGER.debug("FilterMatch: " + filterMatch);
        boolean installationNotExecuted = this.jsInstallation.getLastRun() == null || "".equals(this.jsInstallation.getLastRun());
        LOGGER.debug("installationNotExecuted: " + installationNotExecuted + "(lastRun=" + this.jsInstallation.getLastRun() + ")");
        if (filterMatch && (installationNotExecuted || this.update)) {
            return true;
        }
        if (!filterMatch) {
            LOGGER.info("Installation will not execute because filter does not match");
        }
        if (!installationNotExecuted) {
            LOGGER.info("Installation will not execute because already was executed");
        }
        return false;
    }

    private void updateLastRun(File installationsDefinitionFile) throws Exception {
        JSUniversalAgentInstallations jsInstallationsUpdateFile = new JSUniversalAgentInstallations(installationsDefinitionFile);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:MM");
        String now = dateFormat.format(new Date());
        jsInstallationsUpdateFile.getInstallations().setLastRun(now);
        while (!jsInstallationsUpdateFile.eof()) {
            Installation installationUpdate = jsInstallationsUpdateFile.nextInstallation();
            if (installationUpdate.getLastRun() != null && !"".equals(installationUpdate.getLastRun()) && !this.update) continue;
            installationUpdate.setLastRun(now);
        }
        jsInstallationsUpdateFile.writeFile(installationsDefinitionFile);
    }

    public void performInstallation(JSUniversalAgentBatchInstaller jsUniversalAgentatchInstaller) throws Exception {
        this.jsUniversalAgentBatchInstaller = jsUniversalAgentatchInstaller;
        this.init();
        this.installationDefinitionFile = new File(jsUniversalAgentatchInstaller.options().getinstallation_definition_file().getValue());
        JSUniversalAgentInstallations jsInstallations = new JSUniversalAgentInstallations(this.installationDefinitionFile);
        this.installationCounter = jsInstallations.getInstallations().getInstallation().size();
        LOGGER.info(String.format("installing %s JobScheduler Universal Agents", this.installationCounter));
        while (!jsInstallations.eof()) {
            this.jsInstallation = jsInstallations.next();
            if (this.checkFilter()) {
                this.createOrder();
                continue;
            }
            LOGGER.info(String.format("Skip creation of order for JobScheduler Universal Agent %1$s", this.jsInstallation.getAgentOptions().getSchedulerIpAddress() + ":" + this.jsInstallation.getAgentOptions().getSchedulerHttpPort()));
        }
        this.updateLastRun(this.installationDefinitionFile);
    }

    private String getValueFromXml(String file, String xpathExpression) throws Exception {
        file = file.replace("\\", "/");
        file = file.replace(".ini", ".xml");
        SOSXMLXPath xpath = new SOSXMLXPath((InputStream)new FileInputStream(file), true);
        return xpath.selectSingleNodeValue(xpathExpression);
    }

    private void createOrder() throws Exception {
        Spooler spooler = (Spooler)this.jsUniversalAgentBatchInstaller.getJSCommands().getSpoolerObject();
        LOGGER.info(String.format("Start to create order for scheduler %1$s", this.jsInstallation.getAgentOptions().getSchedulerIpAddress() + ":" + this.jsInstallation.getAgentOptions().getSchedulerHttpPort()));
        LOGGER.info("scheduler_host:" + this.jsInstallation.getAgentOptions().getSchedulerIpAddress());
        LOGGER.info("install_path:" + this.jsInstallation.getInstallPath());
        LOGGER.info("scheduler_port:" + this.jsInstallation.getAgentOptions().getSchedulerHttpPort());
        LOGGER.info("----------------------------------------------");
        if (spooler == null) {
            LOGGER.info("Creation of order is skipped because spooler object is NULL");
            return;
        }
        this.order = spooler.create_order();
        Job_chain jobchain = spooler.job_chain(this.installationJobChain);
        String schedulerIpAddress = this.jsInstallation.getAgentOptions().getSchedulerIpAddress();
        int SchedulerHttpPort = this.jsInstallation.getAgentOptions().getSchedulerHttpPort();
        String orderId = schedulerIpAddress + ":" + SchedulerHttpPort;
        this.order.set_id(orderId);
        this.setParam("sync_session_id", this.jsInstallation.getAgentOptions().getSchedulerIpAddress() + ":" + this.jsInstallation.getInstallPath());
        this.setParam("agent_options.scheduler_ip_address", this.jsInstallation.getAgentOptions().getSchedulerIpAddress());
        this.setParam("agent_options.scheduler_http_port", this.jsInstallation.getAgentOptions().getSchedulerHttpPort());
        this.setParam("agent_options.java_home", this.jsInstallation.getAgentOptions().getJavaHome());
        this.setParam("agent_options.java_options", this.jsInstallation.getAgentOptions().getJavaOptions());
        this.setParam("agent_options.scheduler_home", this.jsInstallation.getInstallPath() + "/jobscheduler_agent");
        this.setParam("agent_options.scheduler_user", this.jsInstallation.getAgentOptions().getSchedulerUser());
        this.setParam("agent_options.scheduler_log_dir", this.jsInstallation.getAgentOptions().getSchedulerLogDir());
        this.setParam("agent_options.scheduler_kill_script", this.jsInstallation.getAgentOptions().getSchedulerKillScript());
        this.setParam("agent_options.scheduler_pid_file_dir", this.jsInstallation.getAgentOptions().getSchedulerPidFileDir());
        this.setParam("agent_options.agent_installation_script", this.jsInstallation.getAgentOptions().getAgentInstallationScript());
        this.setParam("TransferInstallationSetup/operation", "copy");
        this.setParam("TransferInstallationSetup/file_spec", this.jsInstallation.getTransfer().getFileSpec());
        this.setParam("TransferInstallationSetup/target_host", this.jsInstallation.getTransfer().getTarget().getHost());
        String sourceDir = "";
        String targetDir = "";
        if (this.jsInstallation.getTransfer().getSettings() == null || this.jsInstallation.getTransfer().getSettings().isEmpty()) {
            this.setParam("TransferInstallationSetup/target_port", this.jsInstallation.getTransfer().getTarget().getPort());
            this.setParam("TransferInstallationSetup/target_port", this.jsInstallation.getTransfer().getTarget().getPort());
            this.setParam("TransferInstallationSetup/target_protocol", this.jsInstallation.getTransfer().getTarget().getProtocol());
            this.setParam("TransferInstallationSetup/target_user", this.jsInstallation.getTransfer().getTarget().getUser());
            this.setParam("TransferInstallationSetup/target_password", this.jsInstallation.getTransfer().getTarget().getPassword());
            this.setParam("TransferInstallationSetup/target_dir", this.jsInstallation.getTransfer().getTarget().getDir());
            this.setParam("PerformInstall/target_dir", this.jsInstallation.getTransfer().getTarget().getDir());
            this.setParam("TransferInstallationSetup/target_ssh_auth_method", this.jsInstallation.getTransfer().getTarget().getSshAuthMethod());
            this.setParam("TransferInstallationSetup/target_ssh_auth_file", this.jsInstallation.getTransfer().getTarget().getSshAuthFile());
            this.setParam("TransferInstallationSetup/source_host", this.jsInstallation.getTransfer().getSource().getHost());
            this.setParam("TransferInstallationSetup/source_port", this.jsInstallation.getTransfer().getSource().getPort());
            this.setParam("TransferInstallationSetup/source_protocol", this.jsInstallation.getTransfer().getSource().getProtocol());
            this.setParam("TransferInstallationSetup/source_user", this.jsInstallation.getTransfer().getSource().getUser());
            this.setParam("TransferInstallationSetup/source_password", this.jsInstallation.getTransfer().getSource().getPassword());
            this.setParam("TransferInstallationSetup/source_dir", this.jsInstallation.getTransfer().getSource().getDir());
            this.setParam("PerformInstall/source_dir", this.jsInstallation.getTransfer().getSource().getDir());
            this.setParam("TransferInstallationSetup/source_ssh_auth_method", this.jsInstallation.getTransfer().getSource().getSshAuthMethod());
            this.setParam("TransferInstallationSetup/source_ssh_auth_file", this.jsInstallation.getTransfer().getSource().getSshAuthFile());
            sourceDir = this.jsInstallation.getTransfer().getSource().getDir();
            targetDir = this.jsInstallation.getTransfer().getTarget().getDir();
        } else {
            LOGGER.debug("...getting values from ini file: " + this.jsInstallation.getTransfer().getSettings());
            String profile = "";
            this.setParam("TransferInstallationSetup/settings", this.jsInstallation.getTransfer().getSettings());
            if (this.jsInstallation.getTransfer().getProfile() == null || this.jsInstallation.getTransfer().getProfile().isEmpty()) {
                if (this.jsInstallation.getAgentOptions().getSchedulerIpAddress() == null || this.jsInstallation.getAgentOptions().getSchedulerIpAddress().isEmpty()) {
                    LOGGER.warn("Please specify the value for the SchedulerIpAddress in the batchinstall configuration file");
                }
                profile = this.jsInstallation.getAgentOptions().getSchedulerIpAddress() + ":" + this.jsInstallation.getAgentOptions().getSchedulerHttpPort();
            } else {
                profile = this.jsInstallation.getTransfer().getProfile();
            }
            LOGGER.debug("...reading from profile: " + profile);
            this.setParam("TransferInstallationSetup/profile", profile);
            sourceDir = this.getValueFromXml(this.jsInstallation.getTransfer().getSettings(), String.format(XPATH_SOURCE_DIRECTORY, profile));
            targetDir = this.getValueFromXml(this.jsInstallation.getTransfer().getSettings(), String.format(XPATH_TARGET_DIRECTORY, profile));
        }
        this.setParam("TransferInstallationSetup/source_dir", sourceDir);
        this.setParam("TransferInstallationSetup/target_dir", targetDir);
        this.setParam("PerformInstall/source_dir", sourceDir);
        this.setParam("PerformInstall/target_dir", targetDir);
        this.setParam("PerformInstall/installation_file", this.jsInstallation.getInstallationFile());
        this.setParam("PerformInstall/simulate_shell", "true");
        this.setParam("host", String.valueOf(this.jsInstallation.getSsh().getHost()));
        this.setParam("port", String.valueOf(this.jsInstallation.getSsh().getPort()));
        this.setParam("user", this.jsInstallation.getSsh().getUser());
        this.setParam("auth_method", this.jsInstallation.getSsh().getAuthMethod());
        this.setParam("auth_file", this.jsInstallation.getSsh().getAuthFile());
        this.setParam("password", this.jsInstallation.getSsh().getPassword());
        this.setParam("sudo_password", this.jsInstallation.getSsh().getSudoPassword());
        this.setParam("install_path", this.jsInstallation.getInstallPath());
        if (this.jsInstallation.getPostprocessing() != null && this.jsInstallation.getPostprocessing().getCommand() != null) {
            this.setParam("PerformInstall/command_counter", String.valueOf(this.jsInstallation.getPostprocessing().getCommand().size()));
            for (int i = 0; i < this.jsInstallation.getPostprocessing().getCommand().size(); ++i) {
                String command = this.jsInstallation.getPostprocessing().getCommand().get(i);
                this.setParam("PerformInstall/command_" + i, command);
            }
        }
        if (this.createdOrders.get(schedulerIpAddress) != null) {
            this.setParam("skipFileTransfer", "true");
        } else {
            this.setParam("skipFileTransfer", "false");
        }
        jobchain.add_order(this.order);
        this.createdOrders.put(schedulerIpAddress, targetDir);
    }

    private void setParam(String paramName, int paramValue) {
        this.setParam(paramName, String.valueOf(paramValue));
    }

    private void setParam(String paramName, String paramValue) {
        if (paramValue != null && !paramValue.isEmpty()) {
            if (paramName.contains("password")) {
                LOGGER.info("ParamName = " + paramName + ", Value = ********");
            } else if (this.jsInstallation.getListOfEntriesWithParameter().get(paramValue) != null) {
                LOGGER.info("ParamName = " + paramName + ", Value = " + this.jsInstallation.getListOfEntriesWithParameter().get(paramValue));
            } else {
                LOGGER.info("ParamName = " + paramName + ", Value = " + paramValue);
            }
            this.order.params().set_var(paramName, paramValue);
        } else {
            LOGGER.debug("ParamName = " + paramName + ", Value is empty");
        }
    }
}

