/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkhistory;

import com.sos.JSHelper.Basics.IJSCommands;
import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Basics.JSToolBox;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.exception.SOSAccessDeniedException;
import com.sos.exception.SOSException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.jitl.checkhistory.HistoryHelper;
import com.sos.jitl.checkhistory.JobChainHistory;
import com.sos.jitl.checkhistory.JobHistory;
import com.sos.jitl.checkhistory.JobSchedulerCheckHistoryOptions;
import com.sos.jitl.checkhistory.interfaces.IJobSchedulerHistory;
import com.sos.jitl.checkhistory.interfaces.IJobSchedulerHistoryInfo;
import com.sos.jitl.restclient.AccessTokenProvider;
import com.sos.jitl.restclient.JobSchedulerCredentialStoreJOCParameters;
import com.sos.jitl.restclient.WebserviceCredentials;
import com.sos.localization.Messages;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Mail;
import sos.spooler.Spooler;

@I18NResourceBundle(baseName="com_sos_scheduler_messages", defaultLocale="en")
public class JobSchedulerCheckHistory
extends JSToolBox
implements JSJobUtilities,
IJSCommands {
    private final String conClassName = "JobSchedulerCheckRunHistory";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerCheckHistory.class);
    protected JobSchedulerCheckHistoryOptions jobSchedulerCheckHistoryOptions = null;
    private JSJobUtilities objJSJobUtilities = this;
    private IJSCommands objJSCommands = this;
    private String historyObjectName = "";
    private String pathOfJob = "";

    public void setPathOfJob(String _pathOfJob) {
        this.pathOfJob = _pathOfJob;
    }

    public JobSchedulerCheckHistory() {
        this.Messages = new Messages("com_sos_scheduler_messages");
    }

    public JobSchedulerCheckHistoryOptions options() {
        if (this.jobSchedulerCheckHistoryOptions == null) {
            this.jobSchedulerCheckHistoryOptions = new JobSchedulerCheckHistoryOptions();
        }
        return this.jobSchedulerCheckHistoryOptions;
    }

    private IJobSchedulerHistory getHistoryObject(Spooler schedulerInstance) throws UnsupportedEncodingException, InterruptedException, SOSException, URISyntaxException {
        IJobSchedulerHistory jobSchedulerHistory;
        JobSchedulerCredentialStoreJOCParameters jobSchedulerCredentialStoreJOCParameters = new JobSchedulerCredentialStoreJOCParameters();
        jobSchedulerCredentialStoreJOCParameters.setCredentialStoreEntryPath(this.jobSchedulerCheckHistoryOptions.credential_store_entry_path.getValue());
        jobSchedulerCredentialStoreJOCParameters.setCredentialStoreFile(this.jobSchedulerCheckHistoryOptions.credential_store_file.getValue());
        jobSchedulerCredentialStoreJOCParameters.setCredentialStoreKeyFile(this.jobSchedulerCheckHistoryOptions.credential_store_key_file.getValue());
        jobSchedulerCredentialStoreJOCParameters.setCredentialStorePassword(this.jobSchedulerCheckHistoryOptions.credential_store_password.getValue());
        jobSchedulerCredentialStoreJOCParameters.setJocUrl(this.jobSchedulerCheckHistoryOptions.jocUrl.getValue());
        jobSchedulerCredentialStoreJOCParameters.setPassword(this.jobSchedulerCheckHistoryOptions.password.getValue());
        jobSchedulerCredentialStoreJOCParameters.setUser(this.jobSchedulerCheckHistoryOptions.user.getValue());
        jobSchedulerCredentialStoreJOCParameters.setKeyPassword(this.jobSchedulerCheckHistoryOptions.keyPassword.getValue());
        jobSchedulerCredentialStoreJOCParameters.setKeyStorePassword(this.jobSchedulerCheckHistoryOptions.keystorePassword.getValue());
        jobSchedulerCredentialStoreJOCParameters.setKeyStorePath(this.jobSchedulerCheckHistoryOptions.keystorePath.getValue());
        jobSchedulerCredentialStoreJOCParameters.setKeyStoreType(this.jobSchedulerCheckHistoryOptions.keystoreType.getValue());
        jobSchedulerCredentialStoreJOCParameters.setTrustStorePassword(this.jobSchedulerCheckHistoryOptions.truststorePassword.getValue());
        jobSchedulerCredentialStoreJOCParameters.setTrustStorePath(this.jobSchedulerCheckHistoryOptions.truststorePath.getValue());
        jobSchedulerCredentialStoreJOCParameters.setTrustStoreType(this.jobSchedulerCheckHistoryOptions.truststoreType.getValue());
        AccessTokenProvider accessTokenProvider = new AccessTokenProvider(jobSchedulerCredentialStoreJOCParameters);
        WebserviceCredentials webserviceCredentials = new WebserviceCredentials();
        if (schedulerInstance != null) {
            webserviceCredentials = accessTokenProvider.getAccessToken(schedulerInstance);
        }
        if (webserviceCredentials == null) {
            throw new SOSAccessDeniedException("Could not get an AccessToken");
        }
        if (this.options().getJobChainName().getValue().isEmpty()) {
            this.historyObjectName = this.options().getJobName().getValue();
            jobSchedulerHistory = new JobHistory(webserviceCredentials);
        } else {
            this.historyObjectName = this.options().getJobChainName().getValue();
            jobSchedulerHistory = new JobChainHistory(webserviceCredentials);
        }
        jobSchedulerHistory.setRelativePath(this.pathOfJob);
        return jobSchedulerHistory;
    }

    public JobSchedulerCheckHistory execute() throws Exception {
        String conMethodName = "JobSchedulerCheckRunHistory::Execute";
        LOGGER.debug(String.format(this.Messages.getMsg("JSJ-I-110"), "JobSchedulerCheckRunHistory::Execute"));
        boolean result = false;
        this.options().checkMandatory();
        LOGGER.debug(this.options().toString());
        try {
            String startTime = "00:00:00";
            String endTime = "00:00:00";
            String query = this.options().query.getValue();
            String[] queries = query.split("(;|,)");
            String methodName = HistoryHelper.getMethodName(this.options().query.getValue());
            if (this.options().start_time.isDirty()) {
                startTime = this.options().start_time.getValue();
            }
            if (this.options().end_time.isDirty()) {
                endTime = this.options().end_time.getValue();
            }
            String message = this.options().message.getValue();
            String mailTo = this.options().mailTo.getValue();
            String mailCc = this.options().mailCC.getValue();
            String mailBcc = this.options().mail_bcc.getValue();
            Spooler schedulerInstance = (Spooler)this.objJSCommands.getSpoolerObject();
            IJobSchedulerHistory jobHistory = this.getHistoryObject(schedulerInstance);
            if (schedulerInstance != null) {
                Mail mail = schedulerInstance.log().mail();
                if (this.isNotEmpty(mailTo)) {
                    mail.set_to(mailTo);
                }
                if (this.isNotEmpty(mailCc)) {
                    mail.set_cc(mailCc);
                }
                if (this.isNotEmpty(mailBcc)) {
                    mail.set_bcc(mailBcc);
                }
                if (this.isNotEmpty(message)) {
                    mail.set_subject(message);
                }
            }
            if ("isCompletedBefore".equalsIgnoreCase(methodName) || "isCompletedSuccessfulBefore".equalsIgnoreCase(methodName) || "isCompletedWithErrorBefore".equalsIgnoreCase(methodName)) {
                String time = HistoryHelper.getParameter(endTime, query);
                jobHistory.setTimeLimit(time);
            }
            String[] historyObjectNames = this.historyObjectName.split("(;|,)");
            for (int i = 0; i < historyObjectNames.length; ++i) {
                String actHistoryObjectName = historyObjectNames[i];
                actHistoryObjectName = Matcher.quoteReplacement(actHistoryObjectName);
                String strTemp = message.replaceAll("(?im)\\[?JOB_NAME\\]?", actHistoryObjectName);
                message = this.Messages.getMsg("JCH_T_0001", new Object[]{actHistoryObjectName, strTemp});
                IJobSchedulerHistoryInfo jobSchedulerHistoryInfo = jobHistory.getJobSchedulerHistoryInfo(actHistoryObjectName);
                actHistoryObjectName = jobHistory.getActHistoryObjectName();
                jobSchedulerHistoryInfo.setEndTime(endTime);
                jobSchedulerHistoryInfo.setStartTime(startTime);
                String actQuery = "";
                if (queries.length == 1) {
                    actQuery = query;
                } else if (queries.length > i) {
                    actQuery = queries[i];
                }
                result = jobSchedulerHistoryInfo.queryHistory(actQuery);
                LOGGER.debug("--->" + actQuery + "(" + actHistoryObjectName + ")=" + result);
                this.options().result.value(result);
                if (jobSchedulerHistoryInfo.getLastCompleted().error == 0) {
                    if (jobSchedulerHistoryInfo.getLastCompleted().found) {
                        LOGGER.info(this.Messages.getMsg("JCH_I_0001", new Object[]{actHistoryObjectName, jobSchedulerHistoryInfo.getLastCompleted().end, ""}));
                    }
                    if (jobSchedulerHistoryInfo.getLastCompletedWithError().found) {
                        LOGGER.info(this.Messages.getMsg("JCH_I_0003", new Object[]{actHistoryObjectName, jobSchedulerHistoryInfo.getLastCompletedWithError().end, jobSchedulerHistoryInfo.getLastCompletedWithError().errorMessage}));
                    } else {
                        LOGGER.info(this.Messages.getMsg("JCH_I_0006", new Object[]{actHistoryObjectName}));
                    }
                } else {
                    if (jobSchedulerHistoryInfo.getLastCompleted().found) {
                        LOGGER.info(this.Messages.getMsg("JCH_I_0002", new Object[]{actHistoryObjectName, jobSchedulerHistoryInfo.getLastCompleted().end, jobSchedulerHistoryInfo.getLastCompleted().errorMessage}));
                    }
                    if (jobSchedulerHistoryInfo.getLastCompletedSuccessful().found) {
                        LOGGER.info(this.Messages.getMsg("JCH_I_0004", new Object[]{actHistoryObjectName, jobSchedulerHistoryInfo.getLastCompletedSuccessful().end}));
                    } else {
                        LOGGER.info(this.Messages.getMsg("JCH_I_0005", new Object[]{actHistoryObjectName}));
                    }
                }
                if (!result) {
                    message = message + " " + methodName + "=false";
                    if ("true".equals(this.options().failOnQueryResultFalse.getValue())) {
                        LOGGER.error(message);
                        throw new JobSchedulerException(message);
                    }
                    LOGGER.info(message);
                    continue;
                }
                message = message + " " + methodName + "=true";
                if (this.options().failOnQueryResultTrue.value()) {
                    LOGGER.error(message);
                    throw new JobSchedulerException(message);
                }
                LOGGER.info(message);
            }
        }
        catch (JobSchedulerException ee) {
            LOGGER.error(this.Messages.getMsg("JSJ-F-107", new Object[]{"JobSchedulerCheckRunHistory::Execute"}) + ":" + ee.getMessage());
            throw ee;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(this.Messages.getMsg("JSJ-F-107", new Object[]{"JobSchedulerCheckRunHistory::Execute"}) + ":" + e.toString(), (Throwable)e);
            throw e;
        }
        return this;
    }

    public String replaceSchedulerVars(String pstrString2Modify) {
        LOGGER.debug("replaceSchedulerVars as Dummy-call executed. No Instance of JobUtilites specified.");
        return pstrString2Modify;
    }

    public void setJSParam(String pstrKey, String pstrValue) {
    }

    public void setJSParam(String pstrKey, StringBuilder pstrValue) {
    }

    public void setJSJobUtilites(JSJobUtilities pobjJSJobUtilities) {
        this.objJSJobUtilities = pobjJSJobUtilities == null ? this : pobjJSJobUtilities;
        LOGGER.debug("objJSJobUtilities = " + this.objJSJobUtilities.getClass().getName());
    }

    public void setJSCommands(IJSCommands pobjJSCommands) {
        if (pobjJSCommands == null) {
            this.objJSCommands = this;
        } else {
            this.objJSCommands = pobjJSCommands;
            LOGGER.debug("pobjJSCommands = " + pobjJSCommands.getClass().getName());
        }
    }

    public Object getSpoolerObject() {
        return null;
    }

    public String executeXML(String pstrJSXmlCommand) {
        return null;
    }

    public void setStateText(String pstrStateText) {
    }

    public void setExitCode(int pintCC) {
    }

    public void setNextNodeState(String pstrNodeName) {
    }
}

