/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.dailyplan.db;

import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.classes.SearchStringHelper;
import com.sos.hibernate.classes.UtcTimeHelper;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.layer.SOSHibernateIntervalDBLayer;
import com.sos.jitl.dailyplan.db.Calendar2DB;
import com.sos.jitl.dailyplan.db.DailyPlanDBItem;
import com.sos.jitl.dailyplan.db.DailyPlanWithReportExecutionDBItem;
import com.sos.jitl.dailyplan.db.DailyPlanWithReportTriggerDBItem;
import com.sos.jitl.dailyplan.filter.DailyPlanFilter;
import com.sos.jitl.reporting.db.DBItemReportTask;
import com.sos.jitl.reporting.db.DBItemReportTrigger;
import com.sos.jitl.reporting.db.ReportTaskExecutionsDBLayer;
import com.sos.jitl.reporting.db.ReportTriggerDBLayer;
import com.sos.joc.model.common.Folder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.TemporalType;
import org.hibernate.query.Query;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DailyPlanDBLayer
extends SOSHibernateIntervalDBLayer<DailyPlanDBItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Calendar2DB.class);
    private static final String DailyPlanDBItem = DailyPlanDBItem.class.getName();
    private static final String DBItemReportTask = DBItemReportTask.class.getName();
    private static final String DBItemReportTrigger = DBItemReportTrigger.class.getName();
    private String whereFromIso = null;
    private String whereToIso = null;
    private DailyPlanFilter filter = null;

    public DailyPlanDBLayer(SOSHibernateSession session) {
        this.setConfigurationFileName(((Path)session.getFactory().getConfigFile().get()).toFile().getAbsolutePath());
        this.sosHibernateSession = session;
        this.resetFilter();
    }

    public DailyPlanDBLayer(File configurationFile) throws SOSHibernateException, IOException {
        this.setConfigurationFileName(configurationFile.getAbsolutePath());
        this.createStatelessConnection(configurationFile.getCanonicalPath());
        this.resetFilter();
    }

    public DailyPlanDBItem getPlanDbItem(Long id) throws SOSHibernateException {
        return (DailyPlanDBItem)((Object)this.sosHibernateSession.get(DailyPlanDBItem.class, (Serializable)id));
    }

    public void resetFilter() {
        this.filter = new DailyPlanFilter();
        this.filter.setSchedulerId("");
        this.filter.setJob("");
        this.filter.setJobChain("");
        this.filter.setOrderId("");
    }

    public int delete(boolean onlyWhereAuditLogIdIsNull) throws SOSHibernateException {
        String hql = "delete from " + DailyPlanDBItem + " p " + this.getWhere(onlyWhereAuditLogIdIsNull);
        LOGGER.info("Delete: " + hql + " --> " + this.filter.getJobStreamStarterId());
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        if (this.filter.getPlannedStart() != null) {
            query.setParameter("plannedStart", this.filter.getPlannedStart(), TemporalType.TIMESTAMP);
        } else {
            if (this.filter.getPlannedStartFrom() != null) {
                query.setParameter("plannedStartFrom", this.filter.getPlannedStartFrom(), TemporalType.TIMESTAMP);
            }
            if (this.filter.getPlannedStartTo() != null) {
                query.setParameter("plannedStartTo", this.filter.getPlannedStartTo(), TemporalType.TIMESTAMP);
            }
        }
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getOrderId() != null && !"".equals(this.filter.getOrderId())) {
            query.setParameter("orderId", (Object)this.filter.getOrderId());
        }
        if (this.filter.getJob() != null && !"".equals(this.filter.getJob())) {
            query.setParameter("job", (Object)this.filter.getJob());
        }
        if (this.filter.getJobChain() != null && !"".equals(this.filter.getJobChain())) {
            query.setParameter("jobChain", (Object)this.filter.getJobChain());
        }
        if (this.filter.getJobStream() != null && !"".equals(this.filter.getJobStream())) {
            query.setParameter("jobStream", (Object)this.filter.getJobStream());
        }
        if (this.filter.getJobStreamStarterId() != null) {
            query.setParameter("jobStreamStarterId", (Object)this.filter.getJobStreamStarterId());
        }
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public long deleteInterval() throws SOSHibernateException {
        String hql = "delete from " + DailyPlanDBItem + " p " + this.getWhere();
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        if (this.filter.getPlannedStartFrom() != null) {
            query.setParameter("plannedStartFrom", this.filter.getPlannedStartFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getPlannedStartTo() != null) {
            query.setParameter("plannedStartTo", this.filter.getPlannedStartTo(), TemporalType.TIMESTAMP);
        }
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public String getWhere() {
        return this.getWhere("");
    }

    private String getWhere(boolean onlyWhereAuditLogIdIsNull) {
        String where = this.getWhere();
        if (onlyWhereAuditLogIdIsNull) {
            where = where.isEmpty() ? where + " where p.auditLogId is null" : where + " and p.auditLogId is null";
        }
        return where;
    }

    private String getWhere(String pathField) {
        String where = "";
        String and = "";
        if (this.filter.getPlannedStart() != null) {
            where = where + and + " p.plannedStart = :plannedStart";
            and = " and ";
        } else {
            if (this.filter.getPlannedStartFrom() != null) {
                where = where + and + " p.plannedStart>= :plannedStartFrom";
                and = " and ";
            }
            if (this.filter.getPlannedStartTo() != null) {
                where = where + and + " p.plannedStart < :plannedStartTo ";
                and = " and ";
            }
        }
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            where = where + and + " p.schedulerId = :schedulerId";
            and = " and ";
        }
        if (this.filter.getJob() != null && !"".equals(this.filter.getJob())) {
            where = where + String.format(and + " p.job %s :job", SearchStringHelper.getSearchPathOperator((String)this.filter.getJob()));
            and = " and ";
        }
        if (this.filter.getJobChain() != null && !"".equals(this.filter.getJobChain())) {
            where = where + String.format(and + " p.jobChain %s :jobChain", SearchStringHelper.getSearchPathOperator((String)this.filter.getJobChain()));
            and = " and ";
        }
        if (this.filter.getJobStream() != null && !"".equals(this.filter.getJobStream())) {
            where = where + String.format(and + " p.jobStream %s :jobStream", SearchStringHelper.getSearchPathOperator((String)this.filter.getJobStream()));
            and = " and ";
        }
        if (this.filter.getJobStreamStarterId() != null) {
            where = where + String.format(and + " p.jobStreamStarterId = :jobStreamStarterId", new Object[0]);
            and = " and ";
        }
        if (this.filter.getOrderId() != null && !"".equals(this.filter.getOrderId())) {
            where = where + String.format(and + " p.orderId %s :orderId", SearchStringHelper.getSearchOperator((String)this.filter.getOrderId()));
            and = " and ";
        }
        if (this.filter.getIsLate() != null) {
            where = this.filter.isLate() != false ? where + and + " p.isLate = 1" : where + and + " p.isLate = 0";
            and = " and ";
        }
        if (this.filter.isJobStream() != null) {
            if (this.filter.isJobStream().booleanValue()) {
                where = this.sosHibernateSession.getFactory().getDbms().equals(SOSHibernateFactory.Dbms.ORACLE) ? where + and + " p.jobStream is not null" : where + and + " (p.jobStream is not null or p.jobStream <> '')";
            }
            and = " and ";
        }
        if (this.filter.getStates() != null && this.filter.getStates().size() > 0) {
            where = where + and + "(";
            for (String state : this.filter.getStates()) {
                where = where + " p.state = '" + state + "' or";
            }
            where = where + " 1=0)";
            and = " and ";
        }
        if (!"".equals(pathField) && this.filter.getListOfFolders() != null && this.filter.getListOfFolders().size() > 0) {
            where = where + and + "(";
            for (Folder filterFolder : this.filter.getListOfFolders()) {
                String likeFolder = (filterFolder.getFolder() + "/%").replaceAll("//+", "/");
                where = where + " (" + pathField + " = '" + filterFolder.getFolder() + "' or " + pathField + " like '" + likeFolder + "')";
                where = where + " or ";
            }
            where = where + " 0=1)";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    private <T> Query<T> bindParameters(Query<T> query) {
        if (this.filter.getPlannedStartFrom() != null) {
            query.setParameter("plannedStartFrom", this.filter.getPlannedStartFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getPlannedStartTo() != null) {
            query.setParameter("plannedStartTo", this.filter.getPlannedStartTo(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getPlannedStart() != null) {
            query.setParameter("plannedStart", this.filter.getPlannedStart(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getJob() != null && !"".equals(this.filter.getJob())) {
            query.setParameter("job", (Object)SearchStringHelper.getSearchPathValue((String)this.filter.getJob()));
        }
        if (this.filter.getJobChain() != null && !"".equals(this.filter.getJobChain())) {
            query.setParameter("jobChain", (Object)SearchStringHelper.getSearchPathValue((String)this.filter.getJobChain()));
        }
        if (this.filter.getJobStream() != null && !"".equals(this.filter.getJobStream())) {
            query.setParameter("jobStream", (Object)SearchStringHelper.getSearchPathValue((String)this.filter.getJobStream()));
        }
        if (this.filter.getOrderId() != null && !"".equals(this.filter.getOrderId())) {
            query.setParameter("orderId", (Object)this.filter.getOrderId());
        }
        return query;
    }

    public List<DailyPlanWithReportTriggerDBItem> getDailyPlanListOrder(int limit) throws SOSHibernateException {
        Query query = this.sosHibernateSession.createQuery("select new com.sos.jitl.dailyplan.db.DailyPlanWithReportTriggerDBItem(p,t) from " + DailyPlanDBItem + " p, " + DBItemReportTrigger + " t " + this.getWhere("p.jobChain") + " and p.reportExecutionId is null   and p.reportTriggerId = t.id  " + this.filter.getOrderCriteria() + this.filter.getSortMode());
        query = this.bindParameters(query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DailyPlanWithReportExecutionDBItem> getDailyPlanListStandalone(int limit) throws SOSHibernateException {
        Query query = this.sosHibernateSession.createQuery("select new com.sos.jitl.dailyplan.db.DailyPlanWithReportExecutionDBItem(p,e) from " + DailyPlanDBItem + " p, " + DBItemReportTask + " e " + this.getWhere("p.job") + " and p.reportExecutionId = e.id   and p.reportTriggerId is null " + this.filter.getOrderCriteria() + this.filter.getSortMode());
        query = this.bindParameters(query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DailyPlanWithReportTriggerDBItem> getWaitingDailyPlanOrderList(int limit) throws SOSHibernateException {
        String q = "from " + DailyPlanDBItem + " p " + this.getWhere("p.jobChain") + " and p.jobChain <> '.' and (p.isAssigned = 0 or p.state = 'PLANNED' or p.state='INCOMPLETE') " + this.filter.getOrderCriteria() + this.filter.getSortMode();
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List l = query.getResultList();
        ArrayList<DailyPlanWithReportTriggerDBItem> resultList = new ArrayList<DailyPlanWithReportTriggerDBItem>();
        for (DailyPlanDBItem d : l) {
            DBItemReportTrigger t = null;
            if (d.getReportTriggerId() != null) {
                ReportTriggerDBLayer triggerDbLayer = new ReportTriggerDBLayer(this.sosHibernateSession);
                t = triggerDbLayer.get(d.getReportTriggerId());
            }
            resultList.add(new DailyPlanWithReportTriggerDBItem(d, t));
        }
        return resultList;
    }

    public List<DailyPlanWithReportExecutionDBItem> getWaitingDailyPlanStandaloneList(int limit) throws SOSHibernateException {
        String q = "from " + DailyPlanDBItem + " p " + this.getWhere("p.job") + " and p.job <> '.' and p.job <> '..'  and (p.isAssigned = 0 or p.state = 'PLANNED' or p.state='INCOMPLETE') " + this.filter.getOrderCriteria() + this.filter.getSortMode();
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List l = this.sosHibernateSession.getResultList(query);
        ArrayList<DailyPlanWithReportExecutionDBItem> resultList = new ArrayList<DailyPlanWithReportExecutionDBItem>();
        for (DailyPlanDBItem d : l) {
            DBItemReportTask t = null;
            if (d.getReportExecutionId() != null) {
                ReportTaskExecutionsDBLayer taskDbLayer = new ReportTaskExecutionsDBLayer(this.sosHibernateSession);
                t = taskDbLayer.get(d.getReportExecutionId());
            }
            resultList.add(new DailyPlanWithReportExecutionDBItem(d, t));
        }
        return resultList;
    }

    public List<DailyPlanDBItem> getDailyPlanList(int limit, boolean onlyWhereAuditLogIdIsNull) throws SOSHibernateException {
        String q = "from " + DailyPlanDBItem + " p " + this.getWhere(onlyWhereAuditLogIdIsNull);
        LOGGER.debug("DailyPlan sql: " + q + " from " + this.filter.getPlannedStartFrom() + " to " + this.filter.getPlannedStartTo());
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DailyPlanDBItem> getDailyPlanListOfOrderSingleStarts() throws SOSHibernateException {
        String q = "from " + DailyPlanDBItem + " p " + this.getWhere() + " and p.jobChain != '.' and p.periodBegin is null and p.state = 'PLANNED'";
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(query);
        return query.getResultList();
    }

    public int updateDailyPlanList(String schedulerId) throws SOSHibernateException {
        String q = "update " + DailyPlanDBItem + " set state='PLANNED', schedulerId=:schedulerId where state='PLANNEDFORUPDATE'";
        Query query = this.sosHibernateSession.createQuery(q);
        query.setParameter("schedulerId", (Object)schedulerId);
        return this.sosHibernateSession.executeUpdate(query);
    }

    public int updateDailyPlanJobStream(String newJobStream) throws SOSHibernateException {
        this.getFilter().setIsJobStream(null);
        String q = "update " + DailyPlanDBItem + " set jobStream=:newJobStream where schedulerId=:schedulerId and jobStream=:jobStream";
        Query query = this.sosHibernateSession.createQuery(q);
        query.setParameter("newJobStream", (Object)newJobStream);
        query.setParameter("jobStream", (Object)this.getFilter().getJobStream());
        query.setParameter("schedulerId", (Object)this.getFilter().getSchedulerId());
        return this.sosHibernateSession.executeUpdate(query);
    }

    public DailyPlanFilter getFilter() {
        return this.filter;
    }

    public void setWhereFrom(Date whereFrom) {
        this.filter.setPlannedStartFrom(whereFrom);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        this.whereFromIso = formatter.format(whereFrom);
    }

    public void setWhereTo(Date whereTo) {
        UtcTimeHelper.convertTimeZonesToDate((String)UtcTimeHelper.localTimeZoneString(), (String)"UTC", (DateTime)new DateTime((Object)whereTo));
        this.filter.setPlannedStartTo(whereTo);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        this.whereToIso = formatter.format(whereTo);
    }

    public void setWhereSchedulerId(String whereschedulerId) {
        this.filter.setSchedulerId(whereschedulerId);
    }

    public void setFilter(DailyPlanFilter filter) {
        this.filter = filter;
    }

    public void onAfterDeleting(DailyPlanDBItem h) {
    }

    public List<DailyPlanDBItem> getListOfItemsToDelete() throws SOSHibernateException {
        TimeZone.setDefault(TimeZone.getTimeZone("Etc/UTC"));
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery("from " + DailyPlanDBItem + " p " + this.getWhere() + this.filter.getOrderCriteria() + this.filter.getSortMode());
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getPlannedStartFrom() != null) {
            query.setParameter("plannedStartFrom", this.filter.getPlannedStartFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getPlannedStartTo() != null) {
            query.setParameter("plannedStartTo", this.filter.getPlannedStartTo(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getJob() != null && !"".equals(this.filter.getJob())) {
            query.setParameter("job", (Object)this.filter.getJob());
        }
        if (this.filter.getJobChain() != null && !"".equals(this.filter.getJobChain())) {
            query.setParameter("jobChain", (Object)this.filter.getJobChain());
        }
        if (this.filter.getOrderId() != null && !"".equals(this.filter.getOrderId())) {
            query.setParameter("orderId", (Object)this.filter.getOrderId());
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public Date getMaxPlannedStart(String schedulerId) {
        String q = "select max(plannedStart) from " + DailyPlanDBItem + " where schedulerId=:schedulerId";
        try {
            Query query = this.sosHibernateSession.createQuery(q);
            query.setParameter("schedulerId", (Object)schedulerId);
            Date d = (Date)this.sosHibernateSession.getSingleValue(query);
            if (d != null) {
                return d;
            }
            return new Date();
        }
        catch (SOSHibernateException e) {
            return new Date();
        }
    }

    public void delete(DailyPlanDBItem dailyPlanDBItem) throws SOSHibernateException {
        this.filter.setPlannedStart(dailyPlanDBItem.getPlannedStart());
        this.filter.setJob(dailyPlanDBItem.getJob());
        this.filter.setJobChain(dailyPlanDBItem.getJobChain());
        this.filter.setOrderId(dailyPlanDBItem.getOrderId());
        this.filter.setSchedulerId(dailyPlanDBItem.getSchedulerId());
        this.delete(false);
    }
}

