/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.dailyplan.db;

import com.sos.hibernate.classes.UtcTimeHelper;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DailyPlanInterval {
    private static final Logger LOGGER = LoggerFactory.getLogger(DailyPlanInterval.class);
    private Date from;
    private Date to;
    private Date convertedFrom;
    private Date convertedTo;

    public DailyPlanInterval(Date from, Date to) {
        this.from = from;
        this.to = to;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public Date getConvertedFrom() {
        if (this.convertedFrom == null) {
            this.convert2Utc();
        }
        return this.convertedFrom;
    }

    public Date getConvertedTo() {
        if (this.convertedTo == null) {
            this.convert2Utc();
        }
        return this.convertedTo;
    }

    private void convert2Utc() {
        String toTimeZoneString = "UTC";
        String fromTimeZoneString = DateTimeZone.getDefault().getID();
        LOGGER.debug("fromTimeZone:" + fromTimeZoneString);
        LOGGER.debug("toTimeZone:" + toTimeZoneString);
        LOGGER.debug("intervall from:" + this.getFrom());
        LOGGER.debug("intervall to:" + this.getTo());
        DateTimeZone toZone = DateTimeZone.forID((String)toTimeZoneString);
        DateTimeZone fromZone = DateTimeZone.forID((String)fromTimeZoneString);
        DateTime utcFrom = new DateTime((Object)this.getFrom()).withZone(toZone);
        DateTime utcTo = new DateTime((Object)this.getTo()).withZone(toZone);
        this.convertedFrom = UtcTimeHelper.convertTimeZonesToDate((String)fromTimeZoneString, (String)toTimeZoneString, (DateTime)utcFrom);
        this.convertedTo = UtcTimeHelper.convertTimeZonesToDate((String)fromTimeZoneString, (String)toTimeZoneString, (DateTime)utcTo);
        LOGGER.debug("converted intervall from:" + this.convertedFrom);
        LOGGER.debug("convertet intervall to:" + this.convertedTo);
    }
}

