/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.dailyplan.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.dailyplan.ExecutionState;
import com.sos.jitl.dailyplan.db.DailyPlanDBItem;
import com.sos.jitl.reporting.db.DBItemReportTask;
import java.util.Date;
import javax.persistence.Transient;

public class DailyPlanWithReportExecutionDBItem
extends DbItem {
    private DailyPlanDBItem dailyPlanDbItem;
    private DBItemReportTask dbItemReportTask;
    private ExecutionState executionState;

    public DailyPlanWithReportExecutionDBItem(DailyPlanDBItem dailyPlanDbItem, DBItemReportTask dbItemReportTask) {
        this.dailyPlanDbItem = dailyPlanDbItem;
        this.dbItemReportTask = dbItemReportTask;
    }

    public DailyPlanDBItem getDailyPlanDbItem() {
        return this.dailyPlanDbItem;
    }

    public void setDailyPlanDbItem(DailyPlanDBItem dailyPlanDbItem) {
        this.dailyPlanDbItem = dailyPlanDbItem;
    }

    public DBItemReportTask getDbItemReportTask() {
        return this.dbItemReportTask;
    }

    public void setDbItemReportExecution(DBItemReportTask dbItemReportTask) {
        this.dbItemReportTask = dbItemReportTask;
    }

    @Transient
    public String getScheduleEndedFormated() {
        if (this.getDbItemReportTask() != null) {
            return this.getDateFormatted(this.getDbItemReportTask().getEndTime());
        }
        return "";
    }

    @Transient
    public Date getEndTimeFromHistory() {
        if (this.getDbItemReportTask() != null) {
            return this.getDbItemReportTask().getEndTime();
        }
        return null;
    }

    @Transient
    public ExecutionState getExecutionState() {
        this.executionState = new ExecutionState();
        Date startTime = null;
        Date endTime = null;
        if (this.dbItemReportTask != null) {
            endTime = this.dbItemReportTask.getEndTime();
            startTime = this.dbItemReportTask.getStartTime();
        }
        this.executionState.setPlannedTime(this.dailyPlanDbItem.getPlannedStart());
        this.executionState.setEndTime(endTime);
        this.executionState.setStartTime(startTime);
        this.executionState.setPeriodBegin(this.dailyPlanDbItem.getPeriodBegin());
        this.executionState.setHaveError(this.haveError());
        return this.executionState;
    }

    @Transient
    public boolean haveError() {
        return this.dbItemReportTask != null && this.dbItemReportTask.haveError();
    }

    @Transient
    public String getDurationFormated() {
        return this.getDateDiff(this.dailyPlanDbItem.getExpectedEnd(), this.getEndTimeFromHistory());
    }

    @Transient
    public boolean isCompleted() {
        return this.dbItemReportTask != null && this.dbItemReportTask.getStartTime() != null && this.dbItemReportTask.getEndTime() != null;
    }

    @Transient
    public Integer getStartMode() {
        if (this.getExecutionState().singleStart()) {
            return 0;
        }
        if (this.dailyPlanDbItem.getStartStart().booleanValue()) {
            return 1;
        }
        return 2;
    }

    @Transient
    public boolean isEqual(DBItemReportTask dbItemReportTask) {
        String job = this.normalizePath(this.dailyPlanDbItem.getJob());
        String job2 = this.normalizePath(dbItemReportTask.getName());
        return (this.dailyPlanDbItem.getPlannedStart().equals(dbItemReportTask.getStartTime()) || this.dailyPlanDbItem.getPlannedStart().before(dbItemReportTask.getStartTime())) && job.equalsIgnoreCase(job2);
    }

    @Transient
    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }
}

