/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.dailyplan.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.dailyplan.ExecutionState;
import com.sos.jitl.dailyplan.db.DailyPlanDBItem;
import com.sos.jitl.reporting.db.DBItemReportTrigger;
import java.util.Date;
import javax.persistence.Transient;

public class DailyPlanWithReportTriggerDBItem
extends DbItem {
    private DailyPlanDBItem dailyPlanDbItem;
    private DBItemReportTrigger dbItemReportTrigger;
    private ExecutionState executionState;

    public DailyPlanWithReportTriggerDBItem(DailyPlanDBItem dailyPlanDbItem, DBItemReportTrigger dbItemReportTrigger) {
        this.dailyPlanDbItem = dailyPlanDbItem;
        this.dbItemReportTrigger = dbItemReportTrigger;
    }

    public DBItemReportTrigger getDbItemReportTrigger() {
        return this.dbItemReportTrigger;
    }

    public void setDbItemReportTrigger(DBItemReportTrigger dbItemReportTrigger) {
        this.dbItemReportTrigger = dbItemReportTrigger;
    }

    public DailyPlanDBItem getDailyPlanDbItem() {
        return this.dailyPlanDbItem;
    }

    public void setDailyPlanDbItem(DailyPlanDBItem dailyPlanDbItem) {
        this.dailyPlanDbItem = dailyPlanDbItem;
    }

    @Transient
    public String getScheduleEndedFormated() {
        if (this.getDbItemReportTrigger() != null) {
            return this.getDateFormatted(this.getDbItemReportTrigger().getEndTime());
        }
        return "";
    }

    @Transient
    public Date getEndTimeFromHistory() {
        if (this.getDbItemReportTrigger() != null) {
            return this.getDbItemReportTrigger().getEndTime();
        }
        return null;
    }

    @Transient
    public ExecutionState getExecutionState() {
        if (this.executionState != null) {
            return this.executionState;
        }
        this.executionState = new ExecutionState();
        Date startTime = null;
        Date endTime = null;
        if (this.dbItemReportTrigger != null) {
            endTime = this.dbItemReportTrigger.getEndTime();
            startTime = this.dbItemReportTrigger.getStartTime();
        }
        this.executionState.setPlannedTime(this.dailyPlanDbItem.getPlannedStart());
        this.executionState.setEndTime(endTime);
        this.executionState.setStartTime(startTime);
        this.executionState.setPeriodBegin(this.dailyPlanDbItem.getPeriodBegin());
        this.executionState.setHaveError(this.haveError());
        return this.executionState;
    }

    @Transient
    public boolean haveError() {
        return this.dbItemReportTrigger != null && this.dbItemReportTrigger.getResultError();
    }

    @Transient
    public String getDurationFormated() {
        return this.getDateDiff(this.dailyPlanDbItem.getExpectedEnd(), this.getEndTimeFromHistory());
    }

    @Transient
    public boolean isCompleted() {
        return this.dbItemReportTrigger != null && this.dbItemReportTrigger.getStartTime() != null && this.dbItemReportTrigger.getEndTime() != null;
    }

    @Transient
    public Integer getStartMode() {
        if (this.getExecutionState().singleStart()) {
            return 0;
        }
        if (this.dailyPlanDbItem.getStartStart().booleanValue()) {
            return 1;
        }
        return 2;
    }

    @Transient
    public boolean isEqual(DBItemReportTrigger dbItemReportTrigger) {
        String job_chain = this.dailyPlanDbItem.getJobChain().replaceAll("^/", "");
        String job_chain2 = dbItemReportTrigger.getParentName().replaceAll("^/", "");
        return (this.dailyPlanDbItem.getPlannedStart().equals(dbItemReportTrigger.getStartTime()) || this.dailyPlanDbItem.getPlannedStart().before(dbItemReportTrigger.getStartTime())) && job_chain.equalsIgnoreCase(job_chain2) && this.dailyPlanDbItem.getOrderId().equalsIgnoreCase(dbItemReportTrigger.getName());
    }

    @Transient
    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }
}

