/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.dailyplan.job;

import com.sos.JSHelper.Basics.IJSCommands;
import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.dailyplan.db.Calendar2DB;
import com.sos.jitl.dailyplan.job.CheckDailyPlanOptions;
import com.sos.jitl.dailyplan.job.CreateDailyPlanOptions;
import com.sos.jitl.reporting.db.DBLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import sos.spooler.Spooler;

public class CreateDailyPlan
extends JSJobUtilitiesClass<CreateDailyPlanOptions>
implements IJSCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateDailyPlan.class);
    protected CreateDailyPlanOptions createDailyPlanOptions;
    protected CheckDailyPlanOptions checkDailyPlanOptions;
    private Spooler spooler;
    private String schedulerId;

    public CreateDailyPlan() {
        super((Object)new CreateDailyPlanOptions());
    }

    public CreateDailyPlanOptions getOptions() {
        if (this.createDailyPlanOptions == null) {
            this.createDailyPlanOptions = new CreateDailyPlanOptions();
            this.checkDailyPlanOptions = new CheckDailyPlanOptions();
        }
        return this.createDailyPlanOptions;
    }

    private SOSHibernateSession getSession(String confFile) throws Exception {
        SOSHibernateFactory sosHibernateFactory = new SOSHibernateFactory(confFile);
        sosHibernateFactory.addClassMapping(DBLayer.getReportingClassMapping());
        sosHibernateFactory.addClassMapping(DBLayer.getJobStreamClassMapping());
        sosHibernateFactory.build();
        return sosHibernateFactory.openStatelessSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateDailyPlan Execute() throws Exception {
        this.getOptions().checkMandatory();
        LOGGER.debug(this.getOptions().dirtyString());
        SOSHibernateSession session = this.getSession(this.createDailyPlanOptions.getconfiguration_file().getValue());
        MDC.put((String)"plugin", (String)"dailyplan");
        Calendar2DB calendar2Db = new Calendar2DB(session, this.schedulerId);
        calendar2Db.setOptions(this.createDailyPlanOptions);
        calendar2Db.setSpooler(this.spooler);
        try {
            calendar2Db.store();
            CreateDailyPlan createDailyPlan = this;
            return createDailyPlan;
        }
        finally {
            if (session != null) {
                SOSHibernateFactory factory = session.getFactory();
                session.close();
                factory.close();
            }
            MDC.remove((String)"plugin");
        }
    }

    public void setSpooler(Spooler spooler) {
        this.spooler = spooler;
    }

    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }
}

