/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventhandler.handler;

import com.sos.jitl.eventhandler.EventMeta;
import com.sos.jitl.eventhandler.handler.EventHandler;
import com.sos.jitl.eventhandler.handler.EventHandlerSettings;
import com.sos.jitl.eventhandler.handler.ILoopEventHandler;
import com.sos.jitl.eventhandler.http.HttpClient;
import com.sos.jitl.eventhandler.plugin.notifier.Notifier;
import com.sos.scheduler.engine.data.events.custom.VariablesCustomEvent;
import com.sos.scheduler.engine.eventbus.EventPublisher;
import com.sos.scheduler.engine.kernel.scheduler.SchedulerXmlCommandExecutor;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoopEventHandler
extends EventHandler
implements ILoopEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoopEventHandler.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final int MAX_RERUNS_ON_GET_START_EVENT_ID = 10;
    private final SchedulerXmlCommandExecutor xmlCommandExecutor;
    private final EventPublisher publisher;
    private EventHandlerSettings settings;
    private Notifier notifier;
    private boolean closed = false;
    private EventMeta.EventType[] eventTypes;
    private String eventTypesJoined;
    private Map<String, Map<String, String>> customEvents;
    private Long tornEventId = null;
    private String pathForStartEventId = "/not_exists/";
    private int waitIntervalOnError = 30;

    public LoopEventHandler() {
        this(null, null);
    }

    public LoopEventHandler(SchedulerXmlCommandExecutor commandExecutor, EventPublisher eventPublisher) {
        this.xmlCommandExecutor = commandExecutor;
        this.publisher = eventPublisher;
        this.customEvents = new HashMap<String, Map<String, String>>();
    }

    @Override
    public void onPrepare(EventHandlerSettings settings) {
        this.setSettings(settings);
    }

    @Override
    public void onActivate(Notifier pluginNotifier) {
        this.closed = false;
        this.notifier = pluginNotifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.closed = true;
        this.getHttpClient().close();
        HttpClient httpClient = this.getHttpClient();
        synchronized (httpClient) {
            this.getHttpClient().notifyAll();
        }
    }

    public void start(EventMeta.EventType[] types) {
        String method = this.getMethodName("start");
        if (types == null || types.length == 0) {
            LOGGER.error(String.format("%s[processing stopped]event types are NULL or empty", method));
            return;
        }
        this.eventTypes = types;
        this.eventTypesJoined = this.getEventTypes(this.eventTypes);
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[eventTypes=%s]", method, this.eventTypesJoined));
        }
        Long eventId = null;
        try {
            eventId = this.getStartEventId();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s[processing stopped]%s", method, e.toString()), (Throwable)e);
            if (this.notifier != null) {
                this.notifier.notifyOnError("start", String.format("%s processing stopped", method), e);
            }
            this.closed = true;
        }
        if (!this.closed) {
            if (eventId == null) {
                EventMeta.EventOverview overview = this.getEventOverviewByEventTypes(types);
                EventMeta.EventPath path = this.getEventPathByEventOverview(overview);
                try {
                    eventId = this.getStartEventIdFromOverview(path, overview, this.pathForStartEventId);
                }
                catch (Exception e) {
                    eventId = this.rerunGetStartEventIdFromOverview(method, e, path, overview, this.pathForStartEventId);
                }
            }
            if (!this.closed) {
                this.onProcessingStart(eventId);
                eventId = this.doProcessing(eventId);
                this.onProcessingEnd(eventId);
            }
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[end]%s", method, eventId));
        }
    }

    private Long getStartEventId() throws Exception {
        String method = "getStartEventId";
        int count = 0;
        boolean run = true;
        Long eventId = null;
        while (run) {
            ++count;
            if (this.closed) {
                return null;
            }
            try {
                eventId = this.onGetStartEventId();
                run = false;
                if (!isDebugEnabled) continue;
                LOGGER.debug(String.format("%s%s", this.getMethodName(method), eventId));
            }
            catch (Throwable e) {
                if (count >= 10) {
                    run = false;
                    throw new Exception(String.format("%s[exception %s of %s]%s", this.getMethodName(method), count, 10, e.toString()), e);
                }
                LOGGER.error(String.format("%s[%s]%s", this.getMethodName(method), count, e.toString()), e);
                if (this.notifier != null) {
                    this.notifier.smartNotifyOnError(this.getClass(), String.format("%s[%s]", this.getMethodName(method), count), e);
                }
                this.wait(this.waitIntervalOnError);
            }
        }
        return eventId;
    }

    @Override
    public Long onGetStartEventId() throws Exception {
        return null;
    }

    @Override
    public void onProcessingStart(Long eventId) {
    }

    private Long doProcessing(Long eventId) {
        String method = this.getMethodName("doProcessing");
        while (!this.closed) {
            try {
                eventId = this.process(eventId);
            }
            catch (Throwable ex) {
                if (this.closed) {
                    LOGGER.info(String.format("%s[%s][processing stopped][exception ignored]%s", method, eventId, ex.toString()));
                    continue;
                }
                LOGGER.error(String.format("%s[%s][exception]%s", method, eventId, ex.toString()), ex);
                this.getHttpClient().close();
                if (this.tornEventId != null) {
                    eventId = this.tornEventId;
                }
                this.wait(this.waitIntervalOnError);
            }
        }
        return eventId;
    }

    @Override
    public void onProcessingEnd(Long eventId) {
    }

    @Override
    public void onEmptyEvent(Long eventId) {
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s%s", this.getMethodName("onEmptyEvent"), eventId));
        }
    }

    @Override
    public void onNonEmptyEvent(Long eventId, JsonArray events) {
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s%s", this.getMethodName("onNonEmptyEvent"), eventId));
        }
    }

    @Override
    public void onTornEvent(Long eventId, JsonArray events) {
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s%s", this.getMethodName("onTornEvent"), eventId));
        }
    }

    @Override
    public void onRestart(Long eventId, JsonArray events) {
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s%s", this.getMethodName("onRestart"), eventId));
        }
    }

    private Long getStartEventIdFromOverview(EventMeta.EventPath path, EventMeta.EventOverview overview, String pathForStartEventId) throws Exception {
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[eventPath=%s][eventOverview=%s][pathForStartEventId=%s]", new Object[]{this.getMethodName("getStartEventIdFromOverview"), path, overview, pathForStartEventId}));
        }
        this.customEvents.clear();
        this.getHttpClient().tryCreate();
        return this.getEventId(this.getOverview(path, overview, pathForStartEventId));
    }

    private Long rerunGetStartEventIdFromOverview(String callerMethod, Exception ex, EventMeta.EventPath path, EventMeta.EventOverview overview, String pathForStartEventId) {
        String method = this.getMethodName("rerunGetStartEventIdFromOverview");
        if (this.closed) {
            LOGGER.info(String.format("%s[processing stopped]", method));
            return null;
        }
        if (ex != null) {
            LOGGER.error(String.format("%s[error on %s]%s", method, callerMethod, ex.toString()), (Throwable)ex);
            this.getHttpClient().close();
        }
        LOGGER.debug(method);
        this.wait(this.waitIntervalOnError);
        Long eventId = null;
        try {
            eventId = this.getStartEventIdFromOverview(path, overview, pathForStartEventId);
        }
        catch (Exception e) {
            eventId = this.rerunGetStartEventIdFromOverview(method, e, path, overview, pathForStartEventId);
        }
        return eventId;
    }

    private Long process(Long eventId) throws Exception {
        String method = this.getMethodName("process");
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s%s", method, eventId));
        }
        this.customEvents.clear();
        this.getHttpClient().tryCreate();
        JsonObject result = this.getEvents(eventId, this.eventTypesJoined);
        Long newEventId = this.getEventId(result);
        if (this.closed) {
            LOGGER.info(String.format("%s[processing stopped][eventId=%s][newEventId=%s]", method, eventId, newEventId));
            return eventId;
        }
        String type = this.getEventType(result);
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[new][%s][%s]", method, newEventId, type));
        }
        JsonArray events = this.getEventSnapshots(result);
        if (type.equalsIgnoreCase(EventMeta.EventSeq.NonEmpty.name())) {
            this.tornEventId = null;
            this.onNonEmptyEvent(newEventId, events);
        } else if (type.equalsIgnoreCase(EventMeta.EventSeq.Empty.name())) {
            this.tornEventId = null;
            this.onEmptyEvent(newEventId);
        } else {
            if (type.equalsIgnoreCase(EventMeta.EventSeq.Torn.name())) {
                this.tornEventId = newEventId;
                this.onTornEvent(newEventId, events);
                throw new Exception(String.format("%s[Torn event occured]Try to retry events ...", method));
            }
            throw new Exception(String.format("%s[unknown event type]%s", method, type));
        }
        return newEventId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(int interval) {
        if (!this.closed && interval > 0) {
            String method = this.getMethodName("wait");
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s%ss ...", method, interval));
            }
            try {
                HttpClient httpClient = this.getHttpClient();
                synchronized (httpClient) {
                    this.getHttpClient().wait(interval * 1000);
                }
            }
            catch (InterruptedException e) {
                if (this.closed) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("%s[processing stopped]sleep interrupted due close", method));
                    }
                }
                LOGGER.warn(String.format("%s%s", method, e.toString()), (Throwable)e);
            }
        }
    }

    public void addCustomEventValue(String eventKey, String valueKey, String value) {
        if (isDebugEnabled) {
            String method = this.getMethodName("addCustomEventValue");
            LOGGER.debug(String.format("%s[eventKey=%s][valueKey=%s][value=%s]", method, eventKey, valueKey, value));
        }
        Map<String, String> values = null;
        values = this.customEvents.containsKey(eventKey) ? this.customEvents.get(eventKey) : new HashMap<String, String>();
        values.put(valueKey, value);
        this.customEvents.put(eventKey, values);
    }

    public void publishCustomEvent(String eventKey, String valueKey, String value) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(valueKey, value);
        this.publishCustomEvent(eventKey, values);
    }

    public void publishCustomEvent(String eventKey, Map<String, String> values) {
        String method = this.getMethodName("publishCustomEvent");
        try {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[eventKey=%s][values=%s]", method, eventKey, values));
                if (this.closed) {
                    LOGGER.debug(String.format("%s[skip]processing stopped", method));
                }
            }
            if (this.publisher != null && !this.closed) {
                this.publisher.publishCustomEvent(VariablesCustomEvent.keyed((String)eventKey, values));
            }
        }
        catch (Throwable e) {
            LOGGER.warn(String.format("%s%s", method, e.toString()), e);
        }
    }

    public void publishCustomEvents() {
        String method = this.getMethodName("publishCustomEvents");
        try {
            if (this.customEvents == null) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%scustomEvents is null", method));
                }
            } else {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%scustomEvents=%s", method, this.customEvents));
                    if (this.closed) {
                        LOGGER.debug(String.format("%s[skip]processing stopped", method));
                    }
                }
                if (this.publisher != null && !this.closed) {
                    for (String eventKey : this.customEvents.keySet()) {
                        this.publisher.publishCustomEvent(VariablesCustomEvent.keyed((String)eventKey, this.customEvents.get(eventKey)));
                    }
                }
                this.customEvents.clear();
            }
        }
        catch (Throwable e) {
            LOGGER.warn(String.format("%s%s", method, e.toString()), e);
        }
    }

    public Map<String, Map<String, String>> getCustomEvents() {
        return this.customEvents;
    }

    public SchedulerXmlCommandExecutor getXmlCommandExecutor() {
        return this.xmlCommandExecutor;
    }

    public EventPublisher getEventPublisher() {
        return this.publisher;
    }

    @Override
    public void setSettings(EventHandlerSettings st) {
        this.settings = st;
        this.setBaseUrl(st.getHttpHost(), this.settings.getHttpPort());
    }

    @Override
    public EventHandlerSettings getSettings() {
        return this.settings;
    }

    public String getPathForStartEventId() {
        return this.pathForStartEventId;
    }

    public void setPathForStartEventId(String val) {
        this.pathForStartEventId = val;
    }

    public int getWaitIntervalOnError() {
        return this.waitIntervalOnError;
    }

    public void setWaitIntervalOnError(int val) {
        this.waitIntervalOnError = val;
    }

    public String getEventTypesJoined() {
        return this.eventTypesJoined;
    }

    public EventMeta.EventType[] getEventTypes() {
        return this.eventTypes;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }
}

