/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventhandler.plugin.notifier;

import com.google.common.base.Throwables;
import com.sos.JSHelper.interfaces.ISOSSmtpMailOptions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMail;
import sos.net.mail.options.SOSSmtpMailOptions;
import sos.util.SOSDate;
import sos.util.SOSString;

public class Mailer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mailer.class);
    public static final String NEW_LINE = "\r\n";
    private SOSSmtpMailOptions options = null;
    private Map<String, String> settings = null;
    private String pluginName;
    private boolean sendOnError = false;
    private boolean sendOnWarning = false;
    private boolean queueOnly = false;

    public Mailer(String pluginName, Map<String, String> ms) {
        this.settings = ms;
        this.init(pluginName);
    }

    private void init(String name) {
        this.pluginName = name;
        this.sendOnError = false;
        this.sendOnWarning = false;
        if (this.settings == null || SOSString.isEmpty((String)this.settings.get("smtp")) || SOSString.isEmpty((String)this.settings.get("from")) || SOSString.isEmpty((String)this.settings.get("to"))) {
            return;
        }
        SOSDate.setDateTimeFormat((String)"yyyy-MM-dd HH:mm:ss.SSS");
        try {
            this.options = new SOSSmtpMailOptions();
            this.options.host.setValue(this.settings.get("smtp"));
            this.options.port.setValue(this.settings.get("mail.smtp.port"));
            this.options.smtp_user.setValue(this.settings.get("mail.smtp.user"));
            this.options.smtp_password.setValue(this.settings.get("mail.smtp.password"));
            this.options.queue_directory.setValue(this.settings.get("queue_dir"));
            this.options.from.setValue(this.settings.get("from"));
            this.options.from_name.setValue(this.settings.get("from_name"));
            this.options.to.setValue(this.settings.get("to"));
            this.options.cc.setValue(this.settings.get("cc"));
            this.options.bcc.setValue(this.settings.get("bcc"));
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            this.options = null;
            return;
        }
        try {
            this.sendOnError = this.settings.get("mail_on_error").equals("1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sendOnWarning = this.settings.get("mail_on_warning").equals("1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.queueOnly = this.settings.get("queue_only").equals("1");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendOnError(String callerClass, String callerMethod, String body) {
        if (this.sendOnError) {
            this.send("ERROR", String.format("[error] Plugin %s, %s.%s processed with errors", this.pluginName, callerClass, callerMethod), null, body);
        }
    }

    public void sendOnError(String callerClass, String callerMethod, Throwable t) {
        this.sendOnError(callerClass, callerMethod, null, t);
    }

    public void sendOnError(String callerClass, String callerMethod, String bodyPart, Throwable t) {
        if (this.sendOnError) {
            this.send("ERROR", String.format("[error] Plugin %s, %s.%s processed with errors", this.pluginName, callerClass, callerMethod), bodyPart, this.getStackTrace(t));
        }
    }

    public void sendOnWarning(String callerClass, String callerMethod, String body) {
        if (this.sendOnWarning) {
            this.send("WARNING", String.format("[warn] Plugin %s, %s.%s processed with warnings", this.pluginName, callerClass, callerMethod), null, body);
        }
    }

    public void sendOnWarning(String callerClass, String callerMethod, Throwable t) {
        if (this.sendOnWarning) {
            this.send("WARNING", String.format("[warn] Plugin %s, %s.%s processed with warnings", this.pluginName, callerClass, callerMethod), null, this.getStackTrace(t));
        }
    }

    public void sendOnWarning(String callerClass, String callerMethod, String bodyPart, Throwable t) {
        if (this.sendOnWarning) {
            this.send("WARNING", String.format("[warn] Plugin %s, %s.%s processed with warnings", this.pluginName, callerClass, callerMethod), bodyPart, this.getStackTrace(t));
        }
    }

    public void sendOnRecovery(String callerClass, String callerMethod, Throwable t) {
        if (this.sendOnError || this.sendOnWarning) {
            this.send("RECOVERY", String.format("[recovery] Plugin %s, %s.%s recovered from previous error", this.pluginName, callerClass, callerMethod), null, this.getStackTrace(t));
        }
    }

    private String getStackTrace(Throwable t) {
        return t == null ? "null" : Throwables.getStackTraceAsString((Throwable)t);
    }

    private void send(String range, String subject, String bodyPart, String body) {
        try {
            this.options.subject.setValue(subject);
            StringBuilder sb = new StringBuilder();
            sb.append(SOSDate.getCurrentTimeAsString());
            sb.append("Z ");
            sb.append(String.format(this.options.from_name.getValue(), new Object[0]));
            sb.append(String.format("%s%s", NEW_LINE, NEW_LINE));
            sb.append(String.format("Plugin %s", this.pluginName));
            sb.append(String.format("%s%s", NEW_LINE, NEW_LINE));
            sb.append(String.format("%s ", range));
            if (!SOSString.isEmpty((String)bodyPart)) {
                sb.append(String.format("%s", NEW_LINE));
                sb.append(bodyPart);
                sb.append(String.format("%s", NEW_LINE));
            }
            sb.append(body);
            sb.append(String.format("%s%s%s", NEW_LINE, NEW_LINE, NEW_LINE));
            sb.append("Please refer to the scheduler.log");
            this.options.body.setValue(sb.toString());
            SOSMail mail = new SOSMail(this.options.host.getValue());
            mail.sendMail((ISOSSmtpMailOptions)this.options, this.queueOnly, false);
        }
        catch (Throwable e) {
            LOGGER.error(String.format(e.toString(), new Object[0]), e);
        }
    }

    public String getPluginName() {
        return this.pluginName;
    }
}

