/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventing;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionTime;
import com.sos.jitl.eventing.JSEventsClientOptions;
import com.sos.scheduler.messages.JSMessages;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sos.scheduler.command.SOSSchedulerCommand;
import sos.xml.SOSXMLTransformer;
import sos.xml.SOSXMLXPath;

public class JSEventsClient
extends JSJobUtilitiesClass<JSEventsClientOptions> {
    private final String conClassName = ((Object)((Object)this)).getClass().getSimpleName();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String conSVNVersion = "$Id: JSEventsClient.java 18220 2012-10-18 07:46:10Z kb $";
    private final HashMap<String, String> eventParameters = new HashMap();

    public JSEventsClient() {
        super((Object)new JSEventsClientOptions());
        this.getOptions();
    }

    public JSEventsClientOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new JSEventsClientOptions();
        }
        return (JSEventsClientOptions)((Object)this.objOptions);
    }

    public JSEventsClient execute() throws Exception {
        String conMethodName = this.conClassName + "::Execute";
        this.logger.debug(JSMessages.JSJ_I_110.get(new Object[]{conMethodName}));
        this.logger.debug("$Id: JSEventsClient.java 18220 2012-10-18 07:46:10Z kb $");
        try {
            this.getOptions().checkMandatory();
            this.logger.debug(this.getOptions().dirtyString());
            try {
                String addOrder;
                String[] strA;
                if (((JSEventsClientOptions)((Object)this.objOptions)).EventParameter.isDirty()) {
                    this.eventParameters.put(((JSEventsClientOptions)((Object)this.objOptions)).EventParameter.getShortKey(), ((JSEventsClientOptions)((Object)this.objOptions)).EventParameter.getValue());
                    String[] strEP = ((JSEventsClientOptions)((Object)this.objOptions)).EventParameter.getValue().split(";");
                    HashMap objH = ((JSEventsClientOptions)((Object)this.objOptions)).getSettings();
                    for (String strParamName : strEP) {
                        String strValue = (String)objH.get(strParamName = strParamName.trim());
                        if (strValue == null) continue;
                        this.eventParameters.put(strParamName, strValue.trim());
                    }
                }
                String action = ((JSEventsClientOptions)((Object)this.objOptions)).scheduler_event_action.getValue();
                String strEventIDs = ((JSEventsClientOptions)((Object)this.objOptions)).id.getValue();
                if (strEventIDs.length() > 0) {
                    for (String strEventID : strA = ((JSEventsClientOptions)((Object)this.objOptions)).id.getValue().split(";")) {
                        strEventID = strEventID.trim();
                        addOrder = this.createAddOrder(action, strEventID, this.eventParameters);
                        this.submitToSupervisor(addOrder);
                    }
                }
                if (((JSEventsClientOptions)((Object)this.objOptions)).del_events.isDirty()) {
                    strA = ((JSEventsClientOptions)((Object)this.objOptions)).del_events.getValue().split(";");
                    action = "remove";
                    for (String strEventID : strA) {
                        addOrder = this.createAddOrder(action, strEventID.trim(), this.eventParameters);
                        this.submitToSupervisor(addOrder);
                    }
                }
            }
            catch (Exception e) {
                throw new JobSchedulerException("Error submitting event order: " + e, (Throwable)e);
            }
        }
        catch (Exception e) {
            try {
                String strM = JSMessages.JSJ_F_107.get(new Object[]{conMethodName});
                throw new JobSchedulerException(strM, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.logger.debug(JSMessages.JSJ_I_111.get(new Object[]{conMethodName}));
                throw throwable;
            }
        }
        this.logger.debug(JSMessages.JSJ_I_111.get(new Object[]{conMethodName}));
        return this;
    }

    private String createAddOrder(String action, String eventId, Map<String, String> eventParameters1) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document addOrderDocument = docBuilder.newDocument();
            Element addOrderElement = addOrderDocument.createElement("add_order");
            addOrderDocument.appendChild(addOrderElement);
            addOrderElement.setAttribute("job_chain", ((JSEventsClientOptions)((Object)this.objOptions)).supervisor_job_chain.getValue());
            Element paramsElement = addOrderDocument.createElement("params");
            addOrderElement.appendChild(paramsElement);
            this.addParam(paramsElement, "action", action);
            this.addParam(paramsElement, "event_id", eventId);
            this.addParam(paramsElement, "remote_scheduler_host", ((JSEventsClientOptions)((Object)this.objOptions)).scheduler_event_handler_host.getValue());
            this.addParam(paramsElement, "remote_scheduler_port", ((JSEventsClientOptions)((Object)this.objOptions)).scheduler_event_handler_port.getValue());
            this.addParam(paramsElement, "job_chain", ((JSEventsClientOptions)((Object)this.objOptions)).supervisor_job_chain.getValue());
            String orderId = "";
            String jobName = "";
            this.addParam(paramsElement, "order_id", orderId);
            this.addParam(paramsElement, "job_name", jobName);
            this.addParam(paramsElement, "event_class", ((JSEventsClientOptions)((Object)this.objOptions)).EventClass.getValue());
            this.addParam(paramsElement, "exit_code", ((JSEventsClientOptions)((Object)this.objOptions)).scheduler_event_exit_code.getValue());
            this.addParam(paramsElement, "created", SOSOptionTime.getCurrentTimeAsString());
            this.addParam(paramsElement, "expires", ((JSEventsClientOptions)((Object)this.objOptions)).scheduler_event_expires.getValue());
            for (Map.Entry<String, String> entry : eventParameters1.entrySet()) {
                this.addParam(paramsElement, entry.getKey(), entry.getValue());
            }
            return SOSXMLTransformer.docToString((Document)addOrderDocument, (String)"iso-8859-1");
        }
        catch (Exception e) {
            throw new JobSchedulerException("Error creating add_order xml: " + e, (Throwable)e);
        }
    }

    private void addParam(Element paramsElement, String name, String value) {
        if (value != null && value.length() > 0) {
            Element paramElement = paramsElement.getOwnerDocument().createElement("param");
            paramElement.setAttribute("name", name);
            paramElement.setAttribute("value", value);
            paramsElement.appendChild(paramElement);
        }
    }

    private void submitToSupervisor(String xml) throws Exception {
        try {
            SOSXMLXPath xAnswer;
            String errorText;
            if (xml.indexOf("<?xml") == -1) {
                xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xml;
            }
            this.logger.debug("Sending add_order to the EventService:\n" + xml);
            String answer = null;
            if (((JSEventsClientOptions)((Object)this.objOptions)).scheduler_event_handler_host.isDirty() && ((JSEventsClientOptions)((Object)this.objOptions)).scheduler_event_handler_port.value() > 0) {
                SOSSchedulerCommand schedulerCommand = new SOSSchedulerCommand();
                schedulerCommand.setHost(((JSEventsClientOptions)((Object)this.objOptions)).scheduler_event_handler_host.getValue());
                schedulerCommand.setPort(((JSEventsClientOptions)((Object)this.objOptions)).scheduler_event_handler_port.value());
                schedulerCommand.setProtocol("tcp");
                this.logger.debug(".. connecting to EventService " + schedulerCommand.getHost() + ":" + schedulerCommand.getPort());
                schedulerCommand.connect();
                schedulerCommand.sendRequest(xml);
                answer = schedulerCommand.getResponse();
                this.logger.debug(answer.replaceAll(Pattern.quote("\n"), ""));
            } else {
                this.logger.info("No supervisor configured, submitting event to this JobScheduler.");
                answer = this.objJSCommands.executeXML(xml);
            }
            if (answer != null && answer.length() > 0 && (errorText = (xAnswer = new SOSXMLXPath(new StringBuffer(answer))).selectSingleNodeValue("//ERROR/@text")) != null && errorText.length() > 0) {
                throw new JobSchedulerException("EventService returned an error: " + errorText);
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException("Failed to submit event: " + e, (Throwable)e);
        }
    }
}

