/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventing.db;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sos.classes.CustomEventsUtil;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.classes.SearchStringHelper;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.layer.SOSHibernateDBLayer;
import com.sos.jitl.eventing.db.SchedulerEventDBItem;
import com.sos.jitl.eventing.db.SchedulerEventFilter;
import com.sos.jitl.eventing.evaluate.BooleanExp;
import com.sos.joc.model.order.OrderPath;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.TemporalType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import sos.scheduler.job.JobSchedulerEventJob;

public class SchedulerEventDBLayer
extends SOSHibernateDBLayer {
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerEventDBLayer.class);
    private static final String SchedulerEventDBItem = SchedulerEventDBItem.class.getName();
    private String notifyCommand;

    public SchedulerEventDBLayer(String configurationFilename) throws Exception {
        this.setConfigurationFileName(configurationFilename);
        this.createStatefullConnection(this.getConfigurationFileName());
    }

    public SchedulerEventDBLayer(SOSHibernateSession session) throws Exception {
        this.setConfigurationFileName(((Path)session.getFactory().getConfigFile().get()).toFile().getAbsolutePath());
        this.sosHibernateSession = session;
    }

    public void beginTransaction() throws Exception {
        this.sosHibernateSession.beginTransaction();
    }

    public void rollback() throws Exception {
        try {
            this.sosHibernateSession.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit() throws Exception {
        this.sosHibernateSession.commit();
    }

    public SchedulerEventDBItem getEvent(Long id) throws Exception {
        if (this.sosHibernateSession == null) {
            this.createStatefullConnection(this.getConfigurationFileName());
        }
        return (SchedulerEventDBItem)((Object)this.sosHibernateSession.get(SchedulerEventDBItem.class, (Serializable)id));
    }

    private Query<SchedulerEventDBItem> bindParameters(String hql, SchedulerEventFilter filter) throws SOSHibernateException {
        Query query = this.sosHibernateSession.createQuery(hql);
        if (filter.hasExitCodes()) {
            query.setParameterList("exitCode", filter.getListOfExitCodes());
        }
        if (filter.hasIds()) {
            query.setParameterList("ids", filter.getListOfIds());
        }
        if (filter.getSchedulerId() != null && !filter.getSchedulerId().isEmpty()) {
            query.setParameter("schedulerId", (Object)filter.getSchedulerId());
        }
        if (filter.getRemoteUrl() != null && !filter.getRemoteUrl().isEmpty()) {
            query.setParameter("remoteUrl", (Object)filter.getRemoteUrl());
        }
        if (filter.getRemoteSchedulerHost() != null && !filter.getRemoteSchedulerHost().isEmpty()) {
            query.setParameter("remoteSchedulerHost", (Object)filter.getRemoteSchedulerHost());
        }
        if (filter.getRemoteSchedulerPort() != null) {
            query.setParameter("remoteSchedulerPort", (Object)filter.getRemoteSchedulerPort());
        }
        if (filter.getJobChain() != null && !filter.getJobChain().isEmpty()) {
            query.setParameter("jobChain", (Object)SearchStringHelper.getSearchPathValue((String)filter.getJobChain()));
        }
        if (filter.getOrderId() != null && !filter.getOrderId().isEmpty()) {
            query.setParameter("orderId", (Object)filter.getOrderId());
        }
        if (filter.getJobName() != null && !filter.getJobName().isEmpty()) {
            query.setParameter("jobName", (Object)SearchStringHelper.getSearchPathValue((String)filter.getJobName()));
        }
        if (filter.getEventClass() != null && !filter.getEventClass().isEmpty()) {
            query.setParameter("eventClass", (Object)filter.getEventClass());
        }
        if (filter.getEventId() != null && !filter.getEventId().isEmpty()) {
            query.setParameter("eventId", (Object)filter.getEventId());
        }
        if (filter.getExitCode() != null) {
            query.setParameter("exitCode", (Object)filter.getExitCode());
        }
        if (filter.getExpiresFrom() != null) {
            query.setParameter("expiresFrom", filter.getExpiresFrom(), TemporalType.TIMESTAMP);
        }
        if (filter.getExpiresTo() != null) {
            query.setParameter("expiresTo", filter.getExpiresTo(), TemporalType.TIMESTAMP);
        }
        return query;
    }

    public int delete(SchedulerEventFilter filter) throws Exception {
        int row = 0;
        String hql = "delete from " + SchedulerEventDBItem + " " + this.getWhere(filter);
        LOGGER.debug("delete:" + hql);
        Query<SchedulerEventDBItem> query = this.bindParameters(hql, filter);
        row = this.sosHibernateSession.executeUpdate(query);
        this.notifyWebservices(REMOVE);
        return row;
    }

    private String getOrderClause(OrderPath order) {
        if (order.getOrderId() == null || order.getOrderId().isEmpty()) {
            return "(jobChain='" + order.getJobChain() + "')";
        }
        if (order.getJobChain() == null || order.getJobChain().isEmpty()) {
            return "(orderId='" + order.getOrderId() + "')";
        }
        return "(orderId = '" + order.getOrderId() + "' and jobChain='" + order.getJobChain() + "')";
    }

    private String getWhere(SchedulerEventFilter filter) {
        String where = "";
        String and = "";
        if (filter.hasIds()) {
            where = where + and + " id in ( :ids )";
            and = " and ";
        }
        if (filter.hasEventIds()) {
            where = where + and + SearchStringHelper.getStringListSql(filter.getListOfEventIds(), (String)"eventId");
            and = " and ";
        }
        if (filter.hasJobs()) {
            where = where + and + SearchStringHelper.getStringListPathSql(filter.getListOfJobNames(), (String)"jobName");
            and = " and ";
        }
        if (filter.hasEventClasses()) {
            where = where + and + SearchStringHelper.getStringListSql(filter.getListOfEventClasses(), (String)"eventClass");
            and = " and ";
        }
        if (filter.hasExitCodes()) {
            where = where + and + " exitCode in ( :exitCode )";
            and = " and ";
        }
        if (filter.hasOrders()) {
            where = where + and + "(";
            for (OrderPath order : filter.getListOfOrders()) {
                where = where + this.getOrderClause(order) + " or ";
            }
            where = where + " 1=0)";
            and = " and ";
        }
        if (filter.getRemoteUrl() != null && !filter.getRemoteUrl().isEmpty()) {
            where = where + and + String.format(" remoteUrl %s :remoteUrl", SearchStringHelper.getSearchOperator((String)filter.getRemoteUrl()));
            and = " and ";
        }
        if (filter.getRemoteSchedulerPort() != null) {
            where = where + and + " remoteSchedulerPort = :remoteSchedulerPort";
            and = " and ";
        }
        if (filter.getRemoteSchedulerHost() != null && !filter.getRemoteSchedulerHost().isEmpty()) {
            where = where + and + String.format(" remoteSchedulerHost %s :remoteSchedulerHost", SearchStringHelper.getSearchOperator((String)filter.getRemoteSchedulerHost()));
            and = " and ";
        }
        if (filter.isSchedulerIdEmpty()) {
            if (filter.getSchedulerId() != null && !"".equals(filter.getSchedulerId())) {
                where = where + and + " (schedulerId is null or schedulerId='' or schedulerId=:schedulerId)";
                and = " and ";
            } else {
                where = where + and + " (schedulerId is null or schedulerId='')";
                and = " and ";
            }
        } else if (filter.getSchedulerId() != null && !filter.getSchedulerId().isEmpty()) {
            where = where + and + " schedulerId=:schedulerId";
            and = " and ";
        }
        if (filter.getJobChain() != null && !filter.getJobChain().isEmpty()) {
            where = where + and + String.format(" jobChain %s :jobChain", SearchStringHelper.getSearchOperator((String)filter.getJobChain()));
            and = " and ";
        }
        if (filter.getJobName() != null && !filter.getJobName().isEmpty()) {
            where = where + and + String.format(" jobName %s :jobName", SearchStringHelper.getSearchOperator((String)filter.getJobName()));
            and = " and ";
        }
        if (filter.getOrderId() != null && !filter.getOrderId().isEmpty()) {
            where = where + and + String.format(" orderId %s :orderId", SearchStringHelper.getSearchOperator((String)filter.getOrderId()));
            and = " and ";
        }
        if (filter.getEventId() != null && !filter.getEventId().isEmpty()) {
            where = where + and + String.format(" eventId %s :eventId", SearchStringHelper.getSearchOperator((String)filter.getEventId()));
            and = " and ";
        }
        if (filter.getEventClass() != null && !filter.getEventClass().isEmpty()) {
            where = where + and + String.format(" eventClass %s :eventClass", SearchStringHelper.getSearchOperator((String)filter.getEventClass()));
            and = " and ";
        }
        if (filter.getExitCode() != null) {
            where = where + and + " exitCode = :exitCode";
            and = " and ";
        }
        if (filter.getExpiresFrom() != null) {
            where = where + and + " expires >= :expiresFrom";
            and = " and ";
        }
        if (filter.getExpiresTo() != null) {
            where = where + and + " expires <= :expiresTo";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    public List<SchedulerEventDBItem> getSchedulerEventList(SchedulerEventFilter filter) throws Exception {
        List listOfCustomEvents = null;
        Query<SchedulerEventDBItem> query = this.bindParameters(String.format("from %s %s %s %s", SchedulerEventDBItem, this.getWhere(filter), filter.getOrderCriteria(), filter.getSortMode()), filter);
        if (filter.getLimit() > 0) {
            query.setMaxResults(filter.getLimit());
        }
        listOfCustomEvents = this.sosHibernateSession.getResultList(query);
        return listOfCustomEvents;
    }

    public SchedulerEventDBItem getEventItem(SchedulerEventFilter filter) throws Exception {
        filter.setLimit(1);
        List<SchedulerEventDBItem> list = this.getSchedulerEventList(filter);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public boolean checkEventExists(SchedulerEventFilter filter) throws Exception {
        filter.setLimit(1);
        return !this.getSchedulerEventList(filter).isEmpty();
    }

    public boolean checkEventExists(String condition) throws Exception {
        SchedulerEventFilter filter = new SchedulerEventFilter();
        List<SchedulerEventDBItem> listOfActiveEvents = this.getSchedulerEventList(filter);
        Iterator<SchedulerEventDBItem> iExit = listOfActiveEvents.iterator();
        BooleanExp exp = new BooleanExp(condition);
        while (iExit.hasNext()) {
            SchedulerEventDBItem e = iExit.next();
            exp.replace(e.getEventName() + ":" + e.getExitCode(), "true");
            exp.replace(e.getEventId() + ":" + e.getExitCode(), "true");
            LOGGER.debug(exp.getBoolExp());
        }
        for (SchedulerEventDBItem e : listOfActiveEvents) {
            exp.replace(e.getEventName(), "true");
            LOGGER.debug(exp.getBoolExp());
        }
        for (SchedulerEventDBItem e : listOfActiveEvents) {
            exp.replace(e.getEventId(), "true");
            LOGGER.debug(exp.getBoolExp());
        }
        LOGGER.debug("--------->" + exp.getBoolExp());
        return exp.evaluateExpression();
    }

    public boolean checkEventExists(String condition, String eventClass) throws Exception {
        SchedulerEventFilter filter = new SchedulerEventFilter();
        filter.setEventClass(eventClass);
        LOGGER.debug("eventClass:" + eventClass);
        List<SchedulerEventDBItem> listOfActiveEvents = this.getSchedulerEventList(filter);
        Iterator<SchedulerEventDBItem> iExit = listOfActiveEvents.iterator();
        BooleanExp exp = new BooleanExp(condition);
        while (iExit.hasNext()) {
            SchedulerEventDBItem e = iExit.next();
            exp.replace(e.getEventId() + ":" + e.getExitCode(), "true");
        }
        for (SchedulerEventDBItem e : listOfActiveEvents) {
            exp.replace(e.getEventId(), "true");
        }
        return exp.evaluateExpression();
    }

    public void insertItem(SchedulerEventDBItem schedulerEventDBItem2) throws SOSHibernateException {
        this.sosHibernateSession.save((Object)schedulerEventDBItem2);
        try {
            this.notifyWebservices(ADD);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Could not create notification command for add");
        }
    }

    public void updateItem(SchedulerEventDBItem schedulerEventDBItem2) throws SOSHibernateException {
        this.sosHibernateSession.update((Object)schedulerEventDBItem2);
        try {
            this.notifyWebservices(ADD);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Could not create notification command for add");
        }
    }

    public void deleteItem(SchedulerEventDBItem schedulerEventDBItem2) throws SOSHibernateException {
        this.sosHibernateSession.delete((Object)schedulerEventDBItem2);
        try {
            this.notifyWebservices(REMOVE);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Could not create notification command for remove");
        }
    }

    private void notifyWebservices(String action) throws JsonProcessingException {
        CustomEventsUtil customEventsUtil = new CustomEventsUtil(JobSchedulerEventJob.class.getName());
        if (ADD.equalsIgnoreCase(action)) {
            customEventsUtil.addEvent("CustomEventAdded");
        } else if (REMOVE.equalsIgnoreCase(action)) {
            customEventsUtil.addEvent("CustomEventDeleted");
        }
        this.notifyCommand = customEventsUtil.getEventCommandAsXml();
    }

    public void addEvent(SchedulerEventFilter filter) throws Exception {
        try {
            SchedulerEventDBItem schedulerEventDBItem = new SchedulerEventDBItem();
            SchedulerEventFilter uniqueFilter = new SchedulerEventFilter();
            uniqueFilter.setSchedulerId(filter.getSchedulerId());
            uniqueFilter.setEventClass(filter.getEventClass());
            uniqueFilter.setEventId(filter.getEventId());
            uniqueFilter.setExitCode(filter.getExitCode());
            SchedulerEventDBItem schedulerEventDBItem2 = this.getEventItem(uniqueFilter);
            if (schedulerEventDBItem2 != null) {
                schedulerEventDBItem = schedulerEventDBItem2;
            }
            LOGGER.debug(".. constructing event: schedulerId=" + filter.getSchedulerId() + ", eventClass=" + filter.getEventClass() + ", eventId=" + filter.getEventId());
            schedulerEventDBItem.setSchedulerId(filter.getSchedulerId());
            schedulerEventDBItem.setEventClass(filter.getEventClass());
            schedulerEventDBItem.setEventId(filter.getEventId());
            if (filter.getExitCode() == null) {
                schedulerEventDBItem.setExitCode(0);
            } else {
                schedulerEventDBItem.setExitCode(filter.getExitCode());
            }
            schedulerEventDBItem.setCreated(new Date());
            if (filter.getExpiresTo() == null) {
                if (filter.getExpirationDate() == null) {
                    filter.calculateExpirationDate();
                } else {
                    filter.setExpires(filter.getExpirationDate().getTime());
                }
                schedulerEventDBItem.setExpires(filter.getExpirationDate().getTime());
            } else {
                schedulerEventDBItem.setExpires(filter.getExpiresTo());
            }
            schedulerEventDBItem.setJobChain(filter.getJobChain());
            schedulerEventDBItem.setJobName(filter.getJobName());
            schedulerEventDBItem.setParameters(filter.getParametersAsString());
            schedulerEventDBItem.setOrderId(filter.getOrderId());
            schedulerEventDBItem.setRemoteSchedulerHost(filter.getRemoteSchedulerHost());
            schedulerEventDBItem.setRemoteSchedulerPort(filter.getRemoteSchedulerPort());
            LOGGER.info(".. adding event ...: scheduler id=" + schedulerEventDBItem.getSchedulerId() + ", event class=" + schedulerEventDBItem.getEventClass() + ", event id=" + schedulerEventDBItem.getEventId() + ", exit code=" + schedulerEventDBItem.getExitCodeAsString() + ", job chain=" + schedulerEventDBItem.getJobChain() + ", order id=" + schedulerEventDBItem.getOrderId() + ", job=" + schedulerEventDBItem.getJobName());
            if (schedulerEventDBItem.getEventId() == null || schedulerEventDBItem.getEventId().isEmpty()) {
                throw new Exception("Empty event_id is not allowed.");
            }
            if (schedulerEventDBItem2 == null) {
                this.insertItem(schedulerEventDBItem);
            } else {
                this.updateItem(schedulerEventDBItem);
            }
            this.notifyWebservices(ADD);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
    }

    public int removeEvent(SchedulerEventFilter filter) throws Exception {
        try {
            LOGGER.debug(".. removing event: schedulerId=" + filter.getSchedulerId() + ", eventClass=" + filter.getEventClass() + ", eventId=" + filter.getEventId());
            int rows = this.delete(filter);
            if (rows > 0) {
                this.notifyWebservices(REMOVE);
            }
            return rows;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
    }

    public String getNotifyCommand() {
        return this.notifyCommand;
    }

    private Document getEventsAsXmlFromList(String schedulerId, List<SchedulerEventDBItem> listOfEvents, SchedulerEventFilter filter) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document eventDocument = docBuilder.newDocument();
        eventDocument.appendChild(eventDocument.createElement("events"));
        if (schedulerId != null && !schedulerId.isEmpty()) {
            filter.setSchedulerIdEmpty(true);
            filter.setSchedulerId(schedulerId);
        }
        filter.setExpires("now_utc");
        boolean saveAutoCommit = this.getSession().isAutoCommit();
        this.getSession().setAutoCommit(false);
        this.beginTransaction();
        this.delete(filter);
        filter.setExpiresTo(null);
        List<SchedulerEventDBItem> eventList = null;
        eventList = listOfEvents == null ? this.getSchedulerEventList(filter) : listOfEvents;
        this.commit();
        this.getSession().setAutoCommit(saveAutoCommit);
        for (SchedulerEventDBItem eventItem : eventList) {
            Element event = eventDocument.createElement("event");
            event.setAttribute("scheduler_id", eventItem.getSchedulerId());
            event.setAttribute("remote_scheduler_host", eventItem.getRemoteSchedulerHost());
            event.setAttribute("remote_scheduler_port", String.valueOf(eventItem.getRemoteSchedulerPort()));
            event.setAttribute("job_chain", eventItem.getJobChain());
            event.setAttribute("order_id", eventItem.getOrderId());
            event.setAttribute("job_name", eventItem.getJobName());
            event.setAttribute("event_class", eventItem.getEventClass());
            event.setAttribute("event_id", eventItem.getEventId());
            event.setAttribute("exit_code", eventItem.getExitCodeAsString());
            event.setAttribute("expires", eventItem.getExpiresAsString());
            event.setAttribute("created", eventItem.getCreatedAsString());
            if (eventItem.getParameters() != null && !eventItem.getParameters().isEmpty()) {
                DocumentBuilderFactory docFactoryParam = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilderParam = docFactoryParam.newDocumentBuilder();
                Document eventParameters = docBuilderParam.parse(new InputSource(new StringReader(eventItem.getParameters())));
                LOGGER.debug("Importing params node...");
                Node impParameters = eventDocument.importNode(eventParameters.getDocumentElement(), true);
                LOGGER.debug("appending params child...");
                event.appendChild(impParameters);
            }
            eventDocument.getLastChild().appendChild(event);
        }
        LOGGER.info(eventList.size() + " events readed from database");
        return eventDocument;
    }

    public Document getEventsAsXml(String schedulerId) throws Exception {
        SchedulerEventFilter filter = new SchedulerEventFilter();
        return this.getEventsAsXmlFromList(schedulerId, null, filter);
    }

    public Document getEventsAsXml(String schedulerId, List<SchedulerEventDBItem> listOfActiveEvents) throws Exception {
        SchedulerEventFilter filter = new SchedulerEventFilter();
        return this.getEventsAsXmlFromList(schedulerId, listOfActiveEvents, filter);
    }
}

