/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventing.evaluate;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.string2bool.SOSBooleanExpression;
import sos.util.string2bool.SOSMalformedBooleanException;

public class BooleanExp {
    private static final Logger LOGGER = LoggerFactory.getLogger(BooleanExp.class);
    private String boolExp;
    String normalizedBoolExpr;
    private HashMap<String, String> allowedToken = new HashMap();

    public BooleanExp(String boolExp_) {
        this.allowedToken.put("(", "");
        this.allowedToken.put(")", "");
        this.allowedToken.put("||", "");
        this.allowedToken.put("&&", "");
        this.allowedToken.put("!", "");
        this.allowedToken.put("!(", "");
        this.allowedToken.put(")!", "");
        this.allowedToken.put("(!)", "");
        this.allowedToken.put("true", "");
        this.allowedToken.put("false", "");
        this.allowedToken.put("(true", "");
        this.allowedToken.put("(false", "");
        this.allowedToken.put("(true)", "");
        this.allowedToken.put("(false)", "");
        this.allowedToken.put("true)", "");
        this.allowedToken.put("false)", "");
        this.boolExp = boolExp_;
        this.boolExp = this.boolExp.replaceAll(" (?i)and ", " && ");
        this.boolExp = this.boolExp.replaceAll("(?i)not ", "! ");
        this.boolExp = this.boolExp.replaceAll(" (?i)or ", " || ");
        this.boolExp = this.boolExp.replaceAll("\\(", "( ");
        this.boolExp = this.boolExp.replaceAll("\\)", " )");
        this.boolExp = this.boolExp.replaceAll("[ ]{2,}", " ");
        this.boolExp = this.boolExp.trim();
    }

    public void replace(String s1, String s2) {
        this.boolExp = " " + this.boolExp + " ";
        this.boolExp = this.boolExp.replaceAll("\\(", " ( ");
        this.boolExp = this.boolExp.replaceAll("\\)", " ) ");
        s1 = " " + s1 + " ";
        s2 = " " + s2 + " ";
        this.boolExp = this.boolExp.replaceAll(s1, s2);
        this.boolExp = this.boolExp.replaceAll(" \\( ", "(");
        this.boolExp = this.boolExp.replaceAll(" \\) ", ")");
        this.boolExp = this.boolExp.trim();
    }

    public boolean evaluateExpression() {
        SOSBooleanExpression boolExpr = null;
        try {
            this.normalizedBoolExpr = "";
            StringTokenizer t = new StringTokenizer(this.boolExp, " ");
            while (t.hasMoreTokens()) {
                String s = t.nextToken();
                if (this.allowedToken.get(s) != null) {
                    this.normalizedBoolExpr = this.normalizedBoolExpr + " " + s;
                    continue;
                }
                this.normalizedBoolExpr = this.normalizedBoolExpr + " false ";
            }
            if (this.normalizedBoolExpr.length() == 0) {
                return true;
            }
            boolExpr = SOSBooleanExpression.readLeftToRight((String)this.normalizedBoolExpr);
            return boolExpr.booleanValue();
        }
        catch (SOSMalformedBooleanException e) {
            LOGGER.error("SOSMalformedBooleanException:--->" + e.getBooleanExpression() + ":" + e.getBooleanExpressionErrorMessage());
            return false;
        }
    }

    public String trueFalse(boolean b) {
        if (b) {
            return " true ";
        }
        return " false ";
    }

    public String getBoolExp() {
        return this.boolExp;
    }

    public void setBoolExp(String boolExp) {
        boolExp = boolExp.replaceAll(" (?i)and ", " && ");
        boolExp = boolExp.replaceAll("(?i)not ", "! ");
        boolExp = boolExp.replaceAll(" (?i)or ", " || ");
        boolExp = boolExp.replaceAll("\\(", "( ");
        boolExp = boolExp.replaceAll("\\)", " )");
        boolExp = boolExp.replaceAll("[ ]{2,}", " ");
        this.boolExp = boolExp = boolExp.trim();
    }

    public String getNormalizedBoolExpr() {
        return this.normalizedBoolExpr;
    }
}

