/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.inventory.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.exceptions.SOSHibernateObjectOperationException;
import com.sos.jitl.inventory.db.ClusterCalendar;
import com.sos.jitl.inventory.db.ClusterCalendarUsage;
import com.sos.jitl.inventory.helper.ObjectType;
import com.sos.jitl.reporting.db.DBItemInventoryAgentCluster;
import com.sos.jitl.reporting.db.DBItemInventoryAgentClusterMember;
import com.sos.jitl.reporting.db.DBItemInventoryAgentInstance;
import com.sos.jitl.reporting.db.DBItemInventoryAppliedLock;
import com.sos.jitl.reporting.db.DBItemInventoryClusterCalendar;
import com.sos.jitl.reporting.db.DBItemInventoryClusterCalendarUsage;
import com.sos.jitl.reporting.db.DBItemInventoryFile;
import com.sos.jitl.reporting.db.DBItemInventoryInstance;
import com.sos.jitl.reporting.db.DBItemInventoryJob;
import com.sos.jitl.reporting.db.DBItemInventoryJobChain;
import com.sos.jitl.reporting.db.DBItemInventoryJobChainNode;
import com.sos.jitl.reporting.db.DBItemInventoryLock;
import com.sos.jitl.reporting.db.DBItemInventoryOperatingSystem;
import com.sos.jitl.reporting.db.DBItemInventoryOrder;
import com.sos.jitl.reporting.db.DBItemInventoryProcessClass;
import com.sos.jitl.reporting.db.DBItemInventorySchedule;
import com.sos.jitl.reporting.db.DBItemSubmission;
import com.sos.jitl.reporting.db.DBItemSubmittedObject;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.jitl.reporting.helper.ReportUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.TemporalType;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerInventory
extends DBLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerInventory.class);
    private static final String CLUSTER_CALENDAR = ClusterCalendar.class.getName();
    private static final String CLUSTER_CALENDAR_USAGE = ClusterCalendarUsage.class.getName();

    public DBLayerInventory(SOSHibernateSession connection) {
        super(connection);
    }

    public DBItemInventoryInstance getInventoryInstance(String schedulerId, String schedulerHost, Integer schedulerPort) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_INSTANCES);
        sql.append(" where lower(schedulerId) = :schedulerId");
        sql.append(" and lower(hostname) = :hostname");
        sql.append(" and port = :port");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("schedulerId", (Object)schedulerId.toLowerCase());
        query.setParameter("hostname", (Object)schedulerHost.toLowerCase());
        query.setParameter("port", (Object)schedulerPort);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryInstance)result.get(0);
        }
        return null;
    }

    public DBItemInventoryInstance getInventoryInstance(String schedulerHost, Integer schedulerPort) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_INSTANCES);
        sql.append(" where lower(hostname) = :hostname");
        sql.append(" and port = :port");
        sql.append(" order by modified desc");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("hostname", (Object)schedulerHost.toLowerCase());
        query.setParameter("port", (Object)schedulerPort);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryInstance)result.get(0);
        }
        return null;
    }

    public DBItemInventoryInstance getInventoryInstance(Long id) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_INSTANCES);
        sql.append(" where id = :id");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("id", (Object)id);
        return (DBItemInventoryInstance)this.getSession().getSingleResult(query);
    }

    public String getSchedulerIdFromInstance(Long id) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("select schedulerId from ");
        sql.append(DBITEM_INVENTORY_INSTANCES);
        sql.append(" where id = :id");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("id", (Object)id);
        return (String)this.getSession().getSingleResult(query);
    }

    public DBItemInventoryInstance getInventoryInstance(String url) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_INSTANCES);
        sql.append(" where url = :url");
        sql.append(" order by modified desc");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("url", (Object)url.toLowerCase());
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryInstance)result.get(0);
        }
        return null;
    }

    public DBItemInventoryInstance getInventorySupervisorInstance(String commandUrl) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_INSTANCES);
        sql.append(" where lower(commandUrl) = :commandUrl order by modified desc");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("commandUrl", (Object)commandUrl.toLowerCase());
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryInstance)result.get(0);
        }
        return null;
    }

    public DBItemInventoryJob getInventoryJob(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_JOBS);
        sql.append(" where name = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name);
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryJob)result.get(0);
        }
        return null;
    }

    public DBItemInventoryJob getInventoryJobCaseInsensitive(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_JOBS);
        sql.append(" where lower(name) = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name.toLowerCase());
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryJob)result.get(0);
        }
        return null;
    }

    public DBItemInventoryJobChain getInventoryJobChain(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_JOB_CHAINS);
        sql.append(" where name = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name);
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryJobChain)result.get(0);
        }
        return null;
    }

    public DBItemInventoryJobChain getInventoryJobChainCaseInsensitive(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_JOB_CHAINS);
        sql.append(" where lower(name) = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name.toLowerCase());
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryJobChain)result.get(0);
        }
        return null;
    }

    public DBItemInventoryOrder getInventoryOrder(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_ORDERS);
        sql.append(" where name = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name);
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryOrder)result.get(0);
        }
        return null;
    }

    public DBItemInventoryOrder getInventoryOrderCaseInsensitive(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_ORDERS);
        sql.append(" where lower(name) = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name.toLowerCase());
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryOrder)result.get(0);
        }
        return null;
    }

    public DBItemInventoryProcessClass getInventoryProcessClass(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_PROCESS_CLASSES);
        sql.append(" where name = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name);
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryProcessClass)result.get(0);
        }
        return null;
    }

    public DBItemInventoryProcessClass getInventoryProcessClassCaseInsensitive(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_PROCESS_CLASSES);
        sql.append(" where lower(name) = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name.toLowerCase());
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryProcessClass)result.get(0);
        }
        return null;
    }

    public DBItemInventorySchedule getInventorySchedule(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_SCHEDULES);
        sql.append(" where name = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name);
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventorySchedule)result.get(0);
        }
        return null;
    }

    public DBItemInventorySchedule getInventoryScheduleCaseInsensitive(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_SCHEDULES);
        sql.append(" where lower(name) = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name.toLowerCase());
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventorySchedule)result.get(0);
        }
        return null;
    }

    public DBItemInventoryLock getInventoryLock(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_LOCKS);
        sql.append(" where name = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name);
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryLock)result.get(0);
        }
        return null;
    }

    public DBItemInventoryLock getInventoryLockCaseInsensitive(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_LOCKS);
        sql.append(" where lower(name) = :name");
        sql.append(" and instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("name", (Object)name.toLowerCase());
        query.setParameter("instanceId", (Object)instanceId);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryLock)result.get(0);
        }
        return null;
    }

    public DBItemInventoryProcessClass getProcessClassIfExists(Long instanceId, String processClass) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_PROCESS_CLASSES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and name = :name");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("name", (Object)processClass);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryProcessClass)result.get(0);
        }
        return null;
    }

    public DBItemInventorySchedule getScheduleIfExists(Long instanceId, String scheduleName) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_SCHEDULES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and name = :name");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("name", (Object)scheduleName);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventorySchedule)result.get(0);
        }
        return null;
    }

    public DBItemInventoryFile getInventoryFile(Long instanceId, String fileName) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_FILES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and fileName = :fileName");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("fileName", (Object)fileName);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryFile)result.get(0);
        }
        return null;
    }

    public DBItemInventorySchedule getSubstituteIfExists(String substitute, Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_SCHEDULES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and name = :name");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("name", (Object)substitute);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventorySchedule)result.get(0);
        }
        return null;
    }

    public Long saveOrUpdateSchedule(DBItemInventorySchedule newSchedule) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_SCHEDULES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and fileId = :fileId");
        sql.append(" and name = :name");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)newSchedule.getInstanceId());
        query.setParameter("fileId", (Object)newSchedule.getFileId());
        query.setParameter("name", (Object)newSchedule.getName());
        DBItemInventorySchedule result = (DBItemInventorySchedule)this.getSession().getSingleResult(query);
        if (result != null) {
            DBItemInventorySchedule classFromDb = result;
            classFromDb.setBasename(newSchedule.getBasename());
            classFromDb.setTitle(newSchedule.getTitle());
            classFromDb.setSubstitute(newSchedule.getSubstitute());
            classFromDb.setSubstituteId(newSchedule.getSubstituteId());
            classFromDb.setSubstituteName(newSchedule.getSubstituteName());
            classFromDb.setSubstituteValidFrom(newSchedule.getSubstituteValidFrom());
            classFromDb.setSubstituteValidTo(newSchedule.getSubstituteValidTo());
            classFromDb.setModified(ReportUtil.getCurrentDateTime());
            this.getSession().update((Object)classFromDb);
            return classFromDb.getId();
        }
        newSchedule.setCreated(ReportUtil.getCurrentDateTime());
        newSchedule.setModified(ReportUtil.getCurrentDateTime());
        this.getSession().save((Object)newSchedule);
        return newSchedule.getId();
    }

    public Long getJobChainId(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("select id from ");
        sql.append(DBITEM_INVENTORY_JOB_CHAINS);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and name = :name");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("name", (Object)name);
        return (Long)this.getSession().getSingleResult(query);
    }

    public DBItemInventoryJob getJobIfExists(Long instanceId, String jobName) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOBS);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and name = :name");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("name", (Object)jobName);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryJob)result.get(0);
        }
        return null;
    }

    public DBItemInventoryJobChain getJobChain(Long instanceId, String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOB_CHAINS);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and name = :name");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("name", (Object)name);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryJobChain)result.get(0);
        }
        return null;
    }

    public DBItemInventoryJobChain getJobChainIfExists(Long instanceId, String jobChainName) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOB_CHAINS);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and name = :name");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("name", (Object)jobChainName);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryJobChain)result.get(0);
        }
        return null;
    }

    public DBItemInventoryJobChainNode getJobChainNodeIfExists(Long instanceId, Long jobChainId, String state) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOB_CHAIN_NODES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and jobChainId = :jobChainId");
        sql.append(" and state = :state");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("jobChainId", (Object)jobChainId);
        query.setParameter("state", (Object)state);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryJobChainNode)result.get(0);
        }
        return null;
    }

    public DBItemInventoryJobChainNode getJobChainNodeIfExists(Long instanceId, Long jobChainId, Integer nodeType, String state, String directory, String regex) throws SOSHibernateException {
        List result;
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOB_CHAIN_NODES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and jobChainId = :jobChainId");
        if (nodeType == 3) {
            sql.append(" and directory = :directory");
            if (regex != null) {
                sql.append(" and regex = :regex");
            }
        } else {
            sql.append(" and state = :state");
        }
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("jobChainId", (Object)jobChainId);
        if (nodeType == 3) {
            query.setParameter("directory", (Object)directory);
            if (regex != null) {
                query.setParameter("regex", (Object)regex);
            }
        } else {
            query.setParameter("state", (Object)state);
        }
        if ((result = this.getSession().getResultList(query)) != null && !result.isEmpty()) {
            return (DBItemInventoryJobChainNode)result.get(0);
        }
        return null;
    }

    public List<DBItemInventoryJobChainNode> getJobChainNodes(Long instanceId, Long jobChainId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOB_CHAIN_NODES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and jobChainId = :jobChainId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("jobChainId", (Object)jobChainId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryJob> getAllJobsForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOBS);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryJobChain> getAllJobChainsForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOB_CHAINS);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryJobChainNode> getAllJobChainNodesForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOB_CHAIN_NODES);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryOrder> getAllOrdersForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_ORDERS);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryProcessClass> getAllProcessClassesForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_PROCESS_CLASSES);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventorySchedule> getAllSchedulesForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_SCHEDULES);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryAppliedLock> getAllAppliedLocks() throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_APPLIED_LOCKS);
        Query query = this.getSession().createQuery(sql.toString());
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryLock> getAllLocksForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_LOCKS);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryAgentCluster> getAllAgentClustersForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_AGENT_CLUSTER);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryAgentClusterMember> getAllAgentClusterMembersForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_AGENT_CLUSTERMEMBERS);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryAgentClusterMember> getAllAgentClusterMembersForInstanceAndCluster(Long instanceId, Long clusterId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_AGENT_CLUSTERMEMBERS);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and agentClusterId = :agentClusterId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("agentClusterId", (Object)clusterId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryAgentInstance> getAllAgentInstancesForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_AGENT_INSTANCES);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryFile> getAllFilesForInstance(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_FILES);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryClusterCalendarUsage> getAllCalendarUsagesForSchedulerId(String schedulerId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_CLUSTER_CALENDAR_USAGE);
        sql.append(" where schedulerId = :schedulerId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("schedulerId", (Object)schedulerId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryClusterCalendarUsage> getAllCalendarUsagesForObject(String schedulerId, String path, String objectType) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_CLUSTER_CALENDAR_USAGE);
        sql.append(" where schedulerId = :schedulerId");
        sql.append(" and path = :path");
        sql.append(" and objectType = :objectType");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("schedulerId", (Object)schedulerId);
        query.setParameter("path", (Object)path);
        query.setParameter("objectType", (Object)objectType);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryJob> getAllJobsFromJobChain(Long instanceId, Long jobChainId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOBS);
        sql.append(" where name in");
        sql.append(" (select jobName from ").append(DBITEM_INVENTORY_JOB_CHAIN_NODES);
        sql.append(" where instanceId = :instanceId and jobChainId = :jobChainId");
        sql.append(" group by jobName)");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("jobChainId", (Object)jobChainId);
        return this.getSession().getResultList(query);
    }

    public void refreshUsedInJobChains(Long instanceId, List<DBItemInventoryJob> jobs) throws SOSHibernateException {
        for (DBItemInventoryJob job : jobs) {
            this.refreshUsedInJobChains(instanceId, job);
        }
    }

    public void refreshUsedInJobChains(Long instanceId, DBItemInventoryJob job) throws SOSHibernateException {
        LOGGER.debug(String.format("refreshUsedInJobChains: job   id=%1$s    basename=%2$s ", job.getId(), job.getBaseName()));
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(DBITEM_INVENTORY_JOBS);
        sql.append(" set usedInJobChains = :usedCount where id = :id");
        job.setUsedInJobChains(this.getUsedInJobChains(job.getName(), job.getInstanceId()));
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("usedCount", (Object)this.getUsedInJobChains(job.getName(), job.getInstanceId()));
        query.setParameter("id", (Object)job.getId());
        this.getSession().executeUpdate(query);
    }

    private Integer getUsedInJobChains(String jobName, Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("select jobChainId from ");
        sql.append(DBLayer.DBITEM_INVENTORY_JOB_CHAIN_NODES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and jobName = :jobName");
        sql.append(" group by jobChainId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("jobName", (Object)jobName);
        query.setParameter("instanceId", (Object)instanceId);
        List jobChainIds = this.getSession().getResultList(query);
        if (jobChainIds != null) {
            return jobChainIds.size();
        }
        return null;
    }

    public List<DBItemInventoryJobChainNode> getJobsJobChainNodes(String jobName, Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBLayer.DBITEM_INVENTORY_JOB_CHAIN_NODES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and jobName = :jobName");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("jobName", (Object)jobName);
        query.setParameter("instanceId", (Object)instanceId);
        List jobChainNodes = this.getSession().getResultList(query);
        return jobChainNodes;
    }

    public List<DBItemInventoryJob> getJobsForProcessClass(String processClassName, Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBLayer.DBITEM_INVENTORY_JOBS);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and processClassName = :processClassName");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("processClassName", (Object)processClassName);
        query.setParameter("instanceId", (Object)instanceId);
        List jobs = this.getSession().getResultList(query);
        return jobs;
    }

    public DBItemInventoryAgentInstance getInventoryAgentInstanceFromDb(String url, Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBLayer.DBITEM_INVENTORY_AGENT_INSTANCES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and url = :url");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("url", (Object)url);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryAgentInstance)result.get(0);
        }
        return null;
    }

    public int deleteItemsFromDb(Date started, String tableName, Long instanceId) throws SOSHibernateException {
        LOGGER.debug(String.format("delete: items from %2$s before = %1$s and instanceId = %3$d with query.executeUpdate()", started.toString(), tableName, instanceId));
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ");
        sql.append(tableName);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and modified < :modifiedDate");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("modifiedDate", started, TemporalType.TIMESTAMP);
        return this.getSession().executeUpdate(query);
    }

    public int deleteCalendarUsagesFromDb(Date started, String schedulerId) throws SOSHibernateException {
        LOGGER.debug(String.format("delete: items from %2$s before = %1$s and schedulerId = %3$s with query.executeUpdate()", started.toString(), DBITEM_INVENTORY_CLUSTER_CALENDAR_USAGE, schedulerId));
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ");
        sql.append(DBITEM_INVENTORY_CLUSTER_CALENDAR_USAGE);
        sql.append(" where schedulerId = :schedulerId");
        sql.append(" and created < :created");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("schedulerId", (Object)schedulerId);
        query.setParameter("created", started, TemporalType.TIMESTAMP);
        return this.getSession().executeUpdate(query);
    }

    public int deleteAppliedLocksFromDb(Date started, Long instanceId) throws SOSHibernateException {
        LOGGER.debug(String.format("delete: appliedLocks before = %1$s  and instanceId = %2$d with query.executeUpdate()", started.toString(), instanceId));
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ");
        sql.append(DBLayer.DBITEM_INVENTORY_APPLIED_LOCKS).append(" appliedLocks ");
        sql.append("where appliedLocks.id in (select locks.id from ");
        sql.append(DBLayer.DBITEM_INVENTORY_LOCKS).append(" locks");
        sql.append(" where locks.instanceId = :instanceId");
        sql.append(" and locks.modified < :modified )");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("modified", started, TemporalType.TIMESTAMP);
        return this.getSession().executeUpdate(query);
    }

    public int deleteOldNodes(DBItemInventoryJobChain jobChain) throws SOSHibernateException {
        LOGGER.debug(String.format("delete old JobChainNodes for JobChain = %1$s and instanceId = %2$d with query.executeUpdate()", jobChain.getName(), jobChain.getInstanceId()));
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ");
        sql.append(DBLayer.DBITEM_INVENTORY_JOB_CHAIN_NODES);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and jobChainId = :jobChainId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)jobChain.getInstanceId());
        query.setParameter("jobChainId", (Object)jobChain.getId());
        int i = this.getSession().executeUpdate(query);
        return i;
    }

    public DBItemInventoryLock getLockByName(String name) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBLayer.DBITEM_INVENTORY_LOCKS);
        sql.append(" where basename = :basename");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("basename", (Object)name);
        List result = this.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            return (DBItemInventoryLock)result.get(0);
        }
        return null;
    }

    public int updateInventoryLiveDirectory(Long instanceId, String liveDirectory) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("update ");
        sql.append(DBITEM_INVENTORY_INSTANCES);
        sql.append(" set liveDirectory = :liveDirectory");
        sql.append(" where id = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("liveDirectory", (Object)liveDirectory);
        return this.getSession().executeUpdate(query);
    }

    public List<DBItemInventoryOrder> getOrdersReferencingSchedule(Long instanceId, String scheduleName) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_ORDERS);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and scheduleName = :scheduleName");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("scheduleName", (Object)scheduleName);
        return query.getResultList();
    }

    public List<DBItemInventoryJob> getJobsReferencingSchedule(Long instanceId, String scheduleName) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_JOBS);
        sql.append(" where instanceId = :instanceId");
        sql.append(" and scheduleName = :scheduleName");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        query.setParameter("scheduleName", (Object)scheduleName);
        return query.getResultList();
    }

    public DBItemInventoryOperatingSystem getInventoryOpSysById(Long id) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder("from ");
        sql.append(DBITEM_INVENTORY_OPERATING_SYSTEMS);
        sql.append(" where id = :id");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("id", (Object)id);
        return (DBItemInventoryOperatingSystem)this.getSession().getSingleResult(query);
    }

    public DBItemInventoryClusterCalendarUsage getCalendarUsageFor(DbItem dbItem, Long calendarId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_CLUSTER_CALENDAR_USAGE);
        sql.append(" where schedulerId = :schedulerId");
        sql.append(" and calendarId = :calendarId");
        sql.append(" and objectType = :objectType");
        sql.append(" and path = :path");
        Query query = this.getSession().createQuery(sql.toString());
        if (dbItem instanceof DBItemInventoryJob) {
            query.setParameter("schedulerId", (Object)this.getSchedulerIdFromInstance(((DBItemInventoryJob)dbItem).getInstanceId()));
            query.setParameter("calendarId", (Object)calendarId);
            query.setParameter("objectType", (Object)ObjectType.JOB.name());
            query.setParameter("path", (Object)((DBItemInventoryJob)dbItem).getName());
        } else if (dbItem instanceof DBItemInventoryOrder) {
            query.setParameter("schedulerId", (Object)this.getSchedulerIdFromInstance(((DBItemInventoryOrder)dbItem).getInstanceId()));
            query.setParameter("calendarId", (Object)calendarId);
            query.setParameter("objectType", (Object)ObjectType.ORDER.name());
            query.setParameter("path", (Object)((DBItemInventoryOrder)dbItem).getName());
        } else if (dbItem instanceof DBItemInventorySchedule) {
            query.setParameter("schedulerId", (Object)this.getSchedulerIdFromInstance(((DBItemInventorySchedule)dbItem).getInstanceId()));
            query.setParameter("calendarId", (Object)calendarId);
            query.setParameter("objectType", (Object)ObjectType.SCHEDULE.name());
            query.setParameter("path", (Object)((DBItemInventorySchedule)dbItem).getName());
        }
        return (DBItemInventoryClusterCalendarUsage)this.getSession().getSingleResult(query);
    }

    public List<DBItemInventoryClusterCalendarUsage> getCalendarUsages(String schedulerId, Long calendarId, String path) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_CLUSTER_CALENDAR_USAGE);
        sql.append(" where schedulerId = :schedulerId");
        sql.append(" and calendarId = :calendarId");
        sql.append(" and path = :path");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("schedulerId", (Object)schedulerId);
        query.setParameter("calendarId", (Object)calendarId);
        query.setParameter("path", (Object)path);
        return this.getSession().getResultList(query);
    }

    public List<DBItemInventoryClusterCalendarUsage> getCalendarUsagesToDelete(DbItem dbItem) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_CLUSTER_CALENDAR_USAGE);
        sql.append(" where schedulerId = :schedulerId");
        sql.append(" and objectType = :objectType");
        sql.append(" and path = :path");
        Query query = this.getSession().createQuery(sql.toString());
        if (dbItem instanceof DBItemInventoryJob) {
            query.setParameter("schedulerId", (Object)this.getSchedulerIdFromInstance(((DBItemInventoryJob)dbItem).getInstanceId()));
            query.setParameter("objectType", (Object)ObjectType.JOB.name());
            query.setParameter("path", (Object)((DBItemInventoryJob)dbItem).getName());
        } else if (dbItem instanceof DBItemInventoryOrder) {
            query.setParameter("schedulerId", (Object)this.getSchedulerIdFromInstance(((DBItemInventoryOrder)dbItem).getInstanceId()));
            query.setParameter("objectType", (Object)ObjectType.ORDER.name());
            query.setParameter("path", (Object)((DBItemInventoryOrder)dbItem).getName());
        } else if (dbItem instanceof DBItemInventorySchedule) {
            query.setParameter("schedulerId", (Object)this.getSchedulerIdFromInstance(((DBItemInventorySchedule)dbItem).getInstanceId()));
            query.setParameter("objectType", (Object)ObjectType.SCHEDULE.name());
            query.setParameter("path", (Object)((DBItemInventorySchedule)dbItem).getName());
        }
        return this.getSession().getResultList(query);
    }

    public List<Long> getAllCalendarIds() throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("select id from ").append(DBITEM_CLUSTER_CALENDARS);
        Query query = this.getSession().createQuery(sql.toString());
        return this.getSession().getResultList(query);
    }

    public DBItemInventoryClusterCalendar getCalendar(Long id) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ").append(DBITEM_CLUSTER_CALENDARS);
        sql.append(" where id = :id");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("id", (Object)id);
        return (DBItemInventoryClusterCalendar)this.getSession().getSingleResult(query);
    }

    public DBItemInventoryClusterCalendar getCalendar(String schedulerId, String path) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ").append(DBITEM_CLUSTER_CALENDARS);
        sql.append(" where schedulerId = :schedulerId");
        sql.append(" and name = :path");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("schedulerId", (Object)schedulerId);
        query.setParameter("path", (Object)path);
        return (DBItemInventoryClusterCalendar)this.getSession().getSingleResult(query);
    }

    public List<DBItemInventoryClusterCalendarUsage> getCalendarUsages(String schedulerId, String path, String objectType) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_INVENTORY_CLUSTER_CALENDAR_USAGE);
        sql.append(" where schedulerId = :schedulerId");
        sql.append(" and path = :path");
        sql.append(" and objectType = :objectType");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("schedulerId", (Object)schedulerId);
        query.setParameter("path", (Object)path);
        query.setParameter("objectType", (Object)objectType);
        return this.getSession().getResultList(query);
    }

    public boolean repairCalendars() throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) from ").append(DBITEM_CLUSTER_CALENDARS);
        Query query = this.getSession().createQuery(sql.toString());
        Long count = (Long)query.getSingleResult();
        if (count == null || count == 0L) {
            sql = new StringBuilder();
            sql.append("select new ").append(CLUSTER_CALENDAR).append("(c, i.schedulerId) from ").append(DBITEM_CALENDARS).append(" c, ");
            sql.append(DBITEM_INVENTORY_INSTANCES).append(" i where c.instanceId=i.id order by i.schedulerId, c.name, c.modified desc");
            Query query2 = this.getSession().createQuery(sql.toString());
            List result = query2.getResultList();
            if (result != null && !result.isEmpty()) {
                List<ClusterCalendarUsage> usages = this.getOrderedCalendarUsages();
                DBItemInventoryClusterCalendar ref = null;
                HashMap<Long, Long> ids = new HashMap<Long, Long>();
                for (ClusterCalendar item : result) {
                    DBItemInventoryClusterCalendar clusterCalendar = item.get();
                    if (!clusterCalendar.equals(ref)) {
                        try {
                            clusterCalendar = (DBItemInventoryClusterCalendar)this.getSession().saveOrUpdate((Object)clusterCalendar);
                            ids.put(item.getOldId(), clusterCalendar.getId());
                            ref = clusterCalendar;
                            continue;
                        }
                        catch (SOSHibernateObjectOperationException e) {
                            if (e.getCause() != null && e.getCause() instanceof ConstraintViolationException) {
                                ids.put(item.getOldId(), ref.getId());
                                continue;
                            }
                            throw e;
                        }
                    }
                    ids.put(item.getOldId(), ref.getId());
                }
                if (usages != null) {
                    for (ClusterCalendarUsage clusterUsage : usages) {
                        DBItemInventoryClusterCalendarUsage u = clusterUsage.get();
                        u.setCalendarId((Long)ids.get(u.getCalendarId()));
                        try {
                            this.getSession().saveOrUpdate((Object)u);
                        }
                        catch (SOSHibernateObjectOperationException e) {
                            if (e.getCause() != null && e.getCause() instanceof ConstraintViolationException) continue;
                            throw e;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private List<ClusterCalendarUsage> getOrderedCalendarUsages() throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("select new ").append(CLUSTER_CALENDAR_USAGE).append("(c, i.schedulerId) from ").append(DBITEM_INVENTORY_CALENDAR_USAGE);
        sql.append(" c, ").append(DBITEM_INVENTORY_INSTANCES).append(" i where c.instanceId=i.id order by c.modified desc");
        Query query = this.getSession().createQuery(sql.toString());
        return query.getResultList();
    }

    public List<DBItemSubmission> getUncommittedSubmissions(Long instanceId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_SUBMISSIONS);
        sql.append(" where instanceId = :instanceId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("instanceId", (Object)instanceId);
        return this.getSession().getResultList(query);
    }

    public List<DBItemSubmittedObject> getUncommittedSubmittedObjects(Long submissionId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("from ");
        sql.append(DBITEM_SUBMITTED_OBJECTS);
        sql.append(" where id = :submissionId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("submissionId", (Object)submissionId);
        return this.getSession().getResultList(query);
    }

    public Long getUncommitedInstanceCount(Long submissionId) throws SOSHibernateException {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) from ");
        sql.append(DBITEM_SUBMISSIONS);
        sql.append(" where submissionId = :submissionId");
        Query query = this.getSession().createQuery(sql.toString());
        query.setParameter("submissionId", (Object)submissionId);
        return (Long)this.getSession().getSingleResult(query);
    }
}

