/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.inventory.plugins;

import com.sos.exception.SOSConnectionRefusedException;
import com.sos.exception.SOSConnectionResetException;
import com.sos.exception.SOSInvalidDataException;
import com.sos.exception.SOSNoResponseException;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.jitl.eventhandler.plugin.notifier.Mailer;
import com.sos.jitl.inventory.data.InventoryEventUpdateUtil;
import com.sos.jitl.inventory.data.ProcessInitialInventoryUtil;
import com.sos.jitl.inventory.exceptions.SOSInventoryPluginException;
import com.sos.jitl.inventory.helper.HttpHelper;
import com.sos.jitl.inventory.model.InventoryModel;
import com.sos.jitl.reporting.db.DBItemInventoryInstance;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.scheduler.engine.eventbus.EventPublisher;
import com.sos.scheduler.engine.kernel.Scheduler;
import com.sos.scheduler.engine.kernel.plugin.AbstractPlugin;
import com.sos.scheduler.engine.kernel.scheduler.SchedulerXmlCommandExecutor;
import com.sos.scheduler.engine.kernel.variable.VariableSet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scala.collection.JavaConversions;
import scala.collection.Map;
import sos.xml.SOSXMLXPath;

public class InitializeInventoryInstancePlugin
extends AbstractPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitializeInventoryInstancePlugin.class);
    private static final String COMMAND = "<show_state subsystems=\"folder\" what=\"folders cluster no_subfolders operations\" path=\"/any/path/that/does/not/exists\" />";
    private static final String REPORTING_HIBERNATE_CONFIG_PATH_APPENDER = "reporting.hibernate.cfg.xml";
    private static final String DEFAULT_HIBERNATE_CONFIG_PATH_APPENDER = "hibernate.cfg.xml";
    private static final String HIBERNATE_CFG_REPORTING_KEY = "sos.hibernate_configuration_reporting";
    private static final String REG_EXP_PATTERN_FOR_LIVE_FOLDER = "Directory_observer\\((.*)\\)";
    private static final Long HTTP_CLIENT_RECONNECT_DELAY = 30000L;
    private SchedulerXmlCommandExecutor xmlCommandExecutor;
    private SOSHibernateFactory factory;
    private Path liveDirectory;
    private InventoryModel model;
    private InventoryEventUpdateUtil inventoryEventUpdate;
    private SOSXMLXPath xPathAnswerXml;
    private VariableSet variables;
    private ExecutorService fixedThreadPoolExecutor = Executors.newFixedThreadPool(1);
    private Path reportingHibernateConfigPath;
    private Path schedulerHibernateConfigPath;
    private Path schedulerXmlPath;
    private String host;
    private String httpPort;
    private Integer port;
    private String hibernateConfigReporting;
    private Scheduler scheduler;
    private EventPublisher customEventBus;
    private String supervisorHost;
    private String supervisorPort;
    private String schedulerId;
    private String hostFromHttpPort;
    private DBItemInventoryInstance dbItemInventoryInstance;

    @Inject
    public InitializeInventoryInstancePlugin(Scheduler scheduler, SchedulerXmlCommandExecutor xmlCommandExecutor, VariableSet variables, EventPublisher eventBus) {
        this.scheduler = scheduler;
        this.xmlCommandExecutor = xmlCommandExecutor;
        this.variables = variables;
        this.customEventBus = eventBus;
    }

    public void onPrepare() {
        MDC.put((String)"plugin", (String)"inventory");
        try {
            if (this.variables.apply(HIBERNATE_CFG_REPORTING_KEY) != null && !this.variables.apply(HIBERNATE_CFG_REPORTING_KEY).isEmpty()) {
                this.hibernateConfigReporting = this.variables.apply(HIBERNATE_CFG_REPORTING_KEY);
                if (Files.notExists(Paths.get(this.hibernateConfigReporting, new String[0]), new LinkOption[0])) {
                    LOGGER.warn("The file configured in scheduler.xml as 'sos.hibernate_configuration_reporting' could not be found!");
                }
            }
            Runnable inventoryInitThread = new Runnable(){

                @Override
                public void run() {
                    MDC.put((String)"plugin", (String)"inventory");
                    try {
                        InitializeInventoryInstancePlugin.this.initFirst();
                        LOGGER.info("*** initial inventory instance update started ***");
                        InitializeInventoryInstancePlugin.this.executeInitialInventoryProcessing();
                        LOGGER.info("*** initial inventory instance update finished ***");
                    }
                    catch (Exception e) {
                        LOGGER.error(e.toString(), (Throwable)e);
                    }
                    catch (Throwable t) {
                        LOGGER.error(t.toString(), t);
                    }
                }
            };
            this.fixedThreadPoolExecutor.submit(inventoryInitThread);
        }
        catch (Exception e) {
            this.closeConnections();
            LOGGER.error("Fatal Error in InventoryPlugin @OnPrepare:" + e.toString(), (Throwable)e);
        }
        catch (Throwable t) {
            LOGGER.error("Fatal Error in InventoryPlugin @OnPrepare:" + t.toString(), t);
        }
        super.onPrepare();
        MDC.remove((String)"plugin");
    }

    public void onActivate() {
        MDC.put((String)"plugin", (String)"inventory");
        final java.util.Map mailDefaults = JavaConversions.mapAsJavaMap((Map)this.scheduler.mailDefaults());
        try {
            Runnable inventoryEventThread = new Runnable(){

                @Override
                public void run() {
                    MDC.put((String)"plugin", (String)"inventory");
                    Mailer mailer = new Mailer("inventory", mailDefaults);
                    try {
                        InitializeInventoryInstancePlugin.this.executeInventoryModelProcessing();
                    }
                    catch (Exception e) {
                        LOGGER.error(e.toString(), (Throwable)e);
                        mailer.sendOnError("InitializeInventoryInstancePlugin", "onActivate", e);
                    }
                    catch (Throwable t) {
                        mailer.sendOnError("InitializeInventoryInstancePlugin", "onActivate", t);
                    }
                    try {
                        LOGGER.info("*** event based inventory update started ***");
                        InitializeInventoryInstancePlugin.this.executeEventBasedInventoryProcessing();
                    }
                    catch (SOSConnectionRefusedException | SOSConnectionResetException e) {
                        try {
                            Thread.sleep(HTTP_CLIENT_RECONNECT_DELAY);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        LOGGER.warn("Restarting inventory after connection failed!");
                        try {
                            InitializeInventoryInstancePlugin.this.inventoryEventUpdate.restartExecution();
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception e) {
                        LOGGER.warn("Restarting inventory!");
                        try {
                            InitializeInventoryInstancePlugin.this.inventoryEventUpdate.restartExecution();
                        }
                        catch (Exception exception) {}
                    }
                    catch (Throwable t) {
                        try {
                            Thread.sleep(HTTP_CLIENT_RECONNECT_DELAY);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        LOGGER.warn("Restarting inventory!");
                        try {
                            InitializeInventoryInstancePlugin.this.inventoryEventUpdate.restartExecution();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            this.fixedThreadPoolExecutor.submit(inventoryEventThread);
        }
        catch (Exception e) {
            this.closeConnections();
            LOGGER.error("Fatal Error in InventoryPlugin @OnActivate:" + e.toString(), (Throwable)e);
        }
        catch (Throwable t) {
            this.closeConnections();
            LOGGER.error("Fatal Error in InventoryPlugin @OnActivate:" + t.toString(), t);
        }
        super.onActivate();
        MDC.remove((String)"plugin");
    }

    public void executeInitialInventoryProcessing() throws Exception {
        ProcessInitialInventoryUtil dataUtil = new ProcessInitialInventoryUtil(this.factory);
        if (this.supervisorHost != null && this.supervisorPort != null) {
            dataUtil.setSupervisorHost(this.supervisorHost);
            dataUtil.setSupervisorPort(this.supervisorPort);
            LOGGER.debug("[InventoryPlugin] - supervisor host is " + this.supervisorHost);
            LOGGER.debug("[InventoryPlugin] - supervisor port is " + this.supervisorPort);
        }
        this.dbItemInventoryInstance = dataUtil.process(this.xPathAnswerXml, this.liveDirectory, this.schedulerHibernateConfigPath, this.httpPort);
    }

    private void initFirst() throws Exception {
        String schedulerXmlPathname = null;
        String answerXml = null;
        for (int i = 0; i < 120; ++i) {
            try {
                Thread.sleep(1000L);
                answerXml = this.executeXML(COMMAND);
                if (answerXml == null || answerXml.isEmpty()) continue;
                this.xPathAnswerXml = new SOSXMLXPath(new StringBuffer(answerXml));
                String state = this.xPathAnswerXml.selectSingleNodeValue("/spooler/answer/state/@state");
                if (!"running,waiting_for_activation,waiting_for_activation_paused,paused".contains(state)) continue;
                schedulerXmlPathname = this.xPathAnswerXml.selectSingleNodeValue("/spooler/answer/state/@config_file");
                break;
            }
            catch (InterruptedException state) {
                continue;
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        if (schedulerXmlPathname == null) {
            throw new SOSInvalidDataException("Couldn't determine path of scheduler.xml");
        }
        this.schedulerXmlPath = Paths.get(schedulerXmlPathname, new String[0]);
        if (!Files.exists(this.schedulerXmlPath, new LinkOption[0])) {
            throw new SOSInventoryPluginException(String.format("Configuration file %1$s doesn't exist", schedulerXmlPathname));
        }
        if (answerXml == null || answerXml.isEmpty()) {
            throw new SOSNoResponseException("JobScheduler doesn't response the state");
        }
        try {
            this.setGlobalProperties(this.xPathAnswerXml);
        }
        catch (Exception e) {
            throw new SOSInvalidDataException("Couldn't determine JobScheduler http url", (Throwable)e);
        }
        String configurationDirectoryFromState = this.xPathAnswerXml.selectSingleNodeValue("/spooler/answer/state/@configuration_directory");
        if (configurationDirectoryFromState != null && !configurationDirectoryFromState.isEmpty()) {
            this.liveDirectory = Paths.get(configurationDirectoryFromState, new String[0]);
        } else {
            Node operations = this.xPathAnswerXml.selectSingleNode("/spooler/answer/state/operations");
            if (operations != null) {
                NodeList operationsTextChilds = operations.getChildNodes();
                for (int i = 0; i < operationsTextChilds.getLength(); ++i) {
                    String text = operationsTextChilds.item(i).getNodeValue();
                    if (text.contains("Directory_observer")) {
                        Matcher regExMatcher = Pattern.compile(REG_EXP_PATTERN_FOR_LIVE_FOLDER).matcher(text);
                        if (!regExMatcher.find()) continue;
                        this.liveDirectory = Paths.get(regExMatcher.group(1), new String[0]);
                        continue;
                    }
                    this.liveDirectory = this.schedulerXmlPath.getParent().resolve("live");
                }
            } else {
                this.liveDirectory = this.schedulerXmlPath.getParent().resolve("live");
            }
        }
        this.setSupervisorFromSchedulerXml();
        this.schedulerHibernateConfigPath = this.schedulerXmlPath.getParent().resolve(DEFAULT_HIBERNATE_CONFIG_PATH_APPENDER);
        this.reportingHibernateConfigPath = this.hibernateConfigReporting != null && !this.hibernateConfigReporting.isEmpty() ? Paths.get(this.hibernateConfigReporting, new String[0]) : (Files.exists(this.schedulerXmlPath.getParent().resolve(REPORTING_HIBERNATE_CONFIG_PATH_APPENDER), new LinkOption[0]) ? this.schedulerXmlPath.getParent().resolve(REPORTING_HIBERNATE_CONFIG_PATH_APPENDER) : this.schedulerXmlPath.getParent().resolve(DEFAULT_HIBERNATE_CONFIG_PATH_APPENDER));
        if (this.reportingHibernateConfigPath == null) {
            throw new SOSInventoryPluginException("No hibernate configuration file found!");
        }
        this.init(this.reportingHibernateConfigPath);
    }

    private void init(Path hibernateConfigPath) throws Exception {
        this.factory = new SOSHibernateFactory(hibernateConfigPath);
        this.factory.setIdentifier("inventory");
        this.factory.setAutoCommit(false);
        this.factory.setTransactionIsolation(2);
        this.factory.addClassMapping(DBLayer.getInventoryClassMapping());
        this.factory.addClassMapping(DBLayer.getReportingClassMapping());
        this.factory.addClassMapping(DBLayer.getJobStreamClassMapping());
        this.factory.build();
    }

    private InventoryModel initInitialInventoryProcessing(DBItemInventoryInstance jsInstanceItem, Path schedulerXmlPath) throws Exception {
        this.model = new InventoryModel(this.factory, jsInstanceItem, schedulerXmlPath, this.customEventBus);
        this.model.setXmlCommandExecutor(this.xmlCommandExecutor);
        return this.model;
    }

    private void executeInventoryModelProcessing() throws Exception {
        InventoryModel model = this.initInitialInventoryProcessing(this.dbItemInventoryInstance, this.schedulerXmlPath);
        if (model != null) {
            model.setLiveDirectory(this.liveDirectory);
            LOGGER.info("*** initial inventory configuration update started ***");
            model.process();
            LOGGER.info("*** initial inventory configuration update finished ***");
        }
    }

    private void executeEventBasedInventoryProcessing() throws Exception {
        this.inventoryEventUpdate = new InventoryEventUpdateUtil(this.host, this.port, this.factory, this.customEventBus, this.schedulerXmlPath, this.schedulerId, this.httpPort);
        this.inventoryEventUpdate.setXmlCommandExecutor(this.xmlCommandExecutor);
        this.inventoryEventUpdate.execute();
    }

    private String executeXML(String xmlCommand) {
        try {
            if (this.xmlCommandExecutor != null) {
                return this.xmlCommandExecutor.executeXml(xmlCommand);
            }
            LOGGER.error("xmlCommandExecutor is null");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void close() {
        MDC.put((String)"plugin", (String)"inventory");
        LOGGER.info("[inventory] executeClose");
        this.closeConnections();
        try {
            this.fixedThreadPoolExecutor.shutdownNow();
            boolean shutdown = this.fixedThreadPoolExecutor.awaitTermination(1L, TimeUnit.SECONDS);
            if (shutdown) {
                LOGGER.debug("Thread has been shut down correctly.");
            } else {
                LOGGER.debug("Thread has ended due to timeout on shutdown. Doesn\u00b4t wait for answer from thread.");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        super.close();
        MDC.remove((String)"plugin");
    }

    private void setGlobalProperties(SOSXMLXPath xPath) throws Exception {
        this.schedulerId = xPath.selectSingleNodeValue("/spooler/answer/state/@id");
        this.host = xPath.selectSingleNodeValue("/spooler/answer/state/@host");
        this.httpPort = xPath.selectSingleNodeValue("/spooler/answer/state/@http_port");
        this.hostFromHttpPort = HttpHelper.getHttpHost(this.httpPort, "127.0.0.1");
        this.port = HttpHelper.getHttpPort(this.httpPort);
    }

    private void closeConnections() {
        if (this.inventoryEventUpdate != null) {
            this.inventoryEventUpdate.setClosed(true);
            try {
                this.inventoryEventUpdate.getHttpClient().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.factory != null) {
            this.factory.close();
        }
    }

    private void setSupervisorFromSchedulerXml() throws Exception {
        SOSXMLXPath xPathSchedulerXml = new SOSXMLXPath(this.schedulerXmlPath);
        String supervisorUrl = xPathSchedulerXml.selectSingleNodeValue("/spooler/config/@supervisor");
        if (supervisorUrl != null && !supervisorUrl.isEmpty()) {
            String[] supervisorSplit = supervisorUrl.split(":");
            String determinedHost = supervisorSplit[0];
            this.supervisorPort = supervisorSplit[1];
            try {
                this.supervisorHost = "localhost".equalsIgnoreCase(determinedHost) || "127.0.0.1".equals(determinedHost) ? InetAddress.getLocalHost().getCanonicalHostName() : InetAddress.getByName(determinedHost).getCanonicalHostName();
                if (!this.supervisorHost.equals(InetAddress.getByName(determinedHost).getHostAddress()) && this.supervisorHost.contains(".")) {
                    String[] split = this.supervisorHost.split("\\.", 2);
                    this.supervisorHost = split[0];
                } else if (this.supervisorHost.equals(InetAddress.getByName(determinedHost).getHostAddress())) {
                    LOGGER.error("Could not determine supervisor host name from given IP address.");
                }
            }
            catch (UnknownHostException e) {
                LOGGER.error("Could not resolve supervisor host name.", (Throwable)e);
            }
        }
    }
}

