/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobchainnodeparameter;

import com.sos.JSHelper.io.Files.JSFile;
import com.sos.jitl.jobchainnodeparameter.model.JobChain;
import com.sos.jitl.jobchainnodeparameter.model.Param;
import com.sos.jitl.jobchainnodeparameter.model.Params;
import com.sos.jitl.jobchainnodeparameter.model.Process;
import com.sos.jitl.jobchainnodeparameter.model.Settings;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.ParameterSubstitutor;

public class JobchainNodeConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobchainNodeConfiguration.class);
    private static final String FILENAMEEXTENSIONCONFIG_XML = ".config.xml";
    private static final String DEFAULTFILENAME4CACHE = "cache";
    private JAXBContext context;
    private String liveFolder;
    private String jobChainNodeConfigurationFileName;
    private String orderId;
    private String jobChainPath;
    private String orderPayload;
    private JSFile jobChainNodeConfigurationFile;
    private Settings settings;
    private Params listOfJobchainParameters;
    private Params listOfJobchainNodeParameters;
    private Map<String, String> jobchainGlobalParameters;
    private Map<String, String> jobchainNodeParameters;
    private Map<String, String> jobchainParameters;
    private ParameterSubstitutor parameterSubstitutor;
    private Map<String, String> listOfSchedulerParameters;
    private Map<String, String> listOfOrderParameters;
    private Map<String, String> listOfTaskParameters;

    public JobchainNodeConfiguration() throws JAXBException {
        this.listOfTaskParameters = new HashMap<String, String>();
        this.listOfOrderParameters = new HashMap<String, String>();
        this.listOfSchedulerParameters = new HashMap<String, String>();
        this.context = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
    }

    public JobchainNodeConfiguration(JSFile jobChainNodeConfigurationFile) throws JAXBException {
        this.context = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
        this.listOfTaskParameters = new HashMap<String, String>();
        this.listOfOrderParameters = new HashMap<String, String>();
        this.listOfSchedulerParameters = new HashMap<String, String>();
        if (jobChainNodeConfigurationFile.exists()) {
            this.jobChainNodeConfigurationFile = jobChainNodeConfigurationFile;
        } else {
            LOGGER.warn(String.format("File %s does not exist", jobChainNodeConfigurationFile.getAbsolutePath()));
        }
    }

    public void addParam(String key, String value) {
        if (this.listOfOrderParameters == null) {
            this.listOfOrderParameters = new HashMap<String, String>();
        }
        this.listOfOrderParameters.put(key, value);
    }

    public String getParam(String key) {
        if (this.listOfOrderParameters != null) {
            return this.listOfOrderParameters.get(key);
        }
        return null;
    }

    private JSFile getFileFromCacheFolder(JSFile configurationFile) {
        if (!configurationFile.exists()) {
            File fCacheBaseFolder = new File(configurationFile.getParentFile(), DEFAULTFILENAME4CACHE);
            return new JSFile(fCacheBaseFolder, configurationFile.getName());
        }
        return configurationFile;
    }

    private void setJobChainNodeConfigurationFile() {
        String orderConfigurationFileName = this.jobChainPath + "," + this.orderId + FILENAMEEXTENSIONCONFIG_XML;
        LOGGER.debug("orderConfigurationFileName:" + orderConfigurationFileName);
        this.jobChainNodeConfigurationFile = new JSFile(this.liveFolder, orderConfigurationFileName);
        this.jobChainNodeConfigurationFile = this.getFileFromCacheFolder(this.jobChainNodeConfigurationFile);
        if (!this.jobChainNodeConfigurationFile.exists()) {
            if (this.jobChainNodeConfigurationFileName == null || "".equals(this.jobChainNodeConfigurationFileName)) {
                this.jobChainNodeConfigurationFileName = this.jobChainPath + FILENAMEEXTENSIONCONFIG_XML;
            }
            LOGGER.debug("jobChainNodeConfigurationFileName:" + this.jobChainNodeConfigurationFileName);
            this.jobChainNodeConfigurationFile = new JSFile(this.liveFolder, this.jobChainNodeConfigurationFileName);
            this.jobChainNodeConfigurationFile = this.getFileFromCacheFolder(this.jobChainNodeConfigurationFile);
        }
        LOGGER.debug("Looking for job chain configuration path: " + this.jobChainNodeConfigurationFile.getAbsolutePath());
    }

    private void getParametersFromConfigFile() throws JAXBException {
        if (this.listOfJobchainParameters == null || this.listOfJobchainNodeParameters == null) {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            if (this.jobChainNodeConfigurationFile != null && this.jobChainNodeConfigurationFile.exists()) {
                this.settings = (Settings)unmarshaller.unmarshal((File)this.jobChainNodeConfigurationFile);
            } else {
                LOGGER.info("Configuration File: " + this.jobChainNodeConfigurationFile.getAbsolutePath() + " not found (Probably running on an agent).");
                LOGGER.info("Reading configuration from xml payload...");
                StringReader reader = new StringReader(this.orderPayload);
                this.settings = (Settings)unmarshaller.unmarshal((Reader)reader);
            }
            JobChain jobchain = this.settings.getJobChain();
            this.listOfJobchainParameters = jobchain.getOrder() != null && jobchain.getOrder().getParams() != null ? jobchain.getOrder().getParams() : new Params();
        }
    }

    private void getJobchainParameters() throws JAXBException {
        if (this.listOfJobchainParameters.getParam() != null) {
            for (Param param : this.listOfJobchainParameters.getParam()) {
                if ("".equals(param.getName())) continue;
                this.jobchainGlobalParameters.put(param.getName(), param.getValue());
                this.jobchainParameters.put(param.getName(), param.getValue());
            }
        }
    }

    private void getJobchainNodeParameters(String node) throws JAXBException {
        List<Process> processes;
        if (this.settings.getJobChain().getOrder() != null && (processes = this.settings.getJobChain().getOrder().getProcess()) != null) {
            for (Process process : processes) {
                if (process.getState() == null || !process.getState().equals(node)) continue;
                this.listOfJobchainNodeParameters = process.getParams();
                if (this.listOfJobchainNodeParameters.getParam() == null) continue;
                for (Param param : this.listOfJobchainNodeParameters.getParam()) {
                    if ("".equals(param.getName())) continue;
                    this.jobchainParameters.put(param.getName(), param.getValue());
                    this.jobchainNodeParameters.put(param.getName(), param.getValue());
                }
            }
        }
    }

    private void getParametersForNode(String node) {
        this.jobchainGlobalParameters = new HashMap<String, String>();
        this.jobchainNodeParameters = new HashMap<String, String>();
        this.jobchainParameters = new HashMap<String, String>();
        if (this.jobChainNodeConfigurationFile == null) {
            this.setJobChainNodeConfigurationFile();
        }
        try {
            if (!"".equals(this.orderPayload) || this.jobChainNodeConfigurationFile != null && this.jobChainNodeConfigurationFile.exists()) {
                this.getParametersFromConfigFile();
                this.getJobchainParameters();
                this.getJobchainNodeParameters(node);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getJobchainGlobalParameterValue(String key) {
        return this.jobchainGlobalParameters.get(key);
    }

    public String getJobchainParameterValue(String key) {
        return this.jobchainParameters.get(key);
    }

    public String getJobchainNodeParameterValue(String key) {
        if ("".equals(key)) {
            return null;
        }
        return this.jobchainNodeParameters.get(key);
    }

    private void addSubstituterValues(Map<String, String> h) {
        if (h != null) {
            if (this.parameterSubstitutor == null) {
                this.parameterSubstitutor = new ParameterSubstitutor();
            }
            for (Map.Entry<String, String> entry : h.entrySet()) {
                String value = entry.getValue();
                String paramName = entry.getKey();
                if (value == null) continue;
                this.parameterSubstitutor.addKey(paramName, value);
            }
        }
    }

    private String doReplace(String value, String openTag, String closeTag) {
        this.parameterSubstitutor.setOpenTag(openTag);
        this.parameterSubstitutor.setCloseTag(closeTag);
        String replacedValue = value;
        do {
            value = replacedValue;
            replacedValue = this.parameterSubstitutor.replaceEnvVars(value);
            replacedValue = this.parameterSubstitutor.replaceSystemProperties(replacedValue);
        } while (!value.equals(replacedValue = this.parameterSubstitutor.replace(replacedValue)));
        return replacedValue;
    }

    public void substituteOrderParamters(String node) {
        String replacedValue;
        String value;
        this.getParametersForNode(node);
        this.addSubstituterValues(this.listOfSchedulerParameters);
        this.addSubstituterValues(this.listOfTaskParameters);
        this.addSubstituterValues(this.listOfOrderParameters);
        this.addSubstituterValues(this.jobchainParameters);
        if (this.jobchainParameters != null) {
            for (String key : this.jobchainParameters.keySet()) {
                value = this.jobchainParameters.get(key);
                if (value == null) continue;
                this.listOfOrderParameters.put(key, value);
            }
        }
        if (this.listOfTaskParameters != null) {
            for (String key : this.listOfTaskParameters.keySet()) {
                value = this.listOfTaskParameters.get(key);
                if (value == null) continue;
                replacedValue = this.doReplace(value, "${", "}");
                if ((replacedValue = this.doReplace(replacedValue, "%", "%")).equals(value)) continue;
                this.listOfTaskParameters.put(key, replacedValue);
            }
        }
        if (this.listOfOrderParameters != null) {
            for (String key : this.listOfOrderParameters.keySet()) {
                value = this.listOfOrderParameters.get(key);
                if (value == null) continue;
                replacedValue = this.doReplace(value, "${", "}");
                if ((replacedValue = this.doReplace(replacedValue, "%", "%")).equals(value)) continue;
                this.listOfOrderParameters.put(key, replacedValue);
            }
        }
    }

    public void substituteTaskParamters() {
        this.addSubstituterValues(this.listOfSchedulerParameters);
        this.addSubstituterValues(this.listOfTaskParameters);
        if (this.listOfTaskParameters != null) {
            for (String key : this.listOfTaskParameters.keySet()) {
                String value = this.listOfTaskParameters.get(key);
                if (value == null) continue;
                String replacedValue = this.doReplace(value, "${", "}");
                if ((replacedValue = this.doReplace(replacedValue, "%", "%")).equals(value)) continue;
                this.listOfTaskParameters.put(key, replacedValue);
            }
        }
    }

    public String getFileContent() throws IOException {
        if (this.jobChainNodeConfigurationFile != null && this.jobChainNodeConfigurationFile.exists()) {
            this.jobChainNodeConfigurationFile.close();
            return this.jobChainNodeConfigurationFile.getContent();
        }
        return this.orderPayload;
    }

    public void setJobChainNodeConfigurationFileName(String jobChainNodeConfigurationFileName) {
        this.jobChainNodeConfigurationFileName = jobChainNodeConfigurationFileName.trim();
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setOrderPayload(String orderPayload) {
        this.orderPayload = orderPayload;
    }

    public void setLiveFolder(String liveFolder) {
        this.liveFolder = liveFolder;
    }

    public void setListOfOrderParameters(Map<String, String> listOfOrderParameters) {
        this.listOfOrderParameters = listOfOrderParameters;
    }

    public void setListOfSchedulerParameters(Map<String, String> listOfSchedulerParameters) {
        this.listOfSchedulerParameters = listOfSchedulerParameters;
    }

    public Map<String, String> getListOfSchedulerParameters() {
        return this.listOfSchedulerParameters;
    }

    public Map<String, String> getListOfOrderParameters() {
        return this.listOfOrderParameters;
    }

    public void setJobChainPath(String jobChainPath) {
        this.jobChainPath = jobChainPath;
    }

    public Map<String, String> getListOfTaskParameters() {
        return this.listOfTaskParameters;
    }

    public void setListOfTaskParameters(Map<String, String> listOfTaskParameters) {
        this.listOfTaskParameters = listOfTaskParameters;
    }

    public ParameterSubstitutor getParameterSubstitutor() {
        if (this.parameterSubstitutor == null) {
            this.parameterSubstitutor = new ParameterSubstitutor();
        }
        return this.parameterSubstitutor;
    }
}

