/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.sos.jitl.jobstreams.interfaces.IJSJobConditionKey;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="JSTREAM_OUT_CONDITIONS")
@SequenceGenerator(name="JSTREAM_OUT_COND_ID_SEQ", sequenceName="JSTREAM_OUT_COND_ID_SEQ", allocationSize=1)
public class DBItemOutCondition
implements IJSJobConditionKey {
    private Long id;
    private String schedulerId;
    private String job;
    private String expression;
    private String jobStream;
    private String folder;
    private Date created;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="JSTREAM_OUT_COND_ID_SEQ")
    @Column(name="[ID]")
    public Long getId() {
        return this.id;
    }

    @Id
    @Column(name="[ID]")
    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="[SCHEDULER_ID]", nullable=false)
    public String getSchedulerId() {
        return this.schedulerId;
    }

    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }

    @Override
    @Column(name="[JOB]", nullable=false)
    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    @Column(name="[EXPRESSION]", nullable=false)
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    @Column(name="[JOBSTREAM]", nullable=true)
    public String getJobStream() {
        return this.jobStream;
    }

    public void setJobStream(String jobStream) {
        this.jobStream = jobStream;
    }

    @Column(name="[FOLDER]", nullable=true)
    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public Date getCreated() {
        return this.created;
    }

    @Column(name="[CREATED]", nullable=false)
    public void setCreated(Date created) {
        this.created = created;
    }

    @Transient
    public String getPath() {
        Path path = Paths.get(this.job, new String[0]);
        return path.getParent().toString().replace("\\", "/");
    }

    @Override
    @Transient
    public String getJobSchedulerId() {
        return this.getSchedulerId();
    }
}

