/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.jobstreams.db.DBItemConsumedInCondition;
import com.sos.jitl.jobstreams.db.DBItemInCondition;
import com.sos.jitl.jobstreams.db.FilterConsumedInConditions;
import java.io.Serializable;
import java.util.List;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerConsumedInConditions {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerConsumedInConditions.class);
    private static final String DBItemConsumedInCondition = DBItemConsumedInCondition.class.getSimpleName();
    private static final String DBItemInCondition = DBItemInCondition.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerConsumedInConditions(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemConsumedInCondition getConsumedConditionsDbItem(Long id) throws Exception {
        return (DBItemConsumedInCondition)this.sosHibernateSession.get(DBItemConsumedInCondition.class, (Serializable)id);
    }

    public FilterConsumedInConditions resetFilter() {
        FilterConsumedInConditions filter = new FilterConsumedInConditions();
        filter.setSession("");
        return filter;
    }

    private String getWhere(FilterConsumedInConditions filter) {
        String where = "";
        String and = "";
        if (filter.getSession() != null && !"".equals(filter.getSession())) {
            where = where + and + " c.session = :session";
            and = " and ";
        }
        if (filter.getJobSchedulerId() != null && !"".equals(filter.getJobSchedulerId())) {
            where = where + and + " i.schedulerId = :schedulerId";
            and = " and ";
        }
        if (filter.getInConditionId() != null) {
            where = where + and + " c.inConditionId = :inConditionId";
            and = " and ";
        }
        if (filter.getJoin() != null && !"".equals(filter.getJoin())) {
            where = where + and + filter.getJoin();
            and = " and ";
        }
        where = " where " + where;
        return where;
    }

    private String getDeleteWhere(FilterConsumedInConditions filter) {
        String where = "";
        String and = "";
        if (filter.getJobSchedulerId() != null && !"".equals(filter.getJobSchedulerId())) {
            where = where + and + " schedulerId = :schedulerId";
            and = " and ";
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            where = where + and + " jobStream = :jobStream";
            and = " and ";
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            where = where + and + " folder = :folder";
            and = " and ";
        }
        if (filter.getJob() != null && !"".equals(filter.getJob())) {
            where = where + and + " job = :job";
            and = " and ";
        }
        where = " where " + where;
        return where;
    }

    private <T> Query<T> bindParameters(FilterConsumedInConditions filter, Query<T> query) {
        if (filter.getJobSchedulerId() != null && !"".equals(filter.getJobSchedulerId())) {
            query.setParameter("schedulerId", (Object)filter.getJobSchedulerId());
        }
        if (filter.getSession() != null && !"".equals(filter.getSession())) {
            query.setParameter("session", (Object)filter.getSession());
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            query.setParameter("jobStream", (Object)filter.getJobStream());
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            query.setParameter("folder", (Object)filter.getFolder());
        }
        if (filter.getJob() != null && !"".equals(filter.getJob())) {
            query.setParameter("job", (Object)filter.getJob());
        }
        if (filter.getInConditionId() != null) {
            query.setParameter("inConditionId", (Object)filter.getInConditionId());
        }
        return query;
    }

    public List<DBItemConsumedInCondition> getConsumedInConditionsList(FilterConsumedInConditions filter, int limit) throws SOSHibernateException {
        filter.setJoin("i.id=c.inConditionId");
        String q = "select c from " + DBItemInCondition + " i, " + DBItemConsumedInCondition + " c " + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DBItemConsumedInCondition> getConsumedInConditionsListByJob(FilterConsumedInConditions filter, int limit) throws SOSHibernateException {
        String q = "select c from " + DBItemConsumedInCondition + " c, " + DBItemInCondition + " i where i.schedulerId=:schedulerId and c.inConditionId = i.id and c.session=:session and i.job=:job";
        Query query = this.sosHibernateSession.createQuery(q);
        query.setParameter("schedulerId", (Object)filter.getJobSchedulerId());
        query.setParameter("session", (Object)filter.getSession());
        query.setParameter("job", (Object)filter.getJob());
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public int deleteByInConditionId(FilterConsumedInConditions filterConsumedInConditions) throws SOSHibernateException {
        String hql = "delete from " + DBItemConsumedInCondition + " c " + this.getWhere(filterConsumedInConditions);
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filterConsumedInConditions, query);
        int row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public int deleteConsumedInConditions(FilterConsumedInConditions filterConsumedInConditions) throws SOSHibernateException {
        filterConsumedInConditions.setSession("");
        String select = "select id from " + DBItemInCondition + this.getDeleteWhere(filterConsumedInConditions);
        String hql = "delete from " + DBItemConsumedInCondition + " where inConditionId in ( " + select + ")";
        Query query = this.sosHibernateSession.createQuery(hql);
        this.bindParameters(filterConsumedInConditions, query);
        int row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public int updateConsumedInCondition(Long oldId, Long newId) throws SOSHibernateException {
        String hql = "update " + DBItemConsumedInCondition + " set inConditionId=" + newId + " where inConditionId=:oldId";
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query.setParameter("oldId", (Object)oldId);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public void deleteInsert(DBItemConsumedInCondition dbItemConsumedInCondition) throws SOSHibernateException {
        FilterConsumedInConditions filterConsumedInConditions = new FilterConsumedInConditions();
        filterConsumedInConditions.setSession(dbItemConsumedInCondition.getSession());
        filterConsumedInConditions.setInConditionId(dbItemConsumedInCondition.getInConditionId());
        this.deleteByInConditionId(filterConsumedInConditions);
        this.sosHibernateSession.save((Object)dbItemConsumedInCondition);
    }

    public void store(DBItemConsumedInCondition dbItemConsumedInCondition) throws SOSHibernateException {
        this.sosHibernateSession.save((Object)dbItemConsumedInCondition);
    }
}

