/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.jobstreams.db.DBItemInCondition;
import com.sos.jitl.jobstreams.db.DBItemInConditionCommand;
import com.sos.jitl.jobstreams.db.DBItemInConditionWithCommand;
import com.sos.jitl.jobstreams.db.DBLayerConsumedInConditions;
import com.sos.jitl.jobstreams.db.DBLayerInConditionCommands;
import com.sos.jitl.jobstreams.db.FilterConsumedInConditions;
import com.sos.jitl.jobstreams.db.FilterInConditionCommands;
import com.sos.jitl.jobstreams.db.FilterInConditions;
import com.sos.joc.model.jobstreams.InCondition;
import com.sos.joc.model.jobstreams.InConditions;
import com.sos.joc.model.jobstreams.JobInCondition;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerInConditions {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerInConditions.class);
    private static final String DBItemInCondition = DBItemInCondition.class.getSimpleName();
    private static final String DBItemInConditionCommand = DBItemInConditionCommand.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerInConditions(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemInCondition getConditionsDbItem(Long id) throws Exception {
        return (DBItemInCondition)this.sosHibernateSession.get(DBItemInCondition.class, (Serializable)id);
    }

    public FilterInConditions resetFilter() {
        FilterInConditions filter = new FilterInConditions();
        filter.setJobSchedulerId("");
        filter.setJob("");
        filter.setJobStream("");
        return filter;
    }

    private String getWhere(FilterInConditions filter) {
        String where = "";
        String and = "";
        if (filter.getJobSchedulerId() != null && !"".equals(filter.getJobSchedulerId())) {
            where = where + and + " i.schedulerId = :schedulerId";
            and = " and ";
        }
        if (filter.getJob() != null && !"".equals(filter.getJob())) {
            where = where + and + " i.job = :job";
            and = " and ";
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            where = where + and + " i.jobStream = :jobStream";
            and = " and ";
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            where = where + and + " i.folder = :folder";
            and = " and ";
        }
        if (filter.getJoin() != null && !"".equals(filter.getJoin())) {
            where = where + and + filter.getJoin();
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    private <T> Query<T> bindParameters(FilterInConditions filter, Query<T> query) {
        if (filter.getJobSchedulerId() != null && !"".equals(filter.getJobSchedulerId())) {
            query.setParameter("schedulerId", (Object)filter.getJobSchedulerId());
        }
        if (filter.getJob() != null && !"".equals(filter.getJob())) {
            query.setParameter("job", (Object)filter.getJob());
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            query.setParameter("folder", (Object)filter.getFolder());
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            query.setParameter("jobStream", (Object)filter.getJobStream());
        }
        return query;
    }

    public List<DBItemInConditionWithCommand> getInConditionsList(FilterInConditions filter, int limit) throws SOSHibernateException {
        filter.setJoin("i.id=c.inConditionId");
        String q = "select i.id as incId,i.schedulerId as jobSchedulerId,i.job as job,i.expression as expression,i.markExpression as markExpression,i.skipOutCondition as skipOutCondition,i.jobStream as jobStream,i.folder as folder,i.nextPeriod as nextPeriod,c.id as commandId,c.inConditionId as inConditionId,c.command as command,c.commandParam  as commandParam from " + DBItemInCondition + " i, " + DBItemInConditionCommand + " c " + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query.setResultTransformer(Transformers.aliasToBean(DBItemInConditionWithCommand.class));
        query = this.bindParameters(filter, query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DBItemInCondition> getSimpleInConditionsList(FilterInConditions filter, int limit) throws SOSHibernateException {
        String q = "  from " + DBItemInCondition + " i  " + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public int delete(FilterInConditions filterInConditions) throws SOSHibernateException {
        String hql = "delete from " + DBItemInCondition + " i " + this.getWhere(filterInConditions);
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filterInConditions, query);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    private Boolean getBoolean(Boolean b, Boolean efault) {
        if (b == null) {
            return efault;
        }
        return b;
    }

    public void deleteCascading(FilterInConditions filterInConditions) throws SOSHibernateException {
        DBLayerInConditionCommands dbLayerInConditionCommands = new DBLayerInConditionCommands(this.sosHibernateSession);
        DBLayerConsumedInConditions dbLayerConsumedInConditions = new DBLayerConsumedInConditions(this.sosHibernateSession);
        FilterInConditionCommands filterInConditionCommands = new FilterInConditionCommands();
        filterInConditionCommands.setJobStream(filterInConditions.getJobStream());
        filterInConditionCommands.setFolder(filterInConditions.getFolder());
        dbLayerInConditionCommands.deleteCommandWithInConditions(filterInConditionCommands);
        FilterConsumedInConditions filterConsumedInConditions = new FilterConsumedInConditions();
        filterConsumedInConditions.setJobStream(filterInConditions.getJobStream());
        filterConsumedInConditions.setFolder(filterInConditions.getFolder());
        dbLayerConsumedInConditions.deleteConsumedInConditions(filterConsumedInConditions);
        this.delete(filterInConditions);
    }

    public void deleteInsert(InConditions inConditions) throws SOSHibernateException {
        DBLayerInConditionCommands dbLayerInConditionCommands = new DBLayerInConditionCommands(this.sosHibernateSession);
        DBLayerConsumedInConditions dbLayerConsumedInConditions = new DBLayerConsumedInConditions(this.sosHibernateSession);
        for (JobInCondition jobInCondition : inConditions.getJobsInconditions()) {
            if ("".equals(jobInCondition.getJob())) continue;
            String folder = Paths.get(jobInCondition.getJob(), new String[0]).getParent().toString().replace('\\', '/');
            DBLayerInConditions dbLayerInConditions = new DBLayerInConditions(this.sosHibernateSession);
            FilterInConditions filterInConditions = new FilterInConditions();
            filterInConditions.setJob(jobInCondition.getJob());
            filterInConditions.setJobSchedulerId(inConditions.getJobschedulerId());
            List<DBItemInCondition> listOfInCondititinos = dbLayerInConditions.getSimpleInConditionsList(filterInConditions, 0);
            this.delete(filterInConditions);
            for (InCondition inCondition : jobInCondition.getInconditions()) {
                Long oldId = inCondition.getId();
                DBItemInCondition dbItemInCondition = new DBItemInCondition();
                String expression = inCondition.getConditionExpression().getExpression();
                if (expression == null || expression.isEmpty()) {
                    expression = "false";
                }
                dbItemInCondition.setExpression(expression);
                dbItemInCondition.setJob(jobInCondition.getJob());
                dbItemInCondition.setSchedulerId(inConditions.getJobschedulerId());
                dbItemInCondition.setJobStream(inCondition.getJobStream());
                dbItemInCondition.setFolder(folder);
                dbItemInCondition.setMarkExpression(this.getBoolean(inCondition.getMarkExpression(), true));
                dbItemInCondition.setSkipOutCondition(this.getBoolean(inCondition.getSkipOutCondition(), false));
                dbItemInCondition.setCreated(new Date());
                this.sosHibernateSession.save((Object)dbItemInCondition);
                dbLayerInConditionCommands.deleteInsert(dbItemInCondition, inCondition);
                Long newId = dbItemInCondition.getId();
                if (oldId == null) continue;
                dbLayerConsumedInConditions.updateConsumedInCondition(oldId, newId);
            }
            for (DBItemInCondition dbItemInCondition : listOfInCondititinos) {
                FilterInConditionCommands filterInConditionCommands = new FilterInConditionCommands();
                filterInConditionCommands.setInConditionId(dbItemInCondition.getId());
                dbLayerInConditionCommands.deleteByInConditionId(filterInConditionCommands);
                FilterConsumedInConditions filterConsumedInConditions = new FilterConsumedInConditions();
                filterConsumedInConditions.setInConditionId(dbItemInCondition.getId());
                dbLayerConsumedInConditions.deleteByInConditionId(filterConsumedInConditions);
            }
        }
    }
}

