/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.classes.SearchStringHelper;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.jobstreams.db.DBItemJobStreamHistory;
import com.sos.jitl.jobstreams.db.DBLayerEvents;
import com.sos.jitl.jobstreams.db.DBLayerJobStreamsTaskContext;
import com.sos.jitl.jobstreams.db.FilterEvents;
import com.sos.jitl.jobstreams.db.FilterJobStreamHistory;
import com.sos.jitl.jobstreams.db.FilterJobStreamTaskContext;
import java.io.Serializable;
import java.util.List;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerJobStreamHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerJobStreamHistory.class);
    private static final String DBItemJobStreamHistory = DBItemJobStreamHistory.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerJobStreamHistory(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemJobStreamHistory getJobStreamHistoryDbItem(Long id) throws SOSHibernateException {
        return (DBItemJobStreamHistory)this.sosHibernateSession.get(DBItemJobStreamHistory.class, (Serializable)id);
    }

    public FilterJobStreamHistory resetFilter() {
        FilterJobStreamHistory filter = new FilterJobStreamHistory();
        return filter;
    }

    private String getWhere(FilterJobStreamHistory filter) {
        String where = " ";
        String and = "  ";
        if (filter.getId() != null) {
            where = where + and + " id = :id";
            and = " and ";
        }
        if (filter.getRunning() != null && filter.getRunning().booleanValue() || filter.getCompleted() != null && filter.getCompleted().booleanValue()) {
            where = where + and + " running = :running";
            and = " and ";
        }
        if (filter.getListContextIds() != null && !filter.getListContextIds().isEmpty() && filter.getListContextIds().size() == 1) {
            where = where + and + " contextId  = :contextId";
            and = " and ";
        }
        if (filter.getListContextIds() != null && !filter.getListContextIds().isEmpty() && filter.getListContextIds().size() > 1) {
            where = where + and + SearchStringHelper.getStringListSql(filter.getListContextIds(), (String)"contextId");
            and = " and ";
        }
        if (filter.getSchedulerId() != null && !filter.getSchedulerId().isEmpty()) {
            where = where + and + " schedulerId  = :schedulerId";
            and = " and ";
        }
        if (filter.getJobStreamStarter() != null) {
            where = where + and + " jobStreamStarter  = :jobStreamStarter";
            and = " and ";
        }
        if (filter.getJobStreamId() != null) {
            where = where + and + " jobStream  = :jobStream";
            and = " and ";
        }
        if (filter.getStartedFrom() != null) {
            where = where + and + " started>= :startedFrom";
            and = " and ";
        }
        if (filter.getStartedTo() != null) {
            where = where + and + " started < :startedTo ";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = " where " + where;
        }
        return where;
    }

    private <T> Query<T> bindParameters(FilterJobStreamHistory filter, Query<T> query) {
        if (filter.getId() != null) {
            query.setParameter("id", (Object)filter.getId());
        }
        if (filter.getRunning() != null && filter.getRunning().booleanValue()) {
            query.setParameter("running", (Object)true);
        }
        if (filter.getCompleted() != null && filter.getCompleted().booleanValue()) {
            query.setParameter("running", (Object)false);
        }
        if (filter.getJobStreamStarter() != null) {
            query.setParameter("jobStreamStarter", (Object)filter.getJobStreamStarter());
        }
        if (filter.getJobStreamId() != null) {
            query.setParameter("jobStream", (Object)filter.getJobStreamId());
        }
        if (filter.getSchedulerId() != null && !filter.getSchedulerId().isEmpty()) {
            query.setParameter("schedulerId", (Object)filter.getSchedulerId());
        }
        if (filter.getStartedFrom() != null) {
            query.setParameter("startedFrom", (Object)filter.getStartedFrom());
        }
        if (filter.getStartedTo() != null) {
            query.setParameter("startedTo", (Object)filter.getStartedTo());
        }
        if (filter.getListContextIds() != null && !filter.getListContextIds().isEmpty() && filter.getListContextIds().size() == 1) {
            query.setParameter("contextId", (Object)filter.getListContextIds().get(0));
        }
        return query;
    }

    public List<DBItemJobStreamHistory> getJobStreamHistoryList(FilterJobStreamHistory filter, int limit) throws SOSHibernateException {
        String q = "  from " + DBItemJobStreamHistory + this.getWhere(filter) + " order by id desc";
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public Integer delete(FilterJobStreamHistory filter) throws SOSHibernateException {
        int row = 0;
        String hql = "";
        hql = "delete from " + DBItemJobStreamHistory + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filter, query);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public void save(DBItemJobStreamHistory dbItemJobStreamHistory) throws SOSHibernateException {
        this.sosHibernateSession.save((Object)dbItemJobStreamHistory);
    }

    public void update(DBItemJobStreamHistory dbItemJobStreamHistory) throws SOSHibernateException {
        this.sosHibernateSession.update((Object)dbItemJobStreamHistory);
    }

    public void deleteCascading(FilterJobStreamHistory filterJobStreamHistory) throws SOSHibernateException {
        DBLayerJobStreamsTaskContext dbLayerJobStreamTasksContext = new DBLayerJobStreamsTaskContext(this.sosHibernateSession);
        DBLayerEvents dbLayerEvents = new DBLayerEvents(this.sosHibernateSession);
        List<DBItemJobStreamHistory> lHistory = this.getJobStreamHistoryList(filterJobStreamHistory, 0);
        if (filterJobStreamHistory.getListContextIds() != null && !filterJobStreamHistory.getListContextIds().isEmpty()) {
            for (String contextId : filterJobStreamHistory.getListContextIds()) {
                FilterJobStreamTaskContext filterJobStreamTaskContext = new FilterJobStreamTaskContext();
                filterJobStreamTaskContext.setJobstreamHistoryId(contextId);
                dbLayerJobStreamTasksContext.delete(filterJobStreamTaskContext);
            }
        } else {
            for (DBItemJobStreamHistory dbItemJobStreamHistory : lHistory) {
                FilterJobStreamTaskContext filterJobStreamTaskContext = new FilterJobStreamTaskContext();
                filterJobStreamTaskContext.setJobstreamHistoryId(dbItemJobStreamHistory.getContextId());
                dbLayerJobStreamTasksContext.delete(filterJobStreamTaskContext);
                FilterEvents filterEvents = new FilterEvents();
                filterEvents.setJobStreamHistoryId(dbItemJobStreamHistory.getId());
                dbLayerEvents.delete(filterEvents);
            }
        }
        this.delete(filterJobStreamHistory);
    }

    public int updateHistoryWithStarter(Long oldId, Long newId) throws SOSHibernateException {
        String hql = "update " + DBItemJobStreamHistory + " set jobStreamStarter=" + newId + " where jobStreamStarter=:oldId";
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query.setParameter("oldId", (Object)oldId);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public int updateHistoryWithJobStream(Long oldId, Long newId) throws SOSHibernateException {
        String hql = "update " + DBItemJobStreamHistory + " set jobStream=" + newId + " where jobStream=:oldId";
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query.setParameter("oldId", (Object)oldId);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public int updateHistoryWithJobStreamStarter(Long oldStarterId, Long newStarterId) throws SOSHibernateException {
        String hql = "update " + DBItemJobStreamHistory + " set jobStreamStarter=" + newStarterId + " where jobStreamStarter=:oldStarterId";
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query.setParameter("oldStarterId", (Object)oldStarterId);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public int updateRunning(FilterJobStreamHistory filter, boolean valueRunning) throws SOSHibernateException {
        String hql = "update " + DBItemJobStreamHistory + " set running=:valueRunning" + this.getWhere(filter);
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filter, query);
        query.setParameter("valueRunning", (Object)valueRunning);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }
}

